/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.clazz.edit.policies;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.clazz.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.diagram.clazz.part.UMLVisualIDRegistry;
import org.eclipse.uml2.diagram.clazz.providers.UMLElementTypes;
import org.eclipse.uml2.diagram.common.editpolicies.AbstractPostCreateCommand;
import org.eclipse.uml2.diagram.common.editpolicies.EObjectAndElementTypeAdapter;
import org.eclipse.uml2.uml.AssociationClass;

public class PostCreateAssociationClassEditPolicy
extends AbstractEditPolicy {
    public static final String KEY = String.valueOf(PostCreateAssociationClassEditPolicy.class.getName()) + ":key";

    public Command getCommand(Request request) {
        if (this.understandsRequest(request)) {
            return this.getPostCreateCommand((CreateViewAndElementRequest)request);
        }
        return null;
    }

    public boolean understandsRequest(Request req) {
        if (!(req instanceof CreateViewAndElementRequest)) {
            return false;
        }
        CreateViewAndElementRequest cvaeReq = (CreateViewAndElementRequest)req;
        CreateElementRequestAdapter requestAdapter = cvaeReq.getViewAndElementDescriptor().getCreateElementRequestAdapter();
        CreateElementRequest semanticRequest = (CreateElementRequest)requestAdapter.getAdapter(CreateElementRequest.class);
        return semanticRequest.getElementType() == UMLElementTypes.AssociationClass_2007;
    }

    private Command getPostCreateCommand(CreateViewAndElementRequest cvaeReq) {
        return new ICommandProxy((ICommand)new PostCreateAssociationClassCommand(this.getDomain(), cvaeReq, this.getHostImpl()));
    }

    private IGraphicalEditPart getHostImpl() {
        return (IGraphicalEditPart)this.getHost();
    }

    private TransactionalEditingDomain getDomain() {
        return this.getHostImpl().getEditingDomain();
    }

    private static class PostCreateAssociationClassCommand
    extends AbstractPostCreateCommand {
        private static final int ASSOCIATION_CLASS_DEFAULT_WIDTH = 100;
        private static final int ASSOCIATION_CLASS_DEFAULT_HEIGHT = 90;
        private static final int VERTICAL_GAP = 30;

        public PostCreateAssociationClassCommand(TransactionalEditingDomain domain, CreateViewAndElementRequest cvaeReq, IGraphicalEditPart hostEditPart) {
            super(domain, cvaeReq, hostEditPart, UMLVisualIDRegistry.TYPED_ADAPTER);
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            View createdView = this.getCreatedView();
            EObject createdEntity = this.getCreatedEntity();
            if (!(createdEntity instanceof AssociationClass)) {
                return CommandResult.newErrorCommandResult((String)("Association class expected: " + createdEntity));
            }
            AssociationClass newClass = (AssociationClass)createdEntity;
            EObjectAndElementTypeAdapter rhombAdapter = new EObjectAndElementTypeAdapter((EObject)newClass, (IElementType)UMLElementTypes.AssociationClass_2015);
            Node rhombView = ViewService.getInstance().createNode((IAdaptable)rhombAdapter, (View)createdView.eContainer(), UMLElementTypes.AssociationClass_2015.getSemanticHint(), -1, UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            Rectangle expectedRectangleBounds = new Rectangle();
            expectedRectangleBounds.setLocation(this.getRequestLocation());
            if (this.getRequestSize() != null) {
                expectedRectangleBounds.setSize(this.getRequestSize());
            } else {
                expectedRectangleBounds.setSize(100, 90);
            }
            if (expectedRectangleBounds.height < 0 || expectedRectangleBounds.width < 0) {
                expectedRectangleBounds = new Rectangle(expectedRectangleBounds.getTopLeft(), expectedRectangleBounds.getBottomRight());
            }
            IFigure layoutContainer = this.getHostEditPart().getContentPane();
            layoutContainer.translateToRelative((Translatable)expectedRectangleBounds);
            layoutContainer.translateFromParent((Translatable)expectedRectangleBounds);
            expectedRectangleBounds.translate(layoutContainer.getClientArea().getLocation().getNegated());
            Point rhombTopLeft = expectedRectangleBounds.getTop();
            if (rhombTopLeft.y > 35) {
                rhombTopLeft.translate(0, -30);
            } else {
                rhombTopLeft = expectedRectangleBounds.getBottom();
                rhombTopLeft.translate(0, 30);
            }
            PostCreateAssociationClassCommand.setLocation((View)rhombView, (Point)rhombTopLeft);
            return CommandResult.newOKCommandResult();
        }
    }
}

