/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.draw2d;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.uml2.diagram.common.draw2d.StereotypeLabel;

public class Cube3DFigure
extends Shape {
    public static final int DEFAULT_DEPTH_GAP = 10;
    private int myDepthGap = 10;
    private final int[] myFillPath = new int[14];
    private final RectangleFigure myLabelPane;
    private final RectangleFigure myContentPane;
    private final Label myNameLabel;
    private final StereotypeLabel myTypeLabel;

    public Cube3DFigure() {
        this.setLineWidth(1);
        this.setDepthGap(10);
        this.setLayoutManager((LayoutManager)new StackLayout());
        RectangleFigure insides = new RectangleFigure();
        insides.setBorder((Border)new MarginBorder(1, 1, 1, 1));
        this.add((IFigure)insides);
        insides.setLayoutManager((LayoutManager)new BorderLayout());
        this.myLabelPane = Cube3DFigure.invisibleRectangle();
        ToolbarLayout labelPaneLayout = new ToolbarLayout(false);
        labelPaneLayout.setMinorAlignment(0);
        labelPaneLayout.setSpacing(5);
        this.myLabelPane.setLayoutManager((LayoutManager)labelPaneLayout);
        this.myTypeLabel = Cube3DFigure.stereoLabel();
        this.myNameLabel = Cube3DFigure.wrapLabel();
        this.myLabelPane.add((IFigure)this.myTypeLabel);
        this.myLabelPane.add((IFigure)this.myNameLabel);
        this.myContentPane = Cube3DFigure.invisibleRectangle();
        insides.add((IFigure)this.myLabelPane, (Object)BorderLayout.TOP);
        insides.add((IFigure)this.myContentPane, (Object)BorderLayout.CENTER);
    }

    public void setDepthGap(int depthGap) {
        this.myDepthGap = depthGap;
        this.setBorder((Border)new MarginBorder(this.myDepthGap, 0, 0, this.myDepthGap));
        this.repaint();
    }

    public RectangleFigure getContentPane() {
        return this.myContentPane;
    }

    public RectangleFigure getNamePane() {
        return this.myLabelPane;
    }

    public Label getNameLabel() {
        return this.myNameLabel;
    }

    public StereotypeLabel getTypeLabel() {
        return this.myTypeLabel;
    }

    public void setTypeLabelVisible(boolean visible) {
        this.myTypeLabel.setVisible(visible);
    }

    public void setTypeLabelText(String text) {
        this.myTypeLabel.setText(text);
    }

    protected void outlineShape(Graphics graphics) {
        Rectangle bounds = this.getBounds();
        if (bounds.width < this.myDepthGap * 2 || bounds.height < this.myDepthGap * 2) {
            graphics.drawRectangle(bounds);
            return;
        }
        int x_min = bounds.x;
        int y_min = bounds.y;
        int x_max = bounds.x + bounds.width - 1;
        int y_max = bounds.y + bounds.height - 1;
        int delta = this.myDepthGap;
        graphics.drawLine(x_min, y_min + delta, x_min + delta, y_min);
        graphics.drawLine(x_min + delta, y_min, x_max, y_min);
        graphics.drawLine(x_max, y_min, x_max - delta, y_min + delta);
        graphics.drawLine(x_max, y_min, x_max, y_max - delta);
        graphics.drawLine(x_max, y_max - delta, x_max - delta, y_max);
    }

    protected void fillShape(Graphics graphics) {
        Rectangle bounds = this.getBounds();
        if (bounds.width < this.myDepthGap * 2 || bounds.height < this.myDepthGap * 2) {
            graphics.fillRectangle(bounds);
            return;
        }
        int x_min = bounds.x;
        int y_min = bounds.y;
        int x_max = bounds.x + bounds.width - 1;
        int y_max = bounds.y + bounds.height - 1;
        int delta = this.myDepthGap;
        int i = 0;
        this.myFillPath[i++] = x_min;
        this.myFillPath[i++] = y_min + delta;
        this.myFillPath[i++] = x_min + delta;
        this.myFillPath[i++] = y_min;
        this.myFillPath[i++] = x_max;
        this.myFillPath[i++] = y_min;
        this.myFillPath[i++] = x_max;
        this.myFillPath[i++] = y_max - delta;
        this.myFillPath[i++] = x_max - delta;
        this.myFillPath[i++] = y_max;
        this.myFillPath[i++] = x_max - delta;
        this.myFillPath[i++] = y_min + delta;
        this.myFillPath[i++] = x_min;
        this.myFillPath[i++] = y_min + delta;
        graphics.fillPolygon(this.myFillPath);
    }

    private static RectangleFigure invisibleRectangle() {
        RectangleFigure result = new RectangleFigure();
        result.setOutline(false);
        return result;
    }

    private static Label wrapLabel() {
        Label result = new Label();
        result.setBorder((Border)new MarginBorder(0, 3, 0, 3));
        return result;
    }

    private static StereotypeLabel stereoLabel() {
        StereotypeLabel result = new StereotypeLabel();
        result.setBorder((Border)new MarginBorder(0, 3, 0, 3));
        return result;
    }
}

