/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.profile.parser.metaclass;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class ReplaceReferencedMetaclassCommand
extends SetValueCommand {
    private final List<Extension> myAffectedExtensions;
    private final Class myNewMetaclass;

    public ReplaceReferencedMetaclassCommand(ElementImport elementImport, Class newMetaclass) {
        super(new SetRequest((EObject)elementImport, (EStructuralFeature)UMLPackage.eINSTANCE.getElementImport_ImportedElement(), (Object)newMetaclass));
        this.myNewMetaclass = newMetaclass;
        this.myAffectedExtensions = new LinkedList<Extension>();
        PackageableElement oldMetaclass = elementImport.getImportedElement();
        if (ReplaceReferencedMetaclassCommand.isImportedMetaclass(oldMetaclass) && elementImport.getImportingNamespace() instanceof Profile) {
            Profile profile = (Profile)elementImport.getImportingNamespace();
            for (Object next : profile.getOwnedExtensions(false)) {
                Extension nextExtension = (Extension)next;
                if (!oldMetaclass.equals(nextExtension.getMetaclass())) continue;
                this.myAffectedExtensions.add(nextExtension);
            }
        }
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        for (Extension next : this.myAffectedExtensions) {
            this.replaceExtension(next, this.myNewMetaclass);
        }
        return super.doExecuteWithResult(monitor, info);
    }

    private void replaceExtension(Extension extension, Class newMetaclass) {
        Stereotype stereotype = extension.getStereotype();
        if (stereotype == null) {
            return;
        }
        Property metaclassEnd = extension.metaclassEnd();
        String newExtensionName = String.valueOf(newMetaclass.getName()) + "_" + stereotype.getName();
        String newPropertyName = "base_" + newMetaclass.getName();
        extension.setName(newExtensionName);
        metaclassEnd.setName(newPropertyName);
        metaclassEnd.setType((Type)newMetaclass);
    }

    private static boolean isImportedMetaclass(PackageableElement oldImported) {
        return oldImported instanceof Class && ((Class)oldImported).isMetaclass();
    }
}

