/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.parser.imports;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.uml2.diagram.common.Messages;
import org.eclipse.uml2.diagram.common.parser.ElementProvider;
import org.eclipse.uml2.diagram.common.parser.imports.ElementImportProvider;
import org.eclipse.uml2.diagram.parser.assist.EObjectCompletionProcessor;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementImportParser
implements ISemanticParser {
    private final ElementProvider myElementProvider;
    private final CompletionProcessor myCompletionProcessor = new CompletionProcessor();
    private static final String UNDEFINED_VALUE = Messages.ElementImportParser_undefined_value;
    private static final String PLUGIN_ID = "org.eclipse.uml2.diagram.common";

    public ElementImportParser() {
        this(new ElementImportProvider());
    }

    public ElementImportParser(ElementProvider elementProvider) {
        this.myElementProvider = elementProvider;
    }

    public List<?> getSemanticElementsBeingParsed(EObject eObject) {
        ElementImport immport = (ElementImport)eObject;
        LinkedList<EObject> result = new LinkedList<EObject>(){

            @Override
            public boolean add(EObject o) {
                if (o == null) {
                    return false;
                }
                return super.add(o);
            }
        };
        result.add((EObject)immport);
        result.add((EObject)immport.getImportedElement());
        return result;
    }

    public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
        this.myCompletionProcessor.setContext((EObject)this.doAdapt(element));
        return this.myCompletionProcessor;
    }

    public String getEditString(IAdaptable element, int flags) {
        String alias;
        StringBuffer result = new StringBuffer();
        ElementImport subject = this.doAdapt(element);
        PackageableElement importedElement = subject.getImportedElement();
        if (importedElement != null) {
            String fqn = importedElement.getQualifiedName();
            if (this.isEmpty(fqn)) {
                fqn = importedElement.getName();
            }
            if (!this.isEmpty(fqn)) {
                result.append(fqn);
            }
        } else {
            result.append(UNDEFINED_VALUE);
        }
        if (!this.isEmpty(alias = subject.getAlias())) {
            result.append(" as ");
            result.append(alias);
        }
        return result.toString();
    }

    public String getPrintString(IAdaptable element, int flags) {
        return this.getEditString(element, flags);
    }

    public ICommand getParseCommand(IAdaptable element, String newString, int flags) {
        PackageableElement imported = this.findElement(element, newString);
        if (imported == null) {
            return UnexecutableCommand.INSTANCE;
        }
        ElementImport elementImport = this.doAdapt(element);
        if (imported.equals(elementImport.getImportedElement())) {
            return UnexecutableCommand.INSTANCE;
        }
        return new SetValueCommand(new SetRequest((EObject)elementImport, (EStructuralFeature)UMLPackage.eINSTANCE.getElementImport_ImportedElement(), (Object)imported));
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        return this.isAffectingEvent(notification);
    }

    public boolean isAffectingEvent(Object event, int flags) {
        return this.isAffectingEvent(event);
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        PackageableElement imported = this.findElement(element, editString);
        if (imported == null) {
            return new ParserEditStatus(4, PLUGIN_ID, 1, "Unknown metaclass: " + editString, null);
        }
        return ParserEditStatus.EDITABLE_STATUS;
    }

    private PackageableElement findElement(IAdaptable parserElement, String editString) {
        if (editString == null) {
            return null;
        }
        if ((editString = editString.trim()).length() == 0) {
            return null;
        }
        return this.myElementProvider.findElement((EObject)this.doAdapt(parserElement), editString);
    }

    private ElementImport doAdapt(IAdaptable adaptable) {
        ElementImport element = (ElementImport)adaptable.getAdapter(EObject.class);
        return element;
    }

    private boolean isEmpty(String text) {
        return text == null || text.length() == 0;
    }

    private boolean isAffectingEvent(Object notification) {
        if (notification instanceof Notification) {
            Object feature = ((Notification)notification).getFeature();
            return feature == UMLPackage.eINSTANCE.getNamedElement_Name() || feature == UMLPackage.eINSTANCE.getElementImport_Alias() || feature == UMLPackage.eINSTANCE.getElementImport_ImportedElement();
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompletionProcessor
    extends EObjectCompletionProcessor {
        private CompletionProcessor() {
        }

        protected Iterable<String> computeContextProposals(EObject context) {
            return ElementImportParser.this.myElementProvider.getElementNames(context);
        }
    }
}

