/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.draw2d;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Rectangle;

public class PartialRectangleFigure
extends RectangleFigure {
    private boolean myIsTopShown = true;
    private boolean myIsBottomShown = true;
    private boolean myIsLeftShown = true;
    private boolean myIsRightShown = true;

    public PartialRectangleFigure() {
        this.setLineWidth(1);
        this.setOutline(true);
        this.setFill(true);
    }

    protected void outlineShape(Graphics graphics) {
        int lineInset = (int)Math.ceil(Math.max(1.0, (double)this.getLineWidthFloat() / 2.0));
        Rectangle r = Rectangle.SINGLETON.setBounds(this.getBounds());
        r.x += lineInset - 1;
        r.y += lineInset - 1;
        r.width -= lineInset + lineInset - 1;
        r.height -= lineInset + lineInset - 1;
        if (this.myIsBottomShown && this.myIsLeftShown && this.myIsRightShown && this.myIsTopShown) {
            graphics.drawRectangle(r);
            return;
        }
        int left = r.x;
        int right = r.x + r.width;
        int top = r.y;
        int bottom = r.y + r.height;
        if (this.myIsTopShown) {
            graphics.drawLine(left, top, right, top);
        }
        if (this.myIsBottomShown) {
            graphics.drawLine(left, bottom, right, bottom);
        }
        if (this.myIsLeftShown) {
            graphics.drawLine(left, top, left, bottom);
        }
        if (this.myIsRightShown) {
            graphics.drawLine(right, top, right, bottom);
        }
    }

    public void setLeftShown(boolean isLeftShown) {
        if (this.myIsLeftShown != isLeftShown) {
            this.myIsLeftShown = isLeftShown;
            this.repaint();
        }
    }

    public void setRightShown(boolean isRightShown) {
        if (this.myIsRightShown != isRightShown) {
            this.myIsRightShown = isRightShown;
            this.repaint();
        }
    }

    public void setTopShown(boolean isTopShown) {
        if (this.myIsTopShown != isTopShown) {
            this.myIsTopShown = isTopShown;
            this.repaint();
        }
    }

    public void setBottomShown(boolean isBottomShown) {
        if (this.myIsBottomShown != isBottomShown) {
            this.myIsBottomShown = isBottomShown;
            this.repaint();
        }
    }
}

