/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.ecore.exporter;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.codegen.ecore.genmodel.GenAnnotation;
import org.eclipse.emf.codegen.ecore.genmodel.GenBase;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.exporter.ModelExporter;
import org.eclipse.emf.exporter.util.ExporterUtil;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.ecore.exporter.UMLExporterPlugin;
import org.eclipse.uml2.uml.util.UMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLExporter
extends ModelExporter {
    protected final Map<String, String> options = new HashMap<String, String>();

    public Map<String, String> getOptions() {
        return this.options;
    }

    public String getID() {
        return "org.eclipse.uml2.uml.ecore.exporter";
    }

    protected String getDefaultArtifactLocation(EPackage ePackage) {
        return String.valueOf(this.getDefaultArtifactFileName(ePackage)) + '.' + "uml";
    }

    protected String doCheckEPackageArtifactLocation(String location, String packageName) {
        if (!location.endsWith(".uml")) {
            return UMLExporterPlugin.INSTANCE.getString("_UI_InvalidArtifactFileNameExtension_message");
        }
        return super.doCheckEPackageArtifactLocation(location, packageName);
    }

    protected Diagnostic doExport(Monitor monitor, ModelExporter.ExportData exportData) throws Exception {
        Diagnostic diagnostic = Diagnostic.OK_INSTANCE;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        UMLUtil.Ecore2UMLConverter ecore2umlConverter = new UMLUtil.Ecore2UMLConverter();
        BasicDiagnostic diagnostics = new BasicDiagnostic("org.eclipse.emf.converter", 0, UMLExporterPlugin.INSTANCE.getString("_UI_ProblemsEncounteredProcessing_message"), null);
        HashMap<Class<UML2Util.QualifiedTextProvider>, UMLUtil.QualifiedTextProvider> context = new HashMap<Class<UML2Util.QualifiedTextProvider>, UMLUtil.QualifiedTextProvider>();
        context.put(UML2Util.QualifiedTextProvider.class, UMLUtil.QualifiedTextProvider.DEFAULT);
        monitor.beginTask("", exportData.genPackageToArtifactURI.size());
        for (Map.Entry entry : exportData.genPackageToArtifactURI.entrySet()) {
            URI artifactURI = (URI)entry.getValue();
            Resource resource = resourceSet.createResource(artifactURI);
            EPackage ePackage = ((GenPackage)entry.getKey()).getEcorePackage();
            monitor.subTask(UMLExporterPlugin.INSTANCE.getString("_UI_Exporting_message", new Object[]{artifactURI.toString()}));
            ecore2umlConverter.convert((Collection)Collections.singleton(ePackage), this.getOptions(), (DiagnosticChain)diagnostics, context);
            Package package_ = (Package)ecore2umlConverter.doSwitch((EObject)ePackage);
            EList contents = resource.getContents();
            contents.add((Object)package_);
            TreeIterator allContents = UML2Util.getAllContents((EObject)package_, (boolean)true, (boolean)false);
            while (allContents.hasNext()) {
                EObject eObject = (EObject)allContents.next();
                if (!(eObject instanceof Element)) continue;
                contents.addAll((Collection)((Element)eObject).getStereotypeApplications());
            }
            monitor.worked(1);
        }
        for (Resource resource : resourceSet.getResources()) {
            resource.save(null);
        }
        monitor.done();
        if (1 < diagnostics.getSeverity()) {
            diagnostic = diagnostics;
        }
        return diagnostic;
    }

    protected boolean isValidEPackage(GenPackage genPackage) {
        EPackage ecorePackage = genPackage.getEcorePackage();
        return ecorePackage != null && ecorePackage.getESuperPackage() == null;
    }

    public void setGenModel(GenModel genModel) throws DiagnosticException {
        super.setGenModel(genModel);
        Ecore2UMLConverter converter = new Ecore2UMLConverter();
        ModelExporter.GenPackagesTreeIterator genPackages = new ModelExporter.GenPackagesTreeIterator(genModel);
        while (genPackages.hasNext()) {
            GenPackage genPackage = (GenPackage)genPackages.next();
            if (!this.isValidEPackage(genPackage)) continue;
            converter.convert(Collections.singleton(genPackage.getEcorePackage()), this.getOptions(), null, null);
        }
        Map ePackageToGenPackageMap = this.getEPackageToGenPackageMap();
        for (EPackage convertedEPackage : converter.getEcorePackages()) {
            GenPackage convertedGenPackage = genModel.findGenPackage(convertedEPackage);
            if (convertedGenPackage == null || !this.isValidEPackage(convertedGenPackage)) continue;
            ePackageToGenPackageMap.put(convertedEPackage, convertedGenPackage);
            this.getEPackages().add(convertedEPackage);
        }
        this.adjustGenModel();
        genModel = this.getGenModel();
        if (genModel != null) {
            this.getOptions().putAll(ExporterUtil.findOrCreateGenAnnotation((GenBase)genModel, (String)this.getConverterGenAnnotationSource()).getDetails().map());
        }
    }

    protected boolean saveExporter() {
        boolean changed = super.saveExporter();
        GenModel genModel = this.getGenModel();
        GenAnnotation genAnnotation = genModel.getGenAnnotation(this.getConverterGenAnnotationSource());
        if (genAnnotation == null) {
            changed = true;
            ExporterUtil.findOrCreateGenAnnotation((GenBase)genModel, (String)this.getConverterGenAnnotationSource()).getDetails().putAll(this.getOptions());
        } else {
            EMap details = genAnnotation.getDetails();
            for (Map.Entry<String, String> entry : this.getOptions().entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (value.equals(details.get((Object)key))) continue;
                changed = true;
                details.put((Object)key, (Object)value);
            }
        }
        return changed;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Ecore2UMLConverter
    extends UMLUtil.Ecore2UMLConverter {
        private Ecore2UMLConverter() {
        }

        private Collection<EPackage> getEcorePackages() {
            return EcoreUtil.getObjectsByType((Collection)this.eModelElementToElementMap.keySet(), (EClassifier)EcorePackage.Literals.EPACKAGE);
        }
    }
}

