/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.edit.providers;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.uml2.common.edit.command.SubsetAddCommand;
import org.eclipse.uml2.common.edit.command.SubsetSupersetReplaceCommand;
import org.eclipse.uml2.common.edit.command.SubsetSupersetSetCommand;
import org.eclipse.uml2.common.edit.command.SupersetRemoveCommand;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.DeployedArtifact;
import org.eclipse.uml2.uml.Deployment;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.edit.UMLEditPlugin;
import org.eclipse.uml2.uml.edit.providers.DependencyItemProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentItemProvider
extends DependencyItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public DeploymentItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addDeployedArtifactPropertyDescriptor(object);
            this.addConfigurationPropertyDescriptor(object);
            this.addLocationPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addDeployedArtifactPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Deployment_deployedArtifact_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Deployment_deployedArtifact_feature", "_UI_Deployment_type"), (EStructuralFeature)UMLPackage.Literals.DEPLOYMENT__DEPLOYED_ARTIFACT, true, false, true, null, null, null));
    }

    protected void addConfigurationPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Deployment_configuration_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Deployment_configuration_feature", "_UI_Deployment_type"), (EStructuralFeature)UMLPackage.Literals.DEPLOYMENT__CONFIGURATION, true, false, true, null, null, new String[]{"org.eclipse.ui.views.properties.expert"}));
    }

    protected void addLocationPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Deployment_location_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Deployment_location_feature", "_UI_Deployment_type"), (EStructuralFeature)UMLPackage.Literals.DEPLOYMENT__LOCATION, true, false, true, null, null, new String[]{"org.eclipse.ui.views.properties.expert"}));
    }

    @Override
    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(UMLPackage.Literals.DEPLOYMENT__CONFIGURATION);
        }
        return this.childrenFeatures;
    }

    @Override
    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    @Override
    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Deployment"));
    }

    @Override
    public String getText(Object object) {
        StringBuffer text = this.appendType(this.appendKeywords(new StringBuffer(), object), "_UI_Deployment_type");
        Deployment deployment = (Deployment)object;
        String label = deployment.getLabel(this.shouldTranslate());
        if (!UML2Util.isEmpty((String)label)) {
            this.appendString(text, label);
        } else {
            Iterator deployedArtifacts = deployment.getDeployedArtifacts().iterator();
            while (deployedArtifacts.hasNext()) {
                DeployedArtifact deployedArtifact = (DeployedArtifact)deployedArtifacts.next();
                String deployedArtifactLabel = deployedArtifact.getLabel(this.shouldTranslate());
                if (!UML2Util.isEmpty((String)deployedArtifactLabel)) {
                    this.appendString(text, deployedArtifactLabel);
                } else {
                    this.appendType(text, deployedArtifact);
                }
                if (!deployedArtifacts.hasNext()) continue;
                text.append(',');
            }
        }
        return text.toString();
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Deployment.class)) {
            case 17: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 18: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(UMLPackage.Literals.DEPLOYMENT__CONFIGURATION, UMLFactory.eINSTANCE.createDeploymentSpecification()));
    }

    @Override
    public ResourceLocator getResourceLocator() {
        return UMLEditPlugin.INSTANCE;
    }

    protected Command createAddCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection, int index) {
        if (feature == UMLPackage.Literals.DEPLOYMENT__DEPLOYED_ARTIFACT) {
            return new SubsetAddCommand(domain, owner, feature, new EStructuralFeature[]{UMLPackage.Literals.DEPENDENCY__SUPPLIER}, collection, index);
        }
        return super.createAddCommand(domain, owner, feature, collection, index);
    }

    protected Command createRemoveCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection) {
        if (feature == UMLPackage.Literals.DEPENDENCY__SUPPLIER) {
            return new SupersetRemoveCommand(domain, owner, feature, new EStructuralFeature[]{UMLPackage.Literals.DEPLOYMENT__DEPLOYED_ARTIFACT}, collection);
        }
        if (feature == UMLPackage.Literals.DEPENDENCY__CLIENT) {
            return new SupersetRemoveCommand(domain, owner, feature, new EStructuralFeature[]{UMLPackage.Literals.DEPLOYMENT__LOCATION}, collection);
        }
        return super.createRemoveCommand(domain, owner, feature, collection);
    }

    protected Command createReplaceCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, EObject value, Collection<?> collection) {
        if (feature == UMLPackage.Literals.DEPLOYMENT__DEPLOYED_ARTIFACT) {
            return new SubsetSupersetReplaceCommand(domain, owner, feature, new EStructuralFeature[]{UMLPackage.Literals.DEPENDENCY__SUPPLIER}, null, (Object)value, collection);
        }
        if (feature == UMLPackage.Literals.DEPENDENCY__SUPPLIER) {
            return new SubsetSupersetReplaceCommand(domain, owner, feature, null, new EStructuralFeature[]{UMLPackage.Literals.DEPLOYMENT__DEPLOYED_ARTIFACT}, (Object)value, collection);
        }
        if (feature == UMLPackage.Literals.DEPENDENCY__CLIENT) {
            return new SubsetSupersetReplaceCommand(domain, owner, feature, null, new EStructuralFeature[]{UMLPackage.Literals.DEPLOYMENT__LOCATION}, (Object)value, collection);
        }
        return super.createReplaceCommand(domain, owner, feature, value, collection);
    }

    @Override
    protected Command createSetCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value) {
        if (feature == UMLPackage.Literals.DEPLOYMENT__LOCATION) {
            return new SubsetSupersetSetCommand(domain, owner, feature, new EStructuralFeature[]{UMLPackage.Literals.DEPENDENCY__CLIENT}, null, value);
        }
        return super.createSetCommand(domain, owner, feature, value);
    }
}

