/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eodm.rdf.resource.parser.element;

import org.eclipse.eodm.rdf.resource.parser.element.RDFSURIConstant;
import org.eclipse.eodm.rdf.resource.parser.element.RDFValue;
import org.eclipse.eodm.rdf.resource.parser.element.URIReference;

public class RDFLiteralElement
implements RDFValue {
    private String literalText;
    private String literalLanguage;
    private URIReference literalDatatype;

    public RDFLiteralElement(String text) {
        this(text, null, null);
    }

    public RDFLiteralElement(String text, String language) {
        this(text, language, null);
    }

    public RDFLiteralElement(String text, String language, URIReference datatype) {
        if (text == null) {
            throw new IllegalArgumentException("text of literal must NOT be null");
        }
        this.literalText = text;
        if (language != null) {
            this.literalLanguage = language.intern();
        }
        if (datatype != null && language != null) {
            this.literalLanguage = null;
            this.literalDatatype = datatype;
        } else {
            this.literalDatatype = datatype;
        }
    }

    public String getText() {
        return this.literalText;
    }

    public String getLanguage() {
        return this.literalLanguage;
    }

    public URIReference getDatatype() {
        return this.literalDatatype;
    }

    public void setText(String text) {
        this.literalText = text;
    }

    public void setLanguage(String language) {
        this.literalLanguage = language;
    }

    public void setDatatype(URIReference datatype) {
        this.literalDatatype = datatype;
    }

    public boolean equals(Object o) {
        boolean languageEquivalent;
        boolean textEquivalent;
        if (this == o) {
            return true;
        }
        if (!(o instanceof RDFLiteralElement)) {
            return false;
        }
        RDFLiteralElement literal = (RDFLiteralElement)o;
        boolean bl = this.literalText == null ? literal.literalText == null : (textEquivalent = this.literalText.equals(literal.literalText));
        if (!textEquivalent) {
            return false;
        }
        if (this.literalDatatype == null) {
            if (literal.literalDatatype != null) {
                return false;
            }
        } else {
            if (literal.literalDatatype == null) {
                return false;
            }
            if (!this.literalDatatype.equals(literal.literalDatatype)) {
                return false;
            }
            if (this.literalDatatype.equals(RDFSURIConstant.C_XSDString_URI) && this.literalLanguage == null && literal.literalLanguage == null && literal.literalDatatype == null) {
                return true;
            }
        }
        boolean bl2 = this.literalLanguage == null ? literal.literalLanguage == null : (languageEquivalent = this.literalLanguage.equals(literal.literalLanguage));
        return languageEquivalent;
    }

    public int hashCode() {
        int result = this.literalText.hashCode();
        result = 29 * result + (this.literalLanguage != null ? this.literalLanguage.hashCode() : 0);
        result = 29 * result + this.literalDatatype.hashCode();
        return result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("LiteralImpl");
        buf.append("{Text=").append(this.literalText);
        buf.append(",Language=").append(this.literalLanguage);
        buf.append(",Datatype=").append(this.literalDatatype);
        buf.append('}');
        return buf.toString();
    }
}

