/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eodm.rdf.resource.parser.impl;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.eodm.rdf.rdfweb.Document;
import org.eclipse.eodm.rdf.resource.parser.exception.ParserException;
import org.eclipse.eodm.rdf.resource.parser.exception.ParserIOException;
import org.eclipse.eodm.rdf.resource.parser.impl.RDFParserResultHandler;
import org.eclipse.eodm.rdf.resource.parser.impl.RDFTripleAnalyzer;
import org.eclipse.eodm.rdf.resource.parser.xml.RDFXMLParserImpl;
import org.xml.sax.InputSource;

public final class RDFXMLLoader {
    private static String DEFAULT_BASE_URI = "http://default-base-uri";

    private RDFXMLLoader() {
    }

    public static String getDefaultBaseURI() {
        return DEFAULT_BASE_URI;
    }

    public static void setDefaultBaseURI(String uri) {
        if (uri != null) {
            DEFAULT_BASE_URI = uri;
        }
    }

    public static Document loadFromFile(String fileName) throws ParserIOException {
        return RDFXMLLoader.loadFromFile(fileName, null);
    }

    public static Document loadFromFile(String fileName, String charset) throws ParserIOException {
        FileInputStream input = null;
        try {
            input = new FileInputStream(fileName);
        }
        catch (FileNotFoundException e) {
            throw new ParserIOException(e.getMessage(), e);
        }
        return RDFXMLLoader.loadFromStream(input, charset);
    }

    public static Document loadFromStream(InputStream input) throws ParserIOException {
        return RDFXMLLoader.loadFromStream(input, null);
    }

    public static Document loadFromStream(InputStream input, String charset) throws ParserIOException {
        if (input == null) {
            return null;
        }
        InputSource source = new InputSource(input);
        if (charset != null) {
            source.setEncoding(charset);
        }
        RDFTripleAnalyzer tripleAnalyser = new RDFTripleAnalyzer();
        tripleAnalyser.initialize(DEFAULT_BASE_URI);
        RDFXMLParserImpl parser = new RDFXMLParserImpl();
        RDFParserResultHandler resultHandler = new RDFParserResultHandler(tripleAnalyser);
        parser.setNamespaceHandler(resultHandler);
        parser.setStatementHandler(resultHandler);
        try {
            parser.parse(source, DEFAULT_BASE_URI);
        }
        catch (ParserIOException e) {
            throw new ParserIOException("RDF parsing IO error", e);
        }
        catch (ParserException e) {
            throw new ParserIOException("RDF parsing error", e);
        }
        return tripleAnalyser.getDocument();
    }
}

