/**
 * <copyright> 
 * 
 * Copyright (c) 2004-2005 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License - v 1.0 
 * which accompanies this distribution, and is available at 
 * http://opensource.org/licenses/eclipse-1.0.txt 
 * 
 * Contributors: 
 *   IBM - Initial API and implementation 
 * 
 * </copyright> 
 * 
 * $Id: RDFXMLResourceFactoryImpl.java,v 1.2 2007/03/18 08:39:02 lzhang Exp $
 */

package org.eclipse.eodm.rdf.resource;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;

/**
 * An implementation of an
 * {@linkplain org.eclipse.emf.ecore.resource.Resource.Factory EMF resource factory}
 * that creates
 * {@link org.eclipse.eodm.rdf.resource.RDFXMLResource RDFXMLResource} objects.
 * 
 */
public class RDFXMLResourceFactoryImpl extends ResourceFactoryImpl {

    /**
     * Default Constructor.
     */
    public RDFXMLResourceFactoryImpl() {
        super();
    }

    /**
     * Create a
     * {@link org.eclipse.eodm.rdf.resource.RDFXMLResource RDFXMLResource}
     * object based on a resource URI.
     * 
     * @param uri
     *            the URI of the resource
     * @return a
     *         {@link org.eclipse.eodm.rdf.resource.RDFXMLResource RDFXMLResource}
     *         object
     */
    public Resource createResource(URI uri) {
        return new RDFXMLResourceImpl(uri);
    }

}