package org.eclipse.eodm.impl;

import java.lang.reflect.Proxy;
import java.net.URISyntaxException;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.eodm.OWLFactory;
import org.eclipse.eodm.RDFFactory;
import org.eclipse.eodm.owl.owlbase.AllValuesFromRestriction;
import org.eclipse.eodm.owl.owlbase.CardinalityRestriction;
import org.eclipse.eodm.owl.owlbase.ComplementClass;
import org.eclipse.eodm.owl.owlbase.EnumeratedClass;
import org.eclipse.eodm.owl.owlbase.HasValueRestriction;
import org.eclipse.eodm.owl.owlbase.Individual;
import org.eclipse.eodm.owl.owlbase.IntersectionClass;
import org.eclipse.eodm.owl.owlbase.MaxCardinalityRestriction;
import org.eclipse.eodm.owl.owlbase.MinCardinalityRestriction;
import org.eclipse.eodm.owl.owlbase.OWLAllDifferent;
import org.eclipse.eodm.owl.owlbase.OWLAnnotationProperty;
import org.eclipse.eodm.owl.owlbase.OWLClass;
import org.eclipse.eodm.owl.owlbase.OWLDataRange;
import org.eclipse.eodm.owl.owlbase.OWLDatatypeProperty;
import org.eclipse.eodm.owl.owlbase.OWLGraph;
import org.eclipse.eodm.owl.owlbase.OWLObjectProperty;
import org.eclipse.eodm.owl.owlbase.OWLOntology;
import org.eclipse.eodm.owl.owlbase.OWLOntologyProperty;
import org.eclipse.eodm.owl.owlbase.SomeValuesFromRestriction;
import org.eclipse.eodm.owl.owlbase.Statement;
import org.eclipse.eodm.owl.owlbase.UnionClass;
import org.eclipse.eodm.owl.owlbase.util.OWLBaseFactory;
import org.eclipse.eodm.owl.owlbase.util.OWLBasePackage;
import org.eclipse.eodm.rdf.rdfbase.BlankNode;
import org.eclipse.eodm.rdf.rdfbase.RDFGraph;
import org.eclipse.eodm.rdf.rdfbase.RDFSResource;
import org.eclipse.eodm.rdf.rdfbase.URIReference;
import org.eclipse.eodm.rdf.rdfbase.URIReferenceNode;
import org.eclipse.eodm.rdf.rdfbase.impl.RDFGraphImpl;
import org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage;
import org.eclipse.eodm.rdf.rdfweb.Namespace;
import org.eclipse.eodm.util.EJClassMapping;
import org.eclipse.eodm.util.OWLUtility;
import org.eclipse.eodm.util.RDFUtility;



public class OWLFactoryImpl implements OWLFactory {

	public EObject create(RDFGraph graph,EClass eClass,String uriOrNodeID) throws URISyntaxException
	{
		
		return this.create(graph, eClass, RDFFactory.eINSTANCE.createURIReference(uriOrNodeID));
	}
		
	public EObject create(RDFGraph graph,EClass eClass,URIReference uriRef)
	{
		EPackage pkg = eClass.getEPackage();
		Class jclass = EJClassMapping.eclass2jclass( eClass );
		
		if ( jclass != null && pkg.equals( OWLBasePackage.eINSTANCE ))
			return internalCreate(graph, jclass, uriRef);
		else
			throw new IllegalArgumentException("The class '" + eClass.getName() + "' does not belong to RDF(S) package.");

	}

	public RDFSResource internalCreate( RDFGraph graph, Class jclass )
	{
		EClass eclass = EJClassMapping.jclass2eclass( jclass ); 
		if ( eclass == null ) return null ;
		
		InternalCore coreObject = EODMImplFactory.eINSTANCE.createInternalCore();
		
		coreObject.addProxy(RDFBasePackage.eINSTANCE.getBlankNode(), BlankNode.class);
		coreObject.setNodeID(RDFUtility.nodeidGenerator());
		((RDFGraphImpl) graph).getEntityHashMap().put(coreObject.getNodeID(), coreObject);
		
		return (RDFSResource) coreObject.addProxy( eclass, jclass );	
	}

	protected RDFSResource genericCreate(RDFGraph graph, Class jclass, URIReference type)
	{
		RDFSResource product = internalCreate( graph, jclass );
		InternalCore coreObject = (InternalCore) ((EODMInvocationHandler)Proxy.getInvocationHandler(product)).getDelegatedObject();	
		coreObject.addType(graph, type);
		return product;
	}

	public RDFSResource internalCreate( RDFGraph graph, Class jclass, URIReference uriRef )
	{
		EClass eclass = EJClassMapping.jclass2eclass( jclass );
		if ( eclass == null ) return null ;
		
		RDFGraphImpl graphImpl = (RDFGraphImpl) graph;
		String uriRefString = uriRef.getURIString();
		InternalCore coreObject = null;
		RDFSResource rdfsresource = null;
		if (graphImpl.getEntityHashMap().containsKey(uriRefString)) {
			try {
				coreObject = (InternalCore) graphImpl.getEntityHashMap().get(uriRefString);
				rdfsresource = (RDFSResource) coreObject.forceAsType( jclass );
			} catch (Exception e) {
				e.printStackTrace();
			}
		} else {
			coreObject = EODMImplFactory.eINSTANCE.createInternalCore();
			rdfsresource = (RDFSResource) coreObject.addProxy( eclass, jclass );
			coreObject.addProxy( EJClassMapping.jclass2eclass( URIReferenceNode.class ), URIReferenceNode.class );			
			rdfsresource.getUriRef().add(uriRef);
			coreObject.setURI(uriRefString);
			graphImpl.getEntityHashMap().put(uriRefString, coreObject);

		}

		return rdfsresource;
	}

	protected RDFSResource genericCreate( RDFGraph graph, Class jclass, URIReference uriRef, URIReference type)
	{
		RDFSResource product = internalCreate( graph, jclass, uriRef );
		InternalCore coreObject = (InternalCore) ((EODMInvocationHandler)Proxy.getInvocationHandler(product)).getDelegatedObject();	
		coreObject.addType(graph, type);
		return product;	
	}
/**
 * Returns a new unique blank node of type AllValuesFromRestriction.
 * The resource can not be given a URI Reference later.
 *
 * @param graph the context graph of this AllValuesFromRestriction
 * @return a new unique blank node of type AllValuesFromRestriction
 */
public AllValuesFromRestriction createAllValuesFromRestriction(OWLGraph graph) {
	return (AllValuesFromRestriction)genericCreate(graph, AllValuesFromRestriction.class, OWLUtility.restrictionRef);
}

/**
 * Returns an object of class '<em>AllValuesFromRestriction</em>'.
 * 
 * @param graph the context graph of this AllValuesFromRestriction.
 * @param uriRefString the RDF URI Reference of the AllValuesFromRestriction.
 *        <a href="#uriRefString">The string must be a valid RDF URI Reference</a>.
 * @return an object of class '<em>AllValuesFromRestriction</em>'.
 * @throws URISyntaxException if the <code>uriRefString</code> is not a 
 *         valid RDF URI Reference. 
 */
public AllValuesFromRestriction createAllValuesFromRestriction(OWLGraph graph, String uriRefString)
		throws URISyntaxException {
	return (AllValuesFromRestriction)this.genericCreate(graph,AllValuesFromRestriction.class, RDFFactory.eINSTANCE.createURIReference(uriRefString),OWLUtility.restrictionRef);
}

/**
 * Returns an object of class '<em>AllValuesFromRestriction</em>'.
 * 
 * @param graph  the context graph of this AllValuesFromRestriction
 * @param uriRef the RDF URI Reference of the AllValuesFromRestriction
 * @return an object of class '<em>AllValuesFromRestriction</em>'.
 */
public AllValuesFromRestriction createAllValuesFromRestriction(OWLGraph graph, URIReference uriRef) {
	return (AllValuesFromRestriction)this.genericCreate(graph,AllValuesFromRestriction.class,uriRef,OWLUtility.restrictionRef);
}

/**
 * Returns an object of class '<em>AllValuesFromRestriction</em>'.
 * 
 * @param graph           the context graph of this AllValuesFromRestriction
 * @param namespace       the namespace of the RDF URI Reference of the AllValuesFromRestriction
 * @param localNameString the fragment identifier of the RDF URI Reference of the AllValuesFromRestriction
 * @return an object of class '<em>AllValuesFromRestriction</em>'.
 */
public AllValuesFromRestriction createAllValuesFromRestriction(OWLGraph graph, Namespace namespace,
		String localNameString) {
	return (AllValuesFromRestriction)this.genericCreate(graph,AllValuesFromRestriction.class,RDFFactory.eINSTANCE.createURIReference(namespace,localNameString),OWLUtility.restrictionRef);
}

/**
	 * Returns a new unique blank node of type CardinalityRestriction.
	 * The resource can not be given a URI Reference later.
	 *
	 * @param graph the context graph of this CardinalityRestriction
	 * @return a new unique blank node of type CardinalityRestriction
	 */
	public CardinalityRestriction createCardinalityRestriction(OWLGraph graph) {
		return (CardinalityRestriction)genericCreate(graph, CardinalityRestriction.class, OWLUtility.restrictionRef);	
	}

	/**
	 * Returns an object of class '<em>CardinalityRestriction</em>'.
	 * 
	 * @param graph the context graph of this CardinalityRestriction.
	 * @param uriRefString the RDF URI Reference of the CardinalityRestriction.
	 *        <a href="#uriRefString">The string must be a valid RDF URI Reference</a>.
	 * @return an object of class '<em>CardinalityRestriction</em>'.
	 * @throws URISyntaxException if the <code>uriRefString</code> is not a 
	 *         valid RDF URI Reference. 
	 */
	public CardinalityRestriction createCardinalityRestriction(OWLGraph graph, String uriRefString)
			throws URISyntaxException {
		return (CardinalityRestriction)this.genericCreate(graph,CardinalityRestriction.class, RDFFactory.eINSTANCE.createURIReference(uriRefString),OWLUtility.restrictionRef);
	}

	/**
	 * Returns an object of class '<em>CardinalityRestriction</em>'.
	 * 
	 * @param graph  the context graph of this CardinalityRestriction
	 * @param uriRef the RDF URI Reference of the CardinalityRestriction
	 * @return an object of class '<em>CardinalityRestriction</em>'.
	 */
	public CardinalityRestriction createCardinalityRestriction(OWLGraph graph, URIReference uriRef) {
		return (CardinalityRestriction)this.genericCreate(graph,CardinalityRestriction.class,uriRef,OWLUtility.restrictionRef);	
	}

	/**
	 * Returns an object of class '<em>CardinalityRestriction</em>'.
	 * 
	 * @param graph           the context graph of this CardinalityRestriction
	 * @param namespace       the namespace of the RDF URI Reference of the CardinalityRestriction
	 * @param localNameString the fragment identifier of the RDF URI Reference of the CardinalityRestriction
	 * @return an object of class '<em>CardinalityRestriction</em>'.
	 */
	public CardinalityRestriction createCardinalityRestriction(OWLGraph graph, Namespace namespace,
			String localNameString) {
		return (CardinalityRestriction)this.genericCreate(graph,CardinalityRestriction.class,RDFFactory.eINSTANCE.createURIReference(namespace,localNameString),OWLUtility.restrictionRef);	
	}

	/**
	 * Returns a new unique blank node of type ComplementClass.
	 * The resource can not be given a URI Reference later.
	 *
	 * @param graph the context graph of this ComplementClass
	 * @return a new unique blank node of type ComplementClass
	 */
	public ComplementClass createComplementClass(OWLGraph graph) {
		return (ComplementClass)genericCreate(graph, ComplementClass.class, OWLUtility.owlclassRef);
	}

	/**
	 * Returns an object of class '<em>ComplementClass</em>'.
	 * 
	 * @param graph the context graph of this ComplementClass.
	 * @param uriRefString the RDF URI Reference of the ComplementClass.
	 *        <a href="#uriRefString">The string must be a valid RDF URI Reference</a>.
	 * @return an object of class '<em>ComplementClass</em>'.
	 * @throws URISyntaxException if the <code>uriRefString</code> is not a 
	 *         valid RDF URI Reference. 
	 */
	public ComplementClass createComplementClass(OWLGraph graph, String uriRefString)
			throws URISyntaxException {
		return (ComplementClass)genericCreate(graph, ComplementClass.class, RDFFactory.eINSTANCE.createURIReference(uriRefString),OWLUtility.owlclassRef);
	}

	/**
	 * Returns an object of class '<em>ComplementClass</em>'.
	 * 
	 * @param graph  the context graph of this ComplementClass
	 * @param uriRef the RDF URI Reference of the ComplementClass
	 * @return an object of class '<em>ComplementClass</em>'.
	 */
	public ComplementClass createComplementClass(OWLGraph graph, URIReference uriRef) {
		return (ComplementClass)genericCreate(graph, ComplementClass.class, uriRef,OWLUtility.owlclassRef);
	}

	/**
	 * Returns an object of class '<em>ComplementClass</em>'.
	 * 
	 * @param graph           the context graph of this ComplementClass
	 * @param namespace       the namespace of the RDF URI Reference of the ComplementClass
	 * @param localNameString the fragment identifier of the RDF URI Reference of the ComplementClass
	 * @return an object of class '<em>ComplementClass</em>'.
	 */
	public ComplementClass createComplementClass(OWLGraph graph, Namespace namespace,
			String localNameString) {
		return (ComplementClass)genericCreate(graph, ComplementClass.class, RDFFactory.eINSTANCE.createURIReference(namespace,localNameString), OWLUtility.owlclassRef);
	}

	/**
	 * Returns a new unique blank node of type EnumeratedClass.
	 * The resource can not be given a URI Reference later.
	 *
	 * @param graph the context graph of this EnumeratedClass
	 * @return a new unique blank node of type EnumeratedClass
	 */
	public EnumeratedClass createEnumeratedClass(OWLGraph graph) {
		return (EnumeratedClass)genericCreate(graph, EnumeratedClass.class, OWLUtility.owlclassRef);
	}

	/**
	 * Returns an object of class '<em>EnumeratedClass</em>'.
	 * 
	 * @param graph the context graph of this EnumeratedClass.
	 * @param uriRefString the RDF URI Reference of the EnumeratedClass.
	 *        <a href="#uriRefString">The string must be a valid RDF URI Reference</a>.
	 * @return an object of class '<em>EnumeratedClass</em>'.
	 * @throws URISyntaxException if the <code>uriRefString</code> is not a 
	 *         valid RDF URI Reference. 
	 */
	public EnumeratedClass createEnumeratedClass(OWLGraph graph, String uriRefString)
			throws URISyntaxException {
		return (EnumeratedClass)genericCreate(graph, EnumeratedClass.class, RDFFactory.eINSTANCE.createURIReference(uriRefString), OWLUtility.owlclassRef);
	}

	/**
	 * Returns an object of class '<em>EnumeratedClass</em>'.
	 * 
	 * @param graph  the context graph of this EnumeratedClass
	 * @param uriRef the RDF URI Reference of the EnumeratedClass
	 * @return an object of class '<em>EnumeratedClass</em>'.
	 */
	public EnumeratedClass createEnumeratedClass(OWLGraph graph, URIReference uriRef) {
		return (EnumeratedClass)genericCreate(graph, EnumeratedClass.class,uriRef, OWLUtility.owlclassRef);
	}

	/**
	 * Returns an object of class '<em>EnumeratedClass</em>'.
	 * 
	 * @param graph           the context graph of this EnumeratedClass
	 * @param namespace       the namespace of the RDF URI Reference of the EnumeratedClass
	 * @param localNameString the fragment identifier of the RDF URI Reference of the EnumeratedClass
	 * @return an object of class '<em>EnumeratedClass</em>'.
	 */
	public EnumeratedClass createEnumeratedClass(OWLGraph graph, Namespace namespace,
			String localNameString) {
		return (EnumeratedClass)genericCreate(graph, EnumeratedClass.class,RDFFactory.eINSTANCE.createURIReference(namespace,localNameString), OWLUtility.owlclassRef);
	}

	/**
	 * Returns a new unique blank node of type HasValueRestriction.
	 * The resource can not be given a URI Reference later.
	 *
	 * @param graph the context graph of this HasValueRestriction
	 * @return a new unique blank node of type HasValueRestriction
	 */
	public HasValueRestriction createHasValueRestriction(OWLGraph graph) {
		return (HasValueRestriction)genericCreate(graph, HasValueRestriction.class, OWLUtility.restrictionRef);
	}

	/**
	 * Returns an object of class '<em>HasValueRestriction</em>'.
	 * 
	 * @param graph the context graph of this HasValueRestriction.
	 * @param uriRefString the RDF URI Reference of the HasValueRestriction.
	 *        <a href="#uriRefString">The string must be a valid RDF URI Reference</a>.
	 * @return an object of class '<em>HasValueRestriction</em>'.
	 * @throws URISyntaxException if the <code>uriRefString</code> is not a 
	 *         valid RDF URI Reference. 
	 */
	public HasValueRestriction createHasValueRestriction(OWLGraph graph, String uriRefString)
			throws URISyntaxException {
		return (HasValueRestriction)genericCreate(graph, HasValueRestriction.class,RDFFactory.eINSTANCE.createURIReference(uriRefString), OWLUtility.restrictionRef);
	}

	/**
	 * Returns an object of class '<em>HasValueRestriction</em>'.
	 * 
	 * @param graph  the context graph of this HasValueRestriction
	 * @param uriRef the RDF URI Reference of the HasValueRestriction
	 * @return an object of class '<em>HasValueRestriction</em>'.
	 */
	public HasValueRestriction createHasValueRestriction(OWLGraph graph, URIReference uriRef) {
		return (HasValueRestriction)genericCreate(graph, HasValueRestriction.class,uriRef, OWLUtility.restrictionRef);
	}

	/**
	 * Returns an object of class '<em>HasValueRestriction</em>'.
	 * 
	 * @param graph           the context graph of this HasValueRestriction
	 * @param namespace       the namespace of the RDF URI Reference of the HasValueRestriction
	 * @param localNameString the fragment identifier of the RDF URI Reference of the HasValueRestriction
	 * @return an object of class '<em>HasValueRestriction</em>'.
	 */
	public HasValueRestriction createHasValueRestriction(OWLGraph graph, Namespace namespace,
			String localNameString) {
		return (HasValueRestriction)genericCreate(graph, HasValueRestriction.class,RDFFactory.eINSTANCE.createURIReference(namespace,localNameString), OWLUtility.restrictionRef);
	}

	/**
	 * Returns a new unique blank node of type Individual.
	 * The resource can not be given a URI Reference later.
	 *
	 * @param graph the context graph of this Individual
	 * @return a new unique blank node of type Individual
	 */
	public Individual createIndividual(OWLGraph graph) {
		return (Individual)this.internalCreate(graph,Individual.class);
	}

	/**
	 * Returns an object of class '<em>Individual</em>'.
	 * 
	 * @param graph the context graph of this Individual.
	 * @param uriRefString the RDF URI Reference of the Individual.
	 *        <a href="#uriRefString">The string must be a valid RDF URI Reference</a>.
	 * @return an object of class '<em>Individual</em>'.
	 * @throws URISyntaxException if the <code>uriRefString</code> is not a 
	 *         valid RDF URI Reference. 
	 */
	public Individual createIndividual(OWLGraph graph, String uriRefString)
			throws URISyntaxException {
		return (Individual)this.internalCreate(graph,Individual.class,RDFFactory.eINSTANCE.createURIReference(uriRefString));
	}

	/**
	 * Returns an object of class '<em>Individual</em>'.
	 * 
	 * @param graph  the context graph of this Individual
	 * @param uriRef the RDF URI Reference of the Individual
	 * @return an object of class '<em>Individual</em>'.
	 */
	public Individual createIndividual(OWLGraph graph, URIReference uriRef) {
		return (Individual)this.internalCreate(graph,Individual.class,uriRef);
	}

	/**
	 * Returns an object of class '<em>Individual</em>'.
	 * 
	 * @param graph           the context graph of this Individual
	 * @param namespace       the namespace of the RDF URI Reference of the Individual
	 * @param localNameString the fragment identifier of the RDF URI Reference of the Individual
	 * @return an object of class '<em>Individual</em>'.
	 */
	public Individual createIndividual(OWLGraph graph, Namespace namespace,
			String localNameString) {
		return (Individual)this.internalCreate(graph,Individual.class,RDFFactory.eINSTANCE.createURIReference(namespace,localNameString));
	}
	
	/**
	 * Returns a new unique blank node of type IntersectionClass.
	 * The resource can not be given a URI Reference later.
	 *
	 * @param graph the context graph of this IntersectionClass
	 * @return a new unique blank node of type IntersectionClass
	 */
	public IntersectionClass createIntersectionClass(OWLGraph graph) {
		return (IntersectionClass)this.genericCreate(graph,IntersectionClass.class,OWLUtility.owlclassRef);
	}

	/**
	 * Returns an object of class '<em>IntersectionClass</em>'.
	 * 
	 * @param graph the context graph of this IntersectionClass.
	 * @param uriRefString the RDF URI Reference of the IntersectionClass.
	 *        <a href="#uriRefString">The string must be a valid RDF URI Reference</a>.
	 * @return an object of class '<em>IntersectionClass</em>'.
	 * @throws URISyntaxException if the <code>uriRefString</code> is not a 
	 *         valid RDF URI Reference. 
	 */
	public IntersectionClass createIntersectionClass(OWLGraph graph, String uriRefString)
			throws URISyntaxException {
		return (IntersectionClass)this.genericCreate(graph,IntersectionClass.class,RDFFactory.eINSTANCE.createURIReference(uriRefString),OWLUtility.owlclassRef);
	}

	/**
	 * Returns an object of class '<em>IntersectionClass</em>'.
	 * 
	 * @param graph  the context graph of this IntersectionClass
	 * @param uriRef the RDF URI Reference of the IntersectionClass
	 * @return an object of class '<em>IntersectionClass</em>'.
	 */
	public IntersectionClass createIntersectionClass(OWLGraph graph, URIReference uriRef) {
		return (IntersectionClass)this.genericCreate(graph,IntersectionClass.class,uriRef,OWLUtility.owlclassRef);
	}

	/**
	 * Returns an object of class '<em>IntersectionClass</em>'.
	 * 
	 * @param graph           the context graph of this IntersectionClass
	 * @param namespace       the namespace of the RDF URI Reference of the IntersectionClass
	 * @param localNameString the fragment identifier of the RDF URI Reference of the IntersectionClass
	 * @return an object of class '<em>IntersectionClass</em>'.
	 */
	public IntersectionClass createIntersectionClass(OWLGraph graph, Namespace namespace,
			String localNameString) {
		return (IntersectionClass)this.genericCreate(graph,IntersectionClass.class,RDFFactory.eINSTANCE.createURIReference(namespace,localNameString),OWLUtility.owlclassRef);
	}

	/**
	 * Returns a new unique blank node of type MaxCardinalityRestriction.
	 * The resource can not be given a URI Reference later.
	 *
	 * @param graph the context graph of this MaxCardinalityRestriction
	 * @return a new unique blank node of type MaxCardinalityRestriction
	 */
	public MaxCardinalityRestriction createMaxCardinalityRestriction(OWLGraph graph) {
		return (MaxCardinalityRestriction)this.genericCreate(graph,MaxCardinalityRestriction.class,OWLUtility.restrictionRef);
	}

	/**
	 * Returns an object of class '<em>MaxCardinalityRestriction</em>'.
	 * 
	 * @param graph the context graph of this MaxCardinalityRestriction.
	 * @param uriRefString the RDF URI Reference of the MaxCardinalityRestriction.
	 *        <a href="#uriRefString">The string must be a valid RDF URI Reference</a>.
	 * @return an object of class '<em>MaxCardinalityRestriction</em>'.
	 * @throws URISyntaxException if the <code>uriRefString</code> is not a 
	 *         valid RDF URI Reference. 
	 */
	public MaxCardinalityRestriction createMaxCardinalityRestriction(OWLGraph graph, String uriRefString)
			throws URISyntaxException {
		return (MaxCardinalityRestriction)this.genericCreate(graph,MaxCardinalityRestriction.class,RDFFactory.eINSTANCE.createURIReference(uriRefString),OWLUtility.restrictionRef);
	}

	/**
	 * Returns an object of class '<em>MaxCardinalityRestriction</em>'.
	 * 
	 * @param graph  the context graph of this MaxCardinalityRestriction
	 * @param uriRef the RDF URI Reference of the MaxCardinalityRestriction
	 * @return an object of class '<em>MaxCardinalityRestriction</em>'.
	 */
	public MaxCardinalityRestriction createMaxCardinalityRestriction(OWLGraph graph, URIReference uriRef) {
		return (MaxCardinalityRestriction)this.genericCreate(graph,MaxCardinalityRestriction.class,uriRef,OWLUtility.restrictionRef);
	}

	/**
	 * Returns an object of class '<em>MaxCardinalityRestriction</em>'.
	 * 
	 * @param graph           the context graph of this MaxCardinalityRestriction
	 * @param namespace       the namespace of the RDF URI Reference of the MaxCardinalityRestriction
	 * @param localNameString the fragment identifier of the RDF URI Reference of the MaxCardinalityRestriction
	 * @return an object of class '<em>MaxCardinalityRestriction</em>'.
	 */
	public MaxCardinalityRestriction createMaxCardinalityRestriction(OWLGraph graph, Namespace namespace,
			String localNameString) {
		return (MaxCardinalityRestriction)this.genericCreate(graph,MaxCardinalityRestriction.class,RDFFactory.eINSTANCE.createURIReference(namespace,localNameString),OWLUtility.restrictionRef);
	}

	/**
	 * Returns a new unique blank node of type MinCardinalityRestriction.
	 * The resource can not be given a URI Reference later.
	 *
	 * @param graph the context graph of this MinCardinalityRestriction
	 * @return a new unique blank node of type MinCardinalityRestriction
	 */
	public MinCardinalityRestriction createMinCardinalityRestriction(OWLGraph graph) {
		return (MinCardinalityRestriction)this.genericCreate(graph,MinCardinalityRestriction.class,OWLUtility.restrictionRef);
	}

	/**
	 * Returns an object of class '<em>MinCardinalityRestriction</em>'.
	 * 
	 * @param graph the context graph of this MinCardinalityRestriction.
	 * @param uriRefString the RDF URI Reference of the MinCardinalityRestriction.
	 *        <a href="#uriRefString">The string must be a valid RDF URI Reference</a>.
	 * @return an object of class '<em>MinCardinalityRestriction</em>'.
	 * @throws URISyntaxException if the <code>uriRefString</code> is not a 
	 *         valid RDF URI Reference. 
	 */
	public MinCardinalityRestriction createMinCardinalityRestriction(OWLGraph graph, String uriRefString)
			throws URISyntaxException {
		return (MinCardinalityRestriction)this.genericCreate(graph,MinCardinalityRestriction.class,RDFFactory.eINSTANCE.createURIReference(uriRefString),OWLUtility.restrictionRef);
	}

	/**
	 * Returns an object of class '<em>MinCardinalityRestriction</em>'.
	 * 
	 * @param graph  the context graph of this MinCardinalityRestriction
	 * @param uriRef the RDF URI Reference of the MinCardinalityRestriction
	 * @return an object of class '<em>MinCardinalityRestriction</em>'.
	 */
	public MinCardinalityRestriction createMinCardinalityRestriction(OWLGraph graph, URIReference uriRef) {
		return (MinCardinalityRestriction)this.genericCreate(graph,MinCardinalityRestriction.class,uriRef,OWLUtility.restrictionRef);
	}

	/**
	 * Returns an object of class '<em>MinCardinalityRestriction</em>'.
	 * 
	 * @param graph           the context graph of this MinCardinalityRestriction
	 * @param namespace       the namespace of the RDF URI Reference of the MinCardinalityRestriction
	 * @param localNameString the fragment identifier of the RDF URI Reference of the MinCardinalityRestriction
	 * @return an object of class '<em>MinCardinalityRestriction</em>'.
	 */
	public MinCardinalityRestriction createMinCardinalityRestriction(OWLGraph graph, Namespace namespace,
			String localNameString) {
		return (MinCardinalityRestriction)this.genericCreate(graph,MinCardinalityRestriction.class,RDFFactory.eINSTANCE.createURIReference(namespace,localNameString),OWLUtility.restrictionRef);
	}

	/**
	 * Returns a new unique blank node of type OWLAllDifferent.
	 * The resource can not be given a URI Reference later.
	 *
	 * @param graph the context graph of this OWLAllDifferent
	 * @return a new unique blank node of type OWLAllDifferent
	 */
	public OWLAllDifferent createOWLAllDifferent(OWLGraph graph) {
		return (OWLAllDifferent)this.genericCreate(graph,OWLAllDifferent.class,OWLUtility.alldifferentRef);
	}

	/**
	 * Returns an object of class '<em>OWLAllDifferent</em>'.
	 * 
	 * @param graph the context graph of this OWLAllDifferent.
	 * @param uriRefString the RDF URI Reference of the OWLAllDifferent.
	 *        <a href="#uriRefString">The string must be a valid RDF URI Reference</a>.
	 * @return an object of class '<em>OWLAllDifferent</em>'.
	 * @throws URISyntaxException if the <code>uriRefString</code> is not a 
	 *         valid RDF URI Reference. 
	 */
	public OWLAllDifferent createOWLAllDifferent(OWLGraph graph, String uriRefString)
			throws URISyntaxException {
		return (OWLAllDifferent)this.genericCreate(graph,OWLAllDifferent.class,RDFFactory.eINSTANCE.createURIReference(uriRefString),OWLUtility.alldifferentRef);
	}

	/**
	 * Returns an object of class '<em>OWLAllDifferent</em>'.
	 * 
	 * @param graph  the context graph of this OWLAllDifferent
	 * @param uriRef the RDF URI Reference of the OWLAllDifferent
	 * @return an object of class '<em>OWLAllDifferent</em>'.
	 */
	public OWLAllDifferent createOWLAllDifferent(OWLGraph graph, URIReference uriRef) {
		return (OWLAllDifferent)this.genericCreate(graph,OWLAllDifferent.class,uriRef,OWLUtility.alldifferentRef);
	}

	/**
	 * Returns an object of class '<em>OWLAllDifferent</em>'.
	 * 
	 * @param graph           the context graph of this OWLAllDifferent
	 * @param namespace       the namespace of the RDF URI Reference of the OWLAllDifferent
	 * @param localNameString the fragment identifier of the RDF URI Reference of the OWLAllDifferent
	 * @return an object of class '<em>OWLAllDifferent</em>'.
	 */
	public OWLAllDifferent createOWLAllDifferent(OWLGraph graph, Namespace namespace,
			String localNameString) {
		return (OWLAllDifferent)this.genericCreate(graph,OWLAllDifferent.class,RDFFactory.eINSTANCE.createURIReference(namespace,localNameString),OWLUtility.alldifferentRef);
	}

	/**
	 * Returns a new unique blank node of type OWLDataRange.
	 * The resource can not be given a URI Reference later.
	 *
	 * @param graph the context graph of this OWLDataRange
	 * @return a new unique blank node of type OWLDataRange
	 */
	public OWLDataRange createOWLDataRange(OWLGraph graph) {
		return (OWLDataRange)this.genericCreate(graph,OWLDataRange.class,OWLUtility.datarangeRef);
	}

	/**
	 * Returns an object of class '<em>OWLDataRange</em>'.
	 * 
	 * @param graph the context graph of this OWLDataRange.
	 * @param uriRefString the RDF URI Reference of the OWLDataRange.
	 *        <a href="#uriRefString">The string must be a valid RDF URI Reference</a>.
	 * @return an object of class '<em>OWLDataRange</em>'.
	 * @throws URISyntaxException if the <code>uriRefString</code> is not a 
	 *         valid RDF URI Reference. 
	 */
	public OWLDataRange createOWLDataRange(OWLGraph graph, String uriRefString)
			throws URISyntaxException {
		return (OWLDataRange)this.genericCreate(graph,OWLDataRange.class,RDFFactory.eINSTANCE.createURIReference(uriRefString),OWLUtility.datarangeRef);
	}

	/**
	 * Returns an object of class '<em>OWLDataRange</em>'.
	 * 
	 * @param graph  the context graph of this OWLDataRange
	 * @param uriRef the RDF URI Reference of the OWLDataRange
	 * @return an object of class '<em>OWLDataRange</em>'.
	 */
	public OWLDataRange createOWLDataRange(OWLGraph graph, URIReference uriRef) {
		return (OWLDataRange)this.genericCreate(graph,OWLDataRange.class,uriRef,OWLUtility.datarangeRef);
	}

	/**
	 * Returns an object of class '<em>OWLDataRange</em>'.
	 * 
	 * @param graph           the context graph of this OWLDataRange
	 * @param namespace       the namespace of the RDF URI Reference of the OWLDataRange
	 * @param localNameString the fragment identifier of the RDF URI Reference of the OWLDataRange
	 * @return an object of class '<em>OWLDataRange</em>'.
	 */
	public OWLDataRange createOWLDataRange(OWLGraph graph, Namespace namespace,
			String localNameString) {
		return (OWLDataRange)this.genericCreate(graph,OWLDataRange.class,RDFFactory.eINSTANCE.createURIReference(namespace,localNameString),OWLUtility.datarangeRef);
	}

	/**
	 * Returns a new unique blank node of type SomeValuesFromRestriction.
	 * The resource can not be given a URI Reference later.
	 *
	 * @param graph the context graph of this SomeValuesFromRestriction
	 * @return a new unique blank node of type SomeValuesFromRestriction
	 */
	public SomeValuesFromRestriction createSomeValuesFromRestriction(OWLGraph graph) {
		return (SomeValuesFromRestriction)this.genericCreate(graph,SomeValuesFromRestriction.class,OWLUtility.restrictionRef);
	}

	/**
	 * Returns an object of class '<em>SomeValuesFromRestriction</em>'.
	 * 
	 * @param graph the context graph of this SomeValuesFromRestriction.
	 * @param uriRefString the RDF URI Reference of the SomeValuesFromRestriction.
	 *        <a href="#uriRefString">The string must be a valid RDF URI Reference</a>.
	 * @return an object of class '<em>SomeValuesFromRestriction</em>'.
	 * @throws URISyntaxException if the <code>uriRefString</code> is not a 
	 *         valid RDF URI Reference. 
	 */
	public SomeValuesFromRestriction createSomeValuesFromRestriction(OWLGraph graph, String uriRefString)
			throws URISyntaxException {
		return (SomeValuesFromRestriction)this.genericCreate(graph,SomeValuesFromRestriction.class,RDFFactory.eINSTANCE.createURIReference(uriRefString),OWLUtility.restrictionRef);
	}

	/**
	 * Returns an object of class '<em>SomeValuesFromRestriction</em>'.
	 * 
	 * @param graph  the context graph of this SomeValuesFromRestriction
	 * @param uriRef the RDF URI Reference of the SomeValuesFromRestriction
	 * @return an object of class '<em>SomeValuesFromRestriction</em>'.
	 */
	public SomeValuesFromRestriction createSomeValuesFromRestriction(OWLGraph graph, URIReference uriRef) {
		return (SomeValuesFromRestriction)this.genericCreate(graph,SomeValuesFromRestriction.class,uriRef,OWLUtility.restrictionRef);
	}

	/**
	 * Returns an object of class '<em>SomeValuesFromRestriction</em>'.
	 * 
	 * @param graph           the context graph of this SomeValuesFromRestriction
	 * @param namespace       the namespace of the RDF URI Reference of the SomeValuesFromRestriction
	 * @param localNameString the fragment identifier of the RDF URI Reference of the SomeValuesFromRestriction
	 * @return an object of class '<em>SomeValuesFromRestriction</em>'.
	 */
	public SomeValuesFromRestriction createSomeValuesFromRestriction(OWLGraph graph, Namespace namespace,
			String localNameString) {
		return (SomeValuesFromRestriction)this.genericCreate(graph,SomeValuesFromRestriction.class,RDFFactory.eINSTANCE.createURIReference(namespace,localNameString),OWLUtility.restrictionRef);
	}

	/**
	 * Returns a new unique blank node of type UnionClass.
	 * The resource can not be given a URI Reference later.
	 *
	 * @param graph the context graph of this UnionClass
	 * @return a new unique blank node of type UnionClass
	 */
	public UnionClass createUnionClass(OWLGraph graph) {
		return (UnionClass)this.genericCreate(graph,UnionClass.class,OWLUtility.owlclassRef);
	}

	/**
	 * Returns an object of class '<em>UnionClass</em>'.
	 * 
	 * @param graph the context graph of this UnionClass.
	 * @param uriRefString the RDF URI Reference of the UnionClass.
	 *        <a href="#uriRefString">The string must be a valid RDF URI Reference</a>.
	 * @return an object of class '<em>UnionClass</em>'.
	 * @throws URISyntaxException if the <code>uriRefString</code> is not a 
	 *         valid RDF URI Reference. 
	 */
	public UnionClass createUnionClass(OWLGraph graph, String uriRefString)
			throws URISyntaxException {
		return (UnionClass)this.genericCreate(graph,UnionClass.class,RDFFactory.eINSTANCE.createURIReference(uriRefString),OWLUtility.owlclassRef);
	}

	/**
	 * Returns an object of class '<em>UnionClass</em>'.
	 * 
	 * @param graph  the context graph of this UnionClass
	 * @param uriRef the RDF URI Reference of the UnionClass
	 * @return an object of class '<em>UnionClass</em>'.
	 */
	public UnionClass createUnionClass(OWLGraph graph, URIReference uriRef) {
		return (UnionClass)this.genericCreate(graph,UnionClass.class,uriRef,OWLUtility.owlclassRef);
	}

	/**
	 * Returns an object of class '<em>UnionClass</em>'.
	 * 
	 * @param graph           the context graph of this UnionClass
	 * @param namespace       the namespace of the RDF URI Reference of the UnionClass
	 * @param localNameString the fragment identifier of the RDF URI Reference of the UnionClass
	 * @return an object of class '<em>UnionClass</em>'.
	 */
	public UnionClass createUnionClass(OWLGraph graph, Namespace namespace,
			String localNameString) {
		return (UnionClass)this.genericCreate(graph,UnionClass.class,RDFFactory.eINSTANCE.createURIReference(namespace,localNameString),OWLUtility.owlclassRef);
	}

	/**
	 * Returns a new unique blank node of type OWLDatatypeProperty.
	 * The resource can not be given a URI Reference later.
	 *
	 * @param graph the context graph of this OWLDatatypeProperty
	 * @return a new unique blank node of type OWLDatatypeProperty
	 */
	public OWLDatatypeProperty createOWLDatatypeProperty(OWLGraph graph) {
		OWLDatatypeProperty dp = (OWLDatatypeProperty)this.genericCreate(graph,OWLDatatypeProperty.class,OWLUtility.datatypepropertyRef);
		dp.setIsDatatypeProperty( true );
		return dp ;
	}

	/**
	 * Returns an object of class '<em>OWLDatatypeProperty</em>'.
	 * 
	 * @param graph the context graph of this OWLDatatypeProperty.
	 * @param uriRefString the RDF URI Reference of the OWLDatatypeProperty.
	 *        <a href="#uriRefString">The string must be a valid RDF URI Reference</a>.
	 * @return an object of class '<em>OWLDatatypeProperty</em>'.
	 * @throws URISyntaxException if the <code>uriRefString</code> is not a 
	 *         valid RDF URI Reference. 
	 */
	public OWLDatatypeProperty createOWLDatatypeProperty(OWLGraph graph, String uriRefString)
			throws URISyntaxException {
		OWLDatatypeProperty dp = (OWLDatatypeProperty)this.genericCreate(graph,OWLDatatypeProperty.class,RDFFactory.eINSTANCE.createURIReference(uriRefString),OWLUtility.datatypepropertyRef);
		dp.setIsDatatypeProperty( true );
		return dp ;
	}

	/**
	 * Returns an object of class '<em>OWLDatatypeProperty</em>'.
	 * 
	 * @param graph  the context graph of this OWLDatatypeProperty
	 * @param uriRef the RDF URI Reference of the OWLDatatypeProperty
	 * @return an object of class '<em>OWLDatatypeProperty</em>'.
	 */
	public OWLDatatypeProperty createOWLDatatypeProperty(OWLGraph graph, URIReference uriRef) {
		OWLDatatypeProperty dp = (OWLDatatypeProperty)this.genericCreate(graph,OWLDatatypeProperty.class,uriRef,OWLUtility.datatypepropertyRef);
		dp.setIsDatatypeProperty( true );
		return dp ;
	}

	/**
	 * Returns an object of class '<em>OWLDatatypeProperty</em>'.
	 * 
	 * @param graph           the context graph of this OWLDatatypeProperty
	 * @param namespace       the namespace of the RDF URI Reference of the OWLDatatypeProperty
	 * @param localNameString the fragment identifier of the RDF URI Reference of the OWLDatatypeProperty
	 * @return an object of class '<em>OWLDatatypeProperty</em>'.
	 */
	public OWLDatatypeProperty createOWLDatatypeProperty(OWLGraph graph, Namespace namespace,
			String localNameString) {
		OWLDatatypeProperty dp = (OWLDatatypeProperty)this.genericCreate(graph,OWLDatatypeProperty.class,RDFFactory.eINSTANCE.createURIReference(namespace,localNameString),OWLUtility.datatypepropertyRef);
		dp.setIsDatatypeProperty( true );
		return dp ;
	}

	/**
	 * Returns a new unique blank node of type OWLObjectProperty.
	 * The resource can not be given a URI Reference later.
	 *
	 * @param graph the context graph of this OWLObjectProperty
	 * @return a new unique blank node of type OWLObjectProperty
	 */
	public OWLObjectProperty createOWLObjectProperty(OWLGraph graph) {
		OWLObjectProperty op = (OWLObjectProperty)this.genericCreate(graph,OWLObjectProperty.class,OWLUtility.objectpropertyRef);
		op.setIsObjectProperty( true );
		return op ;
	}

	/**
	 * Returns an object of class '<em>OWLObjectProperty</em>'.
	 * 
	 * @param graph the context graph of this OWLObjectProperty.
	 * @param uriRefString the RDF URI Reference of the OWLObjectProperty.
	 *        <a href="#uriRefString">The string must be a valid RDF URI Reference</a>.
	 * @return an object of class '<em>OWLObjectProperty</em>'.
	 * @throws URISyntaxException if the <code>uriRefString</code> is not a 
	 *         valid RDF URI Reference. 
	 */
	public OWLObjectProperty createOWLObjectProperty(OWLGraph graph, String uriRefString)
			throws URISyntaxException {
		OWLObjectProperty op = (OWLObjectProperty)this.genericCreate(graph,OWLObjectProperty.class,RDFFactory.eINSTANCE.createURIReference(uriRefString),OWLUtility.objectpropertyRef);
		op.setIsObjectProperty( true );
		return op ;
	}

	/**
	 * Returns an object of class '<em>OWLObjectProperty</em>'.
	 * 
	 * @param graph  the context graph of this OWLObjectProperty
	 * @param uriRef the RDF URI Reference of the OWLObjectProperty
	 * @return an object of class '<em>OWLObjectProperty</em>'.
	 */
	public OWLObjectProperty createOWLObjectProperty(OWLGraph graph, URIReference uriRef) {
		OWLObjectProperty op = (OWLObjectProperty)this.genericCreate(graph,OWLObjectProperty.class,uriRef,OWLUtility.objectpropertyRef);
		op.setIsObjectProperty( true );
		return op ;
	}

	/**
	 * Returns an object of class '<em>OWLObjectProperty</em>'.
	 * 
	 * @param graph           the context graph of this OWLObjectProperty
	 * @param namespace       the namespace of the RDF URI Reference of the OWLObjectProperty
	 * @param localNameString the fragment identifier of the RDF URI Reference of the OWLObjectProperty
	 * @return an object of class '<em>OWLObjectProperty</em>'.
	 */
	public OWLObjectProperty createOWLObjectProperty(OWLGraph graph, Namespace namespace,
			String localNameString) {
		OWLObjectProperty op = (OWLObjectProperty)this.genericCreate(graph,OWLObjectProperty.class,RDFFactory.eINSTANCE.createURIReference(namespace,localNameString),OWLUtility.objectpropertyRef);
		op.setIsObjectProperty( true );
		return op ;
	}

	/**
	 * Returns a new unique blank node of type OWLOntologyProperty.
	 * The resource can not be given a URI Reference later.
	 *
	 * @param graph the context graph of this OWLOntologyProperty
	 * @return a new unique blank node of type OWLOntologyProperty
	 */
	public OWLOntologyProperty createOWLOntologyProperty(OWLGraph graph) {
		return (OWLOntologyProperty)this.genericCreate(graph,OWLOntologyProperty.class,OWLUtility.ontologypropertyRef);
	}

	/**
	 * Returns an object of class '<em>OWLOntologyProperty</em>'.
	 * 
	 * @param graph the context graph of this OWLOntologyProperty.
	 * @param uriRefString the RDF URI Reference of the OWLOntologyProperty.
	 *        <a href="#uriRefString">The string must be a valid RDF URI Reference</a>.
	 * @return an object of class '<em>OWLOntologyProperty</em>'.
	 * @throws URISyntaxException if the <code>uriRefString</code> is not a 
	 *         valid RDF URI Reference. 
	 */
	public OWLOntologyProperty createOWLOntologyProperty(OWLGraph graph, String uriRefString)
			throws URISyntaxException {
		return (OWLOntologyProperty)this.genericCreate(graph,OWLOntologyProperty.class,RDFFactory.eINSTANCE.createURIReference(uriRefString),OWLUtility.ontologypropertyRef);
	}

	/**
	 * Returns an object of class '<em>OWLOntologyProperty</em>'.
	 * 
	 * @param graph  the context graph of this OWLOntologyProperty
	 * @param uriRef the RDF URI Reference of the OWLOntologyProperty
	 * @return an object of class '<em>OWLOntologyProperty</em>'.
	 */
	public OWLOntologyProperty createOWLOntologyProperty(OWLGraph graph, URIReference uriRef) {
		return (OWLOntologyProperty)this.genericCreate(graph,OWLOntologyProperty.class,uriRef,OWLUtility.ontologypropertyRef);
	}

	/**
	 * Returns an object of class '<em>OWLOntologyProperty</em>'.
	 * 
	 * @param graph           the context graph of this OWLOntologyProperty
	 * @param namespace       the namespace of the RDF URI Reference of the OWLOntologyProperty
	 * @param localNameString the fragment identifier of the RDF URI Reference of the OWLOntologyProperty
	 * @return an object of class '<em>OWLOntologyProperty</em>'.
	 */
	public OWLOntologyProperty createOWLOntologyProperty(OWLGraph graph, Namespace namespace,
			String localNameString) {
		return (OWLOntologyProperty)this.genericCreate(graph,OWLOntologyProperty.class,RDFFactory.eINSTANCE.createURIReference(namespace,localNameString),OWLUtility.ontologypropertyRef);
	}

	/**
	 * Returns a new unique blank node of type OWLClass.
	 * The resource can not be given a URI Reference later.
	 *
	 * @param graph the context graph of this OWLClass
	 * @return a new unique blank node of type OWLClass
	 */
	public OWLClass createOWLClass(OWLGraph graph) {
		return (OWLClass)this.genericCreate(graph,OWLClass.class,OWLUtility.owlclassRef);
	}

	/**
	 * Returns an object of class '<em>OWLClass</em>'.
	 * 
	 * @param graph the context graph of this OWLClass.
	 * @param uriRefString the RDF URI Reference of the OWLClass.
	 *        <a href="#uriRefString">The string must be a valid RDF URI Reference</a>.
	 * @return an object of class '<em>OWLClass</em>'.
	 * @throws URISyntaxException if the <code>uriRefString</code> is not a 
	 *         valid RDF URI Reference. 
	 */
	public OWLClass createOWLClass(OWLGraph graph, String uriRefString)
			throws URISyntaxException {
		return (OWLClass)this.genericCreate(graph,OWLClass.class,RDFFactory.eINSTANCE.createURIReference(uriRefString),OWLUtility.owlclassRef);
	}

	/**
	 * Returns an object of class '<em>OWLClass</em>'.
	 * 
	 * @param graph  the context graph of this OWLClass
	 * @param uriRef the RDF URI Reference of the OWLClass
	 * @return an object of class '<em>OWLClass</em>'.
	 */
	public OWLClass createOWLClass(OWLGraph graph, URIReference uriRef) {
		return (OWLClass)this.genericCreate(graph,OWLClass.class,uriRef,OWLUtility.owlclassRef);
	}

	/**
	 * Returns an object of class '<em>OWLClass</em>'.
	 * 
	 * @param graph           the context graph of this OWLClass
	 * @param namespace       the namespace of the RDF URI Reference of the OWLClass
	 * @param localNameString the fragment identifier of the RDF URI Reference of the OWLClass
	 * @return an object of class '<em>OWLClass</em>'.
	 */
	public OWLClass createOWLClass(OWLGraph graph, Namespace namespace,
			String localNameString) {
		return (OWLClass)this.genericCreate(graph,OWLClass.class,RDFFactory.eINSTANCE.createURIReference(namespace,localNameString),OWLUtility.owlclassRef);
	}

	/**
	 * Returns a new unique blank node of type OWLAnnotationProperty.
	 * The resource can not be given a URI Reference later.
	 *
	 * @param graph the context graph of this OWLAnnotationProperty
	 * @return a new unique blank node of type OWLAnnotationProperty
	 */
	public OWLAnnotationProperty createOWLAnnotationProperty(OWLGraph graph) {
		return (OWLAnnotationProperty)this.genericCreate(graph,OWLAnnotationProperty.class,OWLUtility.annotationpropertyRef);
	}

	/**
	 * Returns an object of class '<em>OWLAnnotationProperty</em>'.
	 * 
	 * @param graph the context graph of this OWLAnnotationProperty.
	 * @param uriRefString the RDF URI Reference of the OWLAnnotationProperty.
	 *        <a href="#uriRefString">The string must be a valid RDF URI Reference</a>.
	 * @return an object of class '<em>OWLAnnotationProperty</em>'.
	 * @throws URISyntaxException if the <code>uriRefString</code> is not a 
	 *         valid RDF URI Reference. 
	 */
	public OWLAnnotationProperty createOWLAnnotationProperty(OWLGraph graph, String uriRefString)
			throws URISyntaxException {
		return (OWLAnnotationProperty)this.genericCreate(graph,OWLAnnotationProperty.class,RDFFactory.eINSTANCE.createURIReference(uriRefString),OWLUtility.annotationpropertyRef);
	}

	/**
	 * Returns an object of class '<em>OWLAnnotationProperty</em>'.
	 * 
	 * @param graph  the context graph of this OWLAnnotationProperty
	 * @param uriRef the RDF URI Reference of the OWLAnnotationProperty
	 * @return an object of class '<em>OWLAnnotationProperty</em>'.
	 */
	public OWLAnnotationProperty createOWLAnnotationProperty(OWLGraph graph, URIReference uriRef) {
		return (OWLAnnotationProperty)this.genericCreate(graph,OWLAnnotationProperty.class,uriRef,OWLUtility.annotationpropertyRef);
	}

	/**
	 * Returns an object of class '<em>OWLAnnotationProperty</em>'.
	 * 
	 * @param graph           the context graph of this OWLAnnotationProperty
	 * @param namespace       the namespace of the RDF URI Reference of the OWLAnnotationProperty
	 * @param localNameString the fragment identifier of the RDF URI Reference of the OWLAnnotationProperty
	 * @return an object of class '<em>OWLAnnotationProperty</em>'.
	 */
	public OWLAnnotationProperty createOWLAnnotationProperty(OWLGraph graph, Namespace namespace,
			String localNameString) {
		return (OWLAnnotationProperty)this.genericCreate(graph,OWLAnnotationProperty.class,RDFFactory.eINSTANCE.createURIReference(namespace,localNameString),OWLUtility.annotationpropertyRef);
	}

	public OWLOntology createOWLOntology(OWLGraph graph, String uriRefString)
			throws URISyntaxException {
		
		return (OWLOntology)this.genericCreate(graph,OWLOntology.class,RDFFactory.eINSTANCE.createURIReference(uriRefString),OWLUtility.owlontologyRef);
	}

	public OWLOntology createOWLOntology(OWLGraph graph, URIReference uriRef) {
		return (OWLOntology)this.genericCreate(graph,OWLOntology.class,uriRef,OWLUtility.owlontologyRef);
		
	}
	public OWLOntology createOWLOntology(OWLGraph graph,Namespace namespace,
			String localNameString) {
		return (OWLOntology)this.genericCreate(graph,OWLOntology.class,RDFFactory.eINSTANCE.createURIReference(namespace,localNameString),OWLUtility.owlontologyRef);		
	}

	public OWLGraph createOWLGraph(String uriRefString)
			throws URISyntaxException {
		// TODO Auto-generated method stub
		OWLGraph graph = OWLBaseFactory.eINSTANCE.createOWLGraph();                                                                                                                                                                                                                                                                                                                                                                                                         
		graph.setGraphName(RDFFactory.eINSTANCE.createURIReference(uriRefString));
		return graph;
	}
	public OWLGraph createOWLGraph(URIReference uriRef)
	{
		// TODO Auto-generated method stub
		OWLGraph graph = OWLBaseFactory.eINSTANCE.createOWLGraph();                                                                                                                                                                                                                                                                                                                                                                                                         
		graph.setGraphName(uriRef);
		return graph;
	}
	public OWLGraph createOWLGraph(Namespace namespace, String localNameString)
	{
		// TODO Auto-generated method stub
		OWLGraph graph = OWLBaseFactory.eINSTANCE.createOWLGraph();                                                                                                                                                                                                                                                                                                                                                                                                         
		graph.setGraphName(RDFFactory.eINSTANCE.createURIReference(namespace,localNameString));
		return graph;
	}
	/**
	 * Returns a new unique blank node of type Statement.
	 * The resource can not be given a URI Reference later.
	 *
	 * @param graph the context graph of this Statement
	 * @return a new unique blank node of type Statement
	 */
	public Statement createStatement(OWLGraph graph) {
		return (Statement)this.internalCreate(graph, Statement.class);
	}

	/**
	 * Returns an object of class '<em>Statement</em>'.
	 * 
	 * @param graph the context graph of this Statement.
	 * @param uriRefString the RDF URI Reference of the Statement.
	 *        <a href="#uriRefString">The string must be a valid RDF URI Reference</a>.
	 * @return an object of class '<em>Statement</em>'.
	 * @throws URISyntaxException if the <code>uriRefString</code> is not a 
	 *         valid RDF URI Reference. 
	 */
	public Statement createStatement(OWLGraph graph, String uriRefString)
			throws URISyntaxException {
		return (Statement)this.internalCreate(graph, Statement.class,RDFFactory.eINSTANCE.createURIReference(uriRefString));
	}

	/**
	 * Returns an object of class '<em>Statement</em>'.
	 * 
	 * @param graph  the context graph of this Statement
	 * @param uriRef the RDF URI Reference of the Statement
	 * @return an object of class '<em>Statement</em>'.
	 */
	public Statement createStatement(OWLGraph graph, URIReference uriRef) {
		return (Statement)this.internalCreate(graph, Statement.class,uriRef);
	}

	/**
	 * Returns an object of class '<em>Statement</em>'.
	 * 
	 * @param graph           the context graph of this Statement
	 * @param namespace       the namespace of the RDF URI Reference of the Statement
	 * @param localNameString the fragment identifier of the RDF URI Reference of the Statement
	 * @return an object of class '<em>Statement</em>'.
	 */
	public Statement createStatement(OWLGraph graph, Namespace namespace,
			String localNameString) {
		return (Statement)this.internalCreate(graph, Statement.class,RDFFactory.eINSTANCE.createURIReference(namespace,localNameString));
		
	}
}
