/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: RDFBaseFactoryImpl.java,v 1.1 2007/03/18 08:10:12 lzhang Exp $
 */
package org.eclipse.eodm.rdf.rdfbase.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.eodm.rdf.rdfbase.*;
import org.eclipse.eodm.rdf.rdfbase.util.RDFBaseFactory;
import org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class RDFBaseFactoryImpl extends EFactoryImpl implements RDFBaseFactory {
	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RDFBaseFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case RDFBasePackage.BLANK_NODE: return createBlankNode();
			case RDFBasePackage.RDFS_RESOURCE: return createRDFSResource();
			case RDFBasePackage.PLAIN_LITERAL: return createPlainLiteral();
			case RDFBasePackage.RDFS_LITERAL: return createRDFSLiteral();
			case RDFBasePackage.URI_REFERENCE: return createURIReference();
			case RDFBasePackage.RDF_STATEMENT: return createRDFStatement();
			case RDFBasePackage.UNIFORM_RESOURCE_IDENTIFIER: return createUniformResourceIdentifier();
			case RDFBasePackage.RDF_GRAPH: return createGraph();
			case RDFBasePackage.URI_REFERENCE_NODE: return createURIReferenceNode();
			case RDFBasePackage.TYPED_LITERAL: return createTypedLiteral();
			case RDFBasePackage.RDFXML_LITERAL: return createRDFXMLLiteral();
			default:
				//TODO: Add generic creation using RDFFactoryImpl.genericCreate
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BlankNode createBlankNode() {
		BlankNodeImpl blankNode = new BlankNodeImpl();
		return blankNode;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RDFSResource createRDFSResource() {
		RDFSResourceImpl rdfsResource = new RDFSResourceImpl();
		return rdfsResource;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PlainLiteral createPlainLiteral() {
		PlainLiteralImpl plainLiteral = new PlainLiteralImpl();
		return plainLiteral;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RDFSLiteral createRDFSLiteral() {
		RDFSLiteralImpl rdfsLiteral = new RDFSLiteralImpl();
		return rdfsLiteral;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public URIReference createURIReference() {
		URIReferenceImpl uriReference = new URIReferenceImpl();
		return uriReference;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RDFStatement createRDFStatement() {
		RDFStatementImpl rdfStatement = new RDFStatementImpl();
		return rdfStatement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UniformResourceIdentifier createUniformResourceIdentifier() {
		UniformResourceIdentifierImpl uniformResourceIdentifier = new UniformResourceIdentifierImpl();
		return uniformResourceIdentifier;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RDFGraph createGraph() {
		RDFGraphImpl graph = new RDFGraphImpl();
		return graph;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public URIReferenceNode createURIReferenceNode() {
		URIReferenceNodeImpl uriReferenceNode = new URIReferenceNodeImpl();
		return uriReferenceNode;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TypedLiteral createTypedLiteral() {
		TypedLiteralImpl typedLiteral = new TypedLiteralImpl();
		return typedLiteral;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RDFXMLLiteral createRDFXMLLiteral() {
		RDFXMLLiteralImpl rdfxmlLiteral = new RDFXMLLiteralImpl();
		return rdfxmlLiteral;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RDFBasePackage getrdfbasePackage() {
		return (RDFBasePackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	public static RDFBasePackage getPackage() {
		return RDFBasePackage.eINSTANCE;
	}

} //RDFBaseFactoryImpl
