/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: RDFUtility.java,v 1.1 2007/03/18 08:10:12 lzhang Exp $
 */

package org.eclipse.eodm.util;

import java.util.Date;
import java.util.Random;
import java.util.HashMap;
import java.util.ArrayList;

import org.eclipse.eodm.RDFFactory;
import org.eclipse.eodm.impl.EODMImplPackage;
import org.eclipse.eodm.rdf.rdfbase.URIReference;
import org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage;
import org.eclipse.eodm.rdf.rdfs.util.RDFSPackage;
import org.eclipse.eodm.rdf.rdfweb.Namespace;
import org.eclipse.eodm.vocabulary.RDF;
import org.eclipse.eodm.vocabulary.RDFS;

public class RDFUtility {
    
    // The URI of rdf classes
    public static Namespace rdf;
    public static Namespace rdfs;
    public static URIReference rdfsresource;
    public static URIReference rdfsclass;
    public static URIReference rdfalt;
    public static URIReference rdfbag;
    public static URIReference rdflist;
    public static URIReference rdfseq;
    public static URIReference rdfstatement;
    public static URIReference rdfproperty;
    public static URIReference rdfscontainer;
    public static URIReference rdfscontainermembershipproperty;
    public static URIReference rdfsdatatype;
    static {
    	try{
    		rdf = RDFFactory.eINSTANCE.createNamespace( RDF.NAMESPACE );
    		rdfs = RDFFactory.eINSTANCE.createNamespace( RDFS.NAMESPACE );
    		rdfsresource = RDFFactory.eINSTANCE.createURIReference(rdfs, RDFS.C_RESOURCE );
    		rdfsclass = RDFFactory.eINSTANCE.createURIReference(rdfs, RDFS.C_CLASS );
    		rdfalt = RDFFactory.eINSTANCE.createURIReference(rdf, RDF.C_ALT );
    		rdfbag = RDFFactory.eINSTANCE.createURIReference(rdf, RDF.C_BAG );
    		rdflist = RDFFactory.eINSTANCE.createURIReference(rdf, RDF.C_LIST );
    		rdfseq = RDFFactory.eINSTANCE.createURIReference(rdf, RDF.C_SEQ );
    		rdfstatement = RDFFactory.eINSTANCE.createURIReference(rdf, RDF.C_STATEMENT );
    		rdfproperty = RDFFactory.eINSTANCE.createURIReference(rdf, RDF.C_PROPERTY );
    		rdfscontainer = RDFFactory.eINSTANCE.createURIReference(rdfs, RDFS.CONTAINER );
    		rdfscontainermembershipproperty = RDFFactory.eINSTANCE.createURIReference(rdfs, RDFS.CONTAINERMEMBERSHIPPROPERTY);
    		rdfsdatatype = RDFFactory.eINSTANCE.createURIReference(rdfs, RDFS.C_DATATYPE );
    		
    	}catch(Exception e){e.printStackTrace();}
    }
 
    static Random random = new Random();
	static HashMap eReferenceList = null;
	static HashMap featureIDList = null;
	static HashMap eClassList = null;
	static ArrayList predicateList = null;
	
	public static ArrayList getPredicates()
	{
		if(predicateList == null)
		{
			predicateList = new ArrayList();
			for (int i=0; i<RDF.ALL_RDF_PREDICATES_URIS.length; i++)
				predicateList.add( RDF.ALL_RDF_PREDICATES_URIS[i] );
			for (int i=0; i<RDFS.ALL_RDFS_PREDICATES_URIS.length; i++ )
				predicateList.add( RDFS.ALL_RDFS_PREDICATES_URIS[i] );
		}
		return predicateList;
	}
	
	public static HashMap getEClass()
	{
		if(eClassList==null)
		{
			eClassList = new HashMap();
			eClassList.put( RDF.C_PROPERTY_STR,		RDFBasePackage.eINSTANCE.getRDFProperty());
			eClassList.put( RDF.C_STATEMENT_STR,	RDFBasePackage.eINSTANCE.getRDFStatement());
			eClassList.put( RDFS.C_RESOURCE_STR,	RDFBasePackage.eINSTANCE.getRDFSResource());
			eClassList.put( RDFS.C_CLASS_STR,		RDFSPackage.eINSTANCE.getRDFSClass());
			eClassList.put( RDFS.CONTAINER_STR,		RDFSPackage.eINSTANCE.getRDFSContainer());
			eClassList.put( RDFS.CONTAINERMEMBERSHIPPROPERTY_STR,	RDFSPackage.eINSTANCE.getRDFSContainerMembershipProperty());
			eClassList.put( RDF.C_BAG_STR,			RDFSPackage.eINSTANCE.getRDFBag());
			eClassList.put( RDF.C_ALT_STR,			RDFSPackage.eINSTANCE.getRDFAlt());
			eClassList.put( RDF.C_SEQ_STR,			RDFSPackage.eINSTANCE.getRDFSeq());
			eClassList.put( RDF.C_LIST_STR,			RDFSPackage.eINSTANCE.getRDFList());
			eClassList.put( RDFS.C_DATATYPE_STR,	RDFSPackage.eINSTANCE.getRDFSDatatype());
			
		}
		
		return eClassList;
	}
	
	public static HashMap getEReferenceList()
	{
		if(eReferenceList==null)
		{
			eReferenceList = new HashMap();
			eReferenceList.put( RDFS.P_SUBCLASSOF_STR, 		RDFSPackage.eINSTANCE.getRDFSClass_RDFSsubClassOf());
			eReferenceList.put( RDFS.P_SUBPROPERTYOF_STR,	RDFBasePackage.eINSTANCE.getRDFProperty_RDFSsubPropertyOf());
			eReferenceList.put( RDFS.P_DOMAIN_STR,			RDFBasePackage.eINSTANCE.getRDFProperty_RDFSdomain());
			eReferenceList.put( RDFS.P_RANGE_STR,			RDFBasePackage.eINSTANCE.getRDFProperty_RDFSrange());
			eReferenceList.put( RDFS.P_COMMENT_STR,			RDFBasePackage.eINSTANCE.getRDFSResource_RDFScomment());
			eReferenceList.put( RDF.P_TYPE_STR,				RDFBasePackage.eINSTANCE.getRDFSResource_RDFtype());
			eReferenceList.put( RDFS.P_LABEL_STR,			RDFBasePackage.eINSTANCE.getRDFSResource_RDFSlabel());
			eReferenceList.put( RDFS.P_MEMBER_STR,			RDFBasePackage.eINSTANCE.getRDFSResource_RDFSmember());
			eReferenceList.put( RDFS.ISDEFINEDBY_STR, 		RDFBasePackage.eINSTANCE.getRDFSResource_RDFSisDefinedBy());
			eReferenceList.put( RDFS.SEEALSO_STR, 			RDFBasePackage.eINSTANCE.getRDFSResource_RDFSseeAlso());
			eReferenceList.put( RDF.P_FIRST_STR,			RDFSPackage.eINSTANCE.getRDFList_RDFfirst());
			eReferenceList.put( RDF.P_REST_STR,				RDFSPackage.eINSTANCE.getRDFList_RDFrest());
			eReferenceList.put( RDF.P_SUBJECT_STR, 			RDFBasePackage.eINSTANCE.getRDFStatement_RDFsubject());
			eReferenceList.put( RDF.P_PREDICATE_STR,		RDFBasePackage.eINSTANCE.getRDFStatement_RDFpredicate());
			eReferenceList.put( RDF.P_OBJECT_STR,			RDFBasePackage.eINSTANCE.getRDFStatement_RDFobject());
			
			
		}
		return eReferenceList;
		
	}
	public static HashMap getFeatureIDList()
	{
		if(featureIDList==null)
		{
			featureIDList = new HashMap();
			featureIDList.put( RDFS.P_SUBCLASSOF_STR,		new Integer(EODMImplPackage.INTERNAL_CORE__RDF_SSUB_CLASS_OF));
			featureIDList.put( RDFS.P_SUBPROPERTYOF_STR, 	new Integer(EODMImplPackage.INTERNAL_CORE__RDF_SSUB_PROPERTY_OF));
			featureIDList.put( RDFS.P_DOMAIN_STR,			new Integer(EODMImplPackage.INTERNAL_CORE__RDF_SDOMAIN));
			featureIDList.put( RDFS.P_RANGE_STR,			new Integer(EODMImplPackage.INTERNAL_CORE__RDF_SRANGE));
			featureIDList.put( RDFS.P_COMMENT_STR,			new Integer(EODMImplPackage.INTERNAL_CORE__RDF_SCOMMENT));
			featureIDList.put( RDF.P_TYPE_STR,				new Integer(EODMImplPackage.INTERNAL_CORE__RD_FTYPE));
			featureIDList.put( RDFS.P_LABEL_STR,			new Integer(EODMImplPackage.INTERNAL_CORE__RDF_SLABEL));
			featureIDList.put( RDFS.P_MEMBER_STR,			new Integer(EODMImplPackage.INTERNAL_CORE__RDF_SMEMBER));
			featureIDList.put( RDFS.ISDEFINEDBY_STR,		new Integer(EODMImplPackage.INTERNAL_CORE__RDF_SIS_DEFINED_BY));
			featureIDList.put( RDFS.SEEALSO_STR,			new Integer(EODMImplPackage.INTERNAL_CORE__RDF_SSEE_ALSO));
			featureIDList.put( RDF.P_FIRST_STR,				new Integer(EODMImplPackage.INTERNAL_CORE__RD_FFIRST));
			featureIDList.put( RDF.P_REST_STR,				new Integer(EODMImplPackage.INTERNAL_CORE__RD_FREST));
			featureIDList.put( RDF.P_SUBJECT_STR,			new Integer(EODMImplPackage.INTERNAL_CORE__RD_FSUBJECT));
			featureIDList.put( RDF.P_PREDICATE_STR,			new Integer(EODMImplPackage.INTERNAL_CORE__RD_FPREDICATE));
			featureIDList.put( RDF.P_OBJECT_STR,			new Integer(EODMImplPackage.INTERNAL_CORE__RD_FOBJECT));

		}
		return featureIDList;
	}

	public static int getFeatureIDbyPredicateURI(String uri)
	{
		if(RDFUtility.getFeatureIDList().get(uri)!=null)
		{
			return ((Integer)RDFUtility.getFeatureIDList().get(uri)).intValue();
		}
		else
			return 0;
	}
	public static String nodeidGenerator()
	{
	    return "nodeid"+String.valueOf(new Date().getTime()+random.nextInt());
	}
}
