/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.clazz.part;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.diagram.clazz.edit.commands.UMLCreateShortcutDecorationsCommand;
import org.eclipse.uml2.diagram.clazz.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.diagram.clazz.part.UMLElementChooserDialog;

public class UMLCreateShortcutAction
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        EObject selectedElement;
        IEditorPart diagramEditor = HandlerUtil.getActiveEditorChecked((ExecutionEvent)event);
        Shell shell = diagramEditor.getEditorSite().getShell();
        assert (diagramEditor instanceof DiagramEditor);
        TransactionalEditingDomain editingDomain = ((DiagramEditor)diagramEditor).getEditingDomain();
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        assert (selection instanceof IStructuredSelection);
        assert (((IStructuredSelection)selection).size() == 1);
        assert (((IStructuredSelection)selection).getFirstElement() instanceof EditPart);
        EditPart selectedDiagramPart = (EditPart)((IStructuredSelection)selection).getFirstElement();
        View view = (View)selectedDiagramPart.getModel();
        UMLElementChooserDialog elementChooser = new UMLElementChooserDialog(shell, view);
        int result = elementChooser.open();
        if (result != 0) {
            return null;
        }
        URI selectedModelElementURI = elementChooser.getSelectedModelElementURI();
        try {
            selectedElement = editingDomain.getResourceSet().getEObject(selectedModelElementURI, true);
        }
        catch (WrappedException e) {
            UMLDiagramEditorPlugin.getInstance().logError("Exception while loading object: " + selectedModelElementURI.toString(), e);
            return null;
        }
        if (selectedElement == null) {
            return null;
        }
        IOperationHistory history = OperationHistoryFactory.getOperationHistory();
        IStatus status = UMLCreateShortcutAction.createShortcut(editingDomain, history, selectedElement, selectedDiagramPart, diagramEditor);
        if (!status.isOK()) {
            UMLDiagramEditorPlugin.getInstance().logError(status.getMessage(), status.getException());
        }
        return null;
    }

    public static IStatus createShortcut(TransactionalEditingDomain editingDomain, IOperationHistory history, EObject selectedElement, EditPart editPart, IEditorPart diagramEditor) {
        View view = (View)editPart.getModel();
        EditPart parentPart = editPart.getParent();
        Diagram diagram = view.getDiagram();
        CreateViewRequest.ViewDescriptor viewDescriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter(selectedElement), Node.class, null, UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
        CreateCommand command = new CreateCommand(editingDomain, viewDescriptor, (View)diagram);
        command = command.compose((IUndoableOperation)new UMLCreateShortcutDecorationsCommand(editingDomain, (View)diagram, viewDescriptor));
        IStatus status = null;
        try {
            status = OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            status = new Status(4, "org.eclipse.uml2.diagram.clazz", 0, "Unable to create shortcut", (Throwable)e);
        }
        CanonicalEditPolicy policy = (CanonicalEditPolicy)parentPart.getEditPolicy((Object)"Canonical");
        if (policy != null) {
            policy.refresh();
        }
        return status;
    }
}

