/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.clazz.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.gmf.runtime.common.ui.preferences.CheckBoxFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.uml2.diagram.clazz.part.Messages;
import org.eclipse.uml2.diagram.clazz.part.UMLDiagramEditor;
import org.eclipse.uml2.diagram.clazz.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.diagram.clazz.providers.UMLElementTypes;
import org.eclipse.uml2.diagram.common.preferences.IconStylePreferencePage;

public class DiagramIconStylePreferencePage
extends IconStylePreferencePage {
    private static Map<String, Integer> ourConnectorLabels2Vids = new HashMap<String, Integer>();
    private final List<CheckBoxFieldEditor> myByVisualIdEditors = new ArrayList<CheckBoxFieldEditor>();
    private RadioGroupFieldEditor myModeEditor;
    private Composite myCheckBoxesPanel;
    private IWorkbench myWorkbench;

    static {
        ourConnectorLabels2Vids.put(Messages.DiagramIconStylePreferencePage_LinkLabelsFilter_GeneralizationQualifiedName_6018, 6018);
        ourConnectorLabels2Vids.put(Messages.DiagramIconStylePreferencePage_LinkLabelsFilter_DependencyName_6001, 6001);
        ourConnectorLabels2Vids.put(Messages.DiagramIconStylePreferencePage_LinkLabelsFilter_DependencyName_6010, 6010);
        ourConnectorLabels2Vids.put(Messages.DiagramIconStylePreferencePage_LinkLabelsFilter_PropertyName_6002, 6002);
        ourConnectorLabels2Vids.put(Messages.DiagramIconStylePreferencePage_LinkLabelsFilter_PropertyName_6012, 6012);
        ourConnectorLabels2Vids.put(Messages.DiagramIconStylePreferencePage_LinkLabelsFilter_PropertyName_6017, 6017);
        ourConnectorLabels2Vids.put(Messages.DiagramIconStylePreferencePage_LinkLabelsFilter_AssociationName_6003, 6003);
        ourConnectorLabels2Vids.put(Messages.DiagramIconStylePreferencePage_LinkLabelsFilter_AssociationName_6004, 6004);
        ourConnectorLabels2Vids.put(Messages.DiagramIconStylePreferencePage_LinkLabelsFilter_AssociationName_6005, 6005);
        ourConnectorLabels2Vids.put(Messages.DiagramIconStylePreferencePage_LinkLabelsFilter_AssociationName_6006, 6006);
        ourConnectorLabels2Vids.put(Messages.DiagramIconStylePreferencePage_LinkLabelsFilter_AssociationName_6007, 6007);
        ourConnectorLabels2Vids.put(Messages.DiagramIconStylePreferencePage_LinkLabelsFilter_AssociationName_6008, 6008);
        ourConnectorLabels2Vids.put(Messages.DiagramIconStylePreferencePage_LinkLabelsFilter_AssociationName_6009, 6009);
        ourConnectorLabels2Vids.put(Messages.DiagramIconStylePreferencePage_LinkLabelsFilter_AssociationQualifiedName_6019, 6019);
        ourConnectorLabels2Vids.put(Messages.DiagramIconStylePreferencePage_LinkLabelsFilter_InterfaceRealizationQualifiedName_6020, 6020);
        ourConnectorLabels2Vids.put(Messages.DiagramIconStylePreferencePage_LinkLabelsFilter_RealizationName_6011, 6011);
        ourConnectorLabels2Vids.put(Messages.DiagramIconStylePreferencePage_LinkLabelsFilter_RealizationQualifiedName_6021, 6021);
        ourConnectorLabels2Vids.put(Messages.DiagramIconStylePreferencePage_LinkLabelsFilter_GeneralizationQualifiedName_6022, 6022);
        ourConnectorLabels2Vids.put(Messages.DiagramIconStylePreferencePage_LinkLabelsFilter_UsageQualifiedName_6023, 6023);
        ourConnectorLabels2Vids.put(Messages.DiagramIconStylePreferencePage_LinkLabelsFilter_SlotLabel_6015, 6015);
        ourConnectorLabels2Vids.put(Messages.DiagramIconStylePreferencePage_LinkLabelsFilter_SlotLabel_6016, 6016);
        ourConnectorLabels2Vids.put(Messages.DiagramIconStylePreferencePage_LinkLabelsFilter_TemplateBindingLabel_6013, 6013);
        ourConnectorLabels2Vids.put(Messages.DiagramIconStylePreferencePage_LinkLabelsFilter_TemplateBindingLabel_6014, 6014);
        ourConnectorLabels2Vids.put(Messages.DiagramIconStylePreferencePage_LinkLabelsFilter_TemplateBindingQualifiedName_6024, 6024);
    }

    public static void initConnectorLabelDefaults(IPreferenceStore store) {
        for (Integer visualId : ourConnectorLabels2Vids.values()) {
            store.setDefault(DiagramIconStylePreferencePage.getConnectionLabelPreference((int)visualId), true);
        }
    }

    public DiagramIconStylePreferencePage() {
        this.setPreferenceStore(UMLDiagramEditorPlugin.getInstance().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
        super.init(workbench);
        this.myWorkbench = workbench;
    }

    public boolean performOk() {
        super.performOk();
        UMLElementTypes.refreshImageRegistry();
        this.refreshDiagramEditors();
        return true;
    }

    private void refreshDiagramEditors() {
        IEditorReference[] editors = this.myWorkbench.getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int i = 0;
        while (i < editors.length) {
            IEditorPart editor = editors[i].getEditor(false);
            if (editor != null && editor instanceof UMLDiagramEditor) {
                ((UMLDiagramEditor)editor).refresh();
            }
            ++i;
        }
    }

    protected void initHelp() {
    }

    protected void addFields(Composite parent) {
        super.addFields(parent);
        this.createShowHideIconsGroup(parent);
        this.createShowHideConnectorIconsGroup(parent);
    }

    protected CheckBoxFieldEditor addCheckBoxForVisualIds(Composite parent, String commonLabel, int ... visualIds) {
        StringBuffer propertyName = new StringBuffer("show.visual.id");
        int[] nArray = visualIds;
        int n = visualIds.length;
        int n2 = 0;
        while (n2 < n) {
            int nextVID = nArray[n2];
            propertyName.append('.').append(nextVID);
            ++n2;
        }
        CheckBoxFieldEditor result = new CheckBoxFieldEditor(propertyName.toString(), commonLabel, parent);
        this.addField((FieldEditor)result);
        this.myByVisualIdEditors.add(result);
        return result;
    }

    protected void initialize() {
        super.initialize();
        boolean stateShowSelected = "show.selected.visual.ids".equals(this.getPreferenceStore().getString("iconstyle.show-hide.mode"));
        this.enableVisualIdChoices(stateShowSelected);
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if ("field_editor_value".equals(event.getProperty())) {
            boolean nowConfigurable = "show.selected.visual.ids".equals(event.getNewValue());
            boolean wasConfigurable = "show.selected.visual.ids".equals(event.getOldValue());
            if (nowConfigurable || wasConfigurable) {
                this.enableVisualIdChoices(nowConfigurable);
            }
        }
    }

    private void enableVisualIdChoices(boolean enabled) {
        for (CheckBoxFieldEditor next : this.myByVisualIdEditors) {
            next.setEnabled(enabled, this.myCheckBoxesPanel);
        }
    }

    private Composite createShowHideIconsGroup(Composite parent) {
        Composite showHideIconsGroup = new Composite(parent, 0);
        showHideIconsGroup.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        showHideIconsGroup.setLayout((Layout)layout);
        String[][] choices = new String[][]{{LABEL_HIDE_ALL, "hide.all"}, {LABEL_SHOW_ALL, "show.all"}, {LABEL_SHOW_BY_VISUAL_ID, "show.selected.visual.ids"}};
        this.myModeEditor = new RadioGroupFieldEditor("iconstyle.show-hide.mode", LABEL_SHOW_HIDE_MODE, 1, choices, showHideIconsGroup, true);
        this.addField((FieldEditor)this.myModeEditor);
        Composite e = this.createExpansibleComposite(this.myModeEditor.getRadioBoxControl(showHideIconsGroup), "Elements");
        this.myCheckBoxesPanel = new Composite(e, 0);
        this.myCheckBoxesPanel.setLayout((Layout)new GridLayout());
        this.myCheckBoxesPanel.setLayoutData((Object)new GridData(768));
        this.addAllCheckBoxes(this.myCheckBoxesPanel);
        this.enableVisualIdChoices(false);
        return showHideIconsGroup;
    }

    private void addAllCheckBoxes(Composite parent) {
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_AssociationClass, 5009, 3012);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_Class, 5003, 5021, 3007, 3003, 3030);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_Comment, 5030);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_DataType, 5006, 5027, 3008);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_Dependency, 5011);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_ElementImport, 3031);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_Enumeration, 5005, 5023, 3011);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_EnumerationLiteral, 3016);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_Expression, 3040);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_InstanceSpecification, 5010, 5029, 5024, 3013);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_Interface, 5018, 3041);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_LiteralInteger, 3039);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_LiteralString, 3038);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_Operation, 3002, 3020, 3015, 3022, 3024, 3029);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_Package, 5004, 5041, 3006);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_PrimitiveType, 5007, 5028, 3009);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_Property, 3001, 3019, 3014, 3021, 3023, 3028);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_Slot, 3017);
    }

    private Composite createShowHideConnectorIconsGroup(Composite parent) {
        IconStylePreferencePage.ShowHideConnectorLabelGroup builder = new IconStylePreferencePage.ShowHideConnectorLabelGroup((IconStylePreferencePage)this);
        return builder.createShowHideConnectorLabelGroup(parent, ourConnectorLabels2Vids);
    }
}

