/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.draw2d;

import java.util.List;
import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemsAwareFreeFormLayer;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderedNodeFigure;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.uml2.diagram.common.draw2d.BorderItemNameLocator;

public class CoveredFreeformLayer
extends BorderItemsAwareFreeFormLayer {
    private Rectangle myFreeformExtent;
    private Insets myMarginInsets;
    private double myMarginRatio = 0.1;

    public Rectangle getFreeformExtent() {
        if (this.myFreeformExtent != null) {
            return this.myFreeformExtent;
        }
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            Rectangle childBounds;
            IFigure child = (IFigure)children.get(i);
            if (child instanceof FreeformFigure) {
                childBounds = ((FreeformFigure)child).getFreeformExtent();
            } else {
                Dimension size = child.getPreferredSize().getCopy();
                size.width += this.getMarginInsets().getWidth();
                size.height += this.getMarginInsets().getHeight();
                childBounds = new Rectangle(0, 0, size.width, size.height);
            }
            if (this.myFreeformExtent == null) {
                this.myFreeformExtent = childBounds.getCopy();
            } else {
                this.myFreeformExtent.union(childBounds);
            }
            ++i;
        }
        Insets insets = this.getInsets();
        if (this.myFreeformExtent == null) {
            this.myFreeformExtent = new Rectangle(0, 0, insets.getWidth(), insets.getHeight());
        } else {
            this.translateToParent((Translatable)this.myFreeformExtent);
            this.myFreeformExtent.expand(insets);
        }
        return this.myFreeformExtent;
    }

    public void setFreeformBounds(Rectangle bounds) {
        this.setBounds(bounds);
        bounds = bounds.getCopy();
        this.translateFromParent((Translatable)bounds);
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            if (child instanceof FreeformFigure) {
                ((FreeformFigure)child).setFreeformBounds(bounds);
            } else {
                Insets insets = this.getMarginInsets();
                int x = insets.left;
                int y = insets.top;
                Dimension size = bounds.getSize().getCopy().shrink(insets.getWidth(), insets.getHeight());
                Rectangle childBounds = new Rectangle(x, y, size.width, size.height);
                if (child instanceof BorderedNodeFigure) {
                    this.validateSideAffixedElements((BorderedNodeFigure)child, childBounds);
                }
                child.setBounds(childBounds);
            }
            ++i;
        }
    }

    public void invalidate() {
        super.invalidate();
        this.myFreeformExtent = null;
    }

    public final Insets getMarginInsets() {
        TranslatableInsets insets = new TranslatableInsets(this.myMarginInsets);
        this.translateToRelative(insets);
        return insets;
    }

    public void setMarginInsets(Insets insets) {
        this.myMarginInsets = insets;
    }

    private void validateSideAffixedElements(BorderedNodeFigure parent, Rectangle area) {
        List borderItems = parent.getBorderItemContainer().getChildren();
        for (IFigure borderItem : borderItems) {
            Rectangle labelBounds;
            if (borderItem instanceof BorderedNodeFigure) {
                this.validateSideAffixedElements((BorderedNodeFigure)borderItem, area);
                continue;
            }
            if (!(borderItem instanceof WrapLabel) || area.contains(labelBounds = borderItem.getBounds())) continue;
            Rectangle union = area.getCopy().union(labelBounds);
            int xShift = union.width - area.width;
            int x = area.x == union.x ? -xShift : xShift;
            int yShift = union.height - area.height;
            int y = area.y == union.y ? -yShift : yShift;
            ((BorderItemNameLocator)((Object)parent.getBorderItemContainer().getLayoutManager().getConstraint(borderItem))).getConstraint().translate(x, y);
        }
    }

    private static class TranslatableInsets
    extends Insets
    implements Translatable {
        public TranslatableInsets(Insets insets) {
            super(insets);
        }

        public void performScale(double factor) {
            this.top = (int)Math.floor((double)this.top * factor);
            this.bottom = (int)Math.floor((double)this.bottom * factor);
            this.left = (int)Math.floor((double)this.left * factor);
            this.right = (int)Math.floor((double)this.right * factor);
        }

        public void performTranslate(int dx, int dy) {
        }
    }
}

