/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.parser;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.uml2.uml.PackageableElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementProvider {
    private final SortedMap<String, PackageableElement> myNamesMap;
    private final SortedSet<String> myCaseInsensitiveNames;
    private final SortedSet<String> myCaseInsensitiveNamesRO;
    private ResourceSet myResourceSet;
    private EObject myContext;
    private boolean myIsCaching;

    public ElementProvider() {
        this(false);
    }

    public ElementProvider(boolean isCaching) {
        this.myIsCaching = isCaching;
        this.myNamesMap = new TreeMap<String, PackageableElement>();
        this.myCaseInsensitiveNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        this.myCaseInsensitiveNamesRO = Collections.unmodifiableSortedSet(this.myCaseInsensitiveNames);
    }

    public Iterable<PackageableElement> getElements(EObject eObject) {
        this.setContext(eObject);
        return this.myNamesMap.values();
    }

    public SortedSet<String> getElementNames(EObject eObject) {
        this.setContext(eObject);
        return this.myCaseInsensitiveNamesRO;
    }

    public PackageableElement findElement(EObject context, String name) {
        this.setContext(context);
        return (PackageableElement)this.myNamesMap.get(name.trim());
    }

    protected void setContext(EObject context) {
        this.myContext = context;
        ResourceSet resourceSet = context.eResource().getResourceSet();
        if (this.myIsCaching && this.myResourceSet != null && this.myResourceSet.equals(resourceSet) && !this.moreResourcesWereLoaded(resourceSet)) {
            return;
        }
        this.myNamesMap.clear();
        this.myCaseInsensitiveNames.clear();
        this.myResourceSet = resourceSet;
        for (PackageableElement element : this.loadAllElements(resourceSet)) {
            String displayName = this.getDisplayProposal(element);
            if (displayName == null) continue;
            this.myCaseInsensitiveNames.add(displayName);
            this.myNamesMap.put(displayName, element);
        }
    }

    protected String getDisplayProposal(PackageableElement element) {
        return element.getName();
    }

    protected List<PackageableElement> loadAllElements(ResourceSet resourceSet) {
        EList resources = resourceSet.getResources();
        LinkedList<PackageableElement> allElements = new LinkedList<PackageableElement>();
        for (Resource metamodel : resources) {
            TreeIterator contents = metamodel.getAllContents();
            while (contents.hasNext()) {
                EObject next = (EObject)contents.next();
                if (!this.isSuitable(next)) continue;
                allElements.add((PackageableElement)next);
            }
        }
        return allElements;
    }

    protected boolean isSuitable(Object object) {
        return object instanceof PackageableElement && ((PackageableElement)object).getName() != null;
    }

    protected EObject getContext() {
        return this.myContext;
    }

    private boolean moreResourcesWereLoaded(ResourceSet resourceSet) {
        return !this.myResourceSet.getResources().equals((Object)resourceSet.getResources());
    }
}

