/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.parser.operation;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.diagram.parser.AbstractToString;
import org.eclipse.uml2.diagram.parser.ExternalToString;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UMLPackage;

public abstract class OperationToString
extends AbstractToString {
    protected String getToString(EObject object, boolean editNotView, int flags) {
        Operation operation = this.asOperation(object);
        StringBuffer result = new StringBuffer();
        if (!editNotView && 1 == flags) {
            this.appendName(result, (NamedElement)operation);
            result.append("()");
            Parameter ret = operation.getReturnResult();
            if (ret != null) {
                this.appendType(result, (TypedElement)ret);
            }
            return result.toString();
        }
        result.append(this.getVisibility((NamedElement)operation));
        this.appendName(result, (NamedElement)operation);
        result.append("( ");
        Parameter ret = operation.getReturnResult();
        boolean firstWritten = false;
        for (Parameter next : operation.getOwnedParameters()) {
            if (next.equals(ret)) continue;
            if (firstWritten) {
                result.append(", ");
            }
            firstWritten = true;
            result.append(this.getDirection(next));
            this.appendName(result, (NamedElement)next);
            this.appendType(result, (TypedElement)next);
            this.appendMultiplicity(result, (MultiplicityElement)next);
            if (!editNotView) continue;
            this.appendDefaultParameterValue(result, next);
        }
        result.append(" )");
        if (ret != null) {
            this.appendType(result, (TypedElement)ret);
        }
        if (editNotView) {
            this.appendModifiers(result, operation);
        }
        return result.toString();
    }

    protected void appendDefaultParameterValue(StringBuffer result, Parameter parameter) {
        String def = parameter.getDefault();
        if (!OperationToString.isEmpty((String)def)) {
            result.append(" = ");
            result.append(def);
        }
    }

    protected String getDirection(Parameter parameter) {
        ParameterDirectionKind direction = parameter.getDirection();
        switch (direction.getValue()) {
            case 0: {
                return "";
            }
            case 2: {
                return "out ";
            }
            case 1: {
                return "inout ";
            }
            case 3: {
                throw new IllegalStateException("Return parameter should not be included into parameters list");
            }
        }
        throw new IllegalStateException("Unknown parameter direction kind: " + direction + " for parameter: " + parameter);
    }

    protected Operation asOperation(EObject object) {
        if (!(object instanceof Operation)) {
            throw new IllegalStateException("I can not provide toString for: " + object);
        }
        return (Operation)object;
    }

    public void appendModifiers(StringBuffer result, Operation operation) {
        AbstractToString.ModifiersBuilder builder = new AbstractToString.ModifiersBuilder();
        if (operation.isQuery()) {
            builder.appendModifier("query");
        }
        if (operation.isOrdered()) {
            builder.appendModifier("ordered");
        }
        if (operation.isUnique()) {
            builder.appendModifier("unique");
        }
        for (Operation next : operation.getRedefinedOperations()) {
            String nextName = next.getName();
            if (OperationToString.isEmpty((String)nextName)) continue;
            builder.appendModifier("redefines " + nextName);
        }
        builder.writeInto(result);
    }

    public static class EDIT
    extends OperationToString {
        public String getToString(EObject object, int flags) {
            return this.getToString(object, true, flags);
        }

        public boolean isAffectingFeature(EStructuralFeature feature) {
            throw new UnsupportedOperationException();
        }
    }

    public static class VIEW
    extends OperationToString
    implements ExternalToString.WithReferences {
        private static final List AFFECTING = Arrays.asList(UMLPackage.eINSTANCE.getNamedElement_Visibility(), UMLPackage.eINSTANCE.getNamedElement_Name(), UMLPackage.eINSTANCE.getBehavior_OwnedParameter(), UMLPackage.eINSTANCE.getParameter_Direction(), UMLPackage.eINSTANCE.getTypedElement_Type(), UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue(), UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue(), UMLPackage.eINSTANCE.getLiteralUnlimitedNatural_Value(), UMLPackage.eINSTANCE.getLiteralInteger_Value());

        public String getToString(EObject object, int flags) {
            return this.getToString(object, false, flags);
        }

        public boolean isAffectingFeature(EStructuralFeature feature) {
            return AFFECTING.contains(feature);
        }

        public List getAdditionalReferencedElements(EObject object) {
            Operation operation = this.asOperation(object);
            LinkedList result = new LinkedList(){

                public boolean add(Object data) {
                    return data != null && super.add(data);
                }
            };
            result.add(operation);
            for (Parameter next : operation.getOwnedParameters()) {
                result.add(next.getType());
                result.add(next);
                result.add(next.getLowerValue());
                result.add(next.getUpperValue());
            }
            return result;
        }
    }
}

