/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.editpolicies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ConstrainedLayoutEditPolicy;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.handles.ResizableHandleKit;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.BorderItemSelectionEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.common.draw2d.LaneLayout;

public class LaneLayoutEditPolicy
extends ConstrainedLayoutEditPolicy {
    private int myLaneOrientation;

    public LaneLayoutEditPolicy() {
        this(LaneLayout.HORIZONTAL);
    }

    public LaneLayoutEditPolicy(int laneOrientation) {
        this.setLaneOrientation(laneOrientation);
    }

    public void setLaneOrientation(int orientation) {
        if (orientation != LaneLayout.HORIZONTAL && orientation != LaneLayout.VERTICAL) {
            throw new IllegalArgumentException("Incorrect lane orientation constant: " + orientation);
        }
        this.myLaneOrientation = orientation;
    }

    public int getLaneOrientation() {
        return this.myLaneOrientation;
    }

    protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
        Dimension constraintSize = ((Rectangle)constraint).getSize();
        Dimension newSize = new Dimension(this.getLaneOrientation() == LaneLayout.HORIZONTAL ? -1 : constraintSize.width, this.getLaneOrientation() == LaneLayout.VERTICAL ? -1 : constraintSize.height);
        Rectangle newBounds = new Rectangle(new Point(0, 0), newSize);
        View shapeView = (View)child.getModel();
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        SetBoundsCommand boundsCommand = new SetBoundsCommand(editingDomain, DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)new EObjectAdapter((EObject)shapeView), newBounds);
        return new ICommandProxy((ICommand)boundsCommand);
    }

    protected Object getConstraintFor(Point point) {
        return null;
    }

    protected Object getConstraintFor(Rectangle rect) {
        return new Rectangle(rect);
    }

    protected Command getCreateCommand(CreateRequest request) {
        return null;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        if (child instanceof IBorderItemEditPart) {
            return new BorderItemSelectionEditPolicy();
        }
        ResizableEditPolicy editPolicy = new ResizableEditPolicy(){

            protected List<?> createSelectionHandles() {
                ArrayList list = new ArrayList();
                ResizableHandleKit.addMoveHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list);
                if (LaneLayoutEditPolicy.this.getLaneOrientation() == LaneLayout.HORIZONTAL) {
                    ResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)1);
                    ResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)4);
                } else {
                    ResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)8);
                    ResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)16);
                }
                return list;
            }
        };
        return editPolicy;
    }
}

