/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.stereo;

import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.uml2.diagram.common.Messages;
import org.eclipse.uml2.diagram.common.commands.ApplyOrUnapplyStereotypeCommand;
import org.eclipse.uml2.diagram.common.commands.RefreshLabelsCommand;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class ApplyStereotypeAction
extends DiagramAction {
    private static final String EMPTY_NAME = Messages.ApplyStereotypeAction_empty_name;
    private Element myElement;
    private Stereotype myStereotype;

    public ApplyStereotypeAction(IWorkbenchPage workbenchPage, Element element, Stereotype stereotype) {
        super(workbenchPage);
        this.myElement = element;
        this.myStereotype = stereotype;
    }

    protected Request createTargetRequest() {
        return null;
    }

    protected boolean isSelectionListener() {
        return true;
    }

    protected Command getCommand() {
        IGraphicalEditPart elementEditPart = this.getElementEditPart();
        if (elementEditPart == null) {
            return UnexecutableCommand.INSTANCE;
        }
        boolean applyNotUnapply = !this.myElement.isStereotypeApplied(this.myStereotype);
        ApplyOrUnapplyStereotypeCommand.ApplyOrUnapplyStereotypeRequest request = new ApplyOrUnapplyStereotypeCommand.ApplyOrUnapplyStereotypeRequest(this.myElement, this.myStereotype, applyNotUnapply);
        CompoundCommand command = new CompoundCommand();
        command.add((Command)new RefreshLabelsCommand(elementEditPart));
        command.add((Command)new ICommandProxy((ICommand)new ApplyOrUnapplyStereotypeCommand(request)));
        command.add((Command)new RefreshLabelsCommand(elementEditPart));
        return command;
    }

    public boolean isEnabled() {
        return this.getElementEditPart() != null;
    }

    public void refresh() {
        super.refresh();
        this.setText(this.calculateText());
        this.setChecked(this.calculateChecked());
    }

    private String calculateText() {
        String name = this.myStereotype.getQualifiedName();
        return name != null ? name : EMPTY_NAME;
    }

    private boolean calculateChecked() {
        return this.isStereotypeAppliedTo(this.myElement, this.myStereotype);
    }

    private IGraphicalEditPart getElementEditPart() {
        for (Object next : this.getSelectedObjects()) {
            if (!(next instanceof IGraphicalEditPart)) continue;
            IGraphicalEditPart elementEditPart = (IGraphicalEditPart)next;
            return elementEditPart;
        }
        return null;
    }

    private boolean isStereotypeAppliedTo(Element element, Stereotype stereotype) {
        return element.isStereotypeApplied(stereotype);
    }
}

