/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.internal.layout.horizontal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.sequence.internal.layout.horizontal.LifeLineDress;
import org.eclipse.uml2.diagram.sequence.internal.layout.horizontal.UntiedFrameHorizontalLayouter;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMFrame;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMVisibleFrameWithPentagon;
import org.eclipse.uml2.diagram.sequence.internal.missed.MissedMethods;

class LifeLineDressImpl
implements LifeLineDress,
MissedMethods.DifferentSemanticInArcasAndGMF {
    private final boolean myIgnoreCurrentPos;
    private FrameWrapper myLeftJustReshaped;
    private FrameWrapper myRightJustReshaped;
    private final OneSide myLeftSide = new LeftSide();
    private final OneSide myRightSide = new RightSide();

    LifeLineDressImpl(boolean pos) {
        this.myIgnoreCurrentPos = pos;
    }

    public int getLeftMinSpace() {
        return this.myLeftSide.getMinOffsetWidth();
    }

    public int getRightMinSpace() {
        return this.myRightSide.getMinOffsetWidth();
    }

    public int getRightSpace() {
        return this.myRightSide.getOuterOffsetWidth();
    }

    public void setMinLeftAndCenter(int minLeft, int center) {
        this.myLeftSide.setLifelinePos(center, !this.myIgnoreCurrentPos);
        this.myRightSide.setLifelinePos(center, !this.myIgnoreCurrentPos);
        if (!this.myIgnoreCurrentPos) {
            int currentOffset;
            if (this.myLeftJustReshaped != null) {
                currentOffset = this.myLeftJustReshaped.getCurrentOffset(center);
                this.myLeftJustReshaped.setOffsetLimit(currentOffset);
                this.myLeftSide.revalidateOffsets(center);
            }
            if (this.myRightJustReshaped != null) {
                currentOffset = this.myRightJustReshaped.getCurrentOffset(center);
                this.myRightJustReshaped.setOffsetLimit(currentOffset);
                this.myRightSide.revalidateOffsets(center);
            }
        }
        this.myLeftSide.setOuterOffsetLimit(center - minLeft);
    }

    public void setMaxRight(int center, int maxRight) {
        this.myRightSide.setOuterOffsetLimit(maxRight - center);
    }

    public void layout(final int center) {
        PositionSetter leftPositionSetter = new PositionSetter(){

            void setFrameBorderPosition(LMFrame lmFrame, int offset) {
                lmFrame.setLeftBorderPosByLayout(center - offset);
            }

            void setUntiedFramePosition(UntiedFrameHorizontalLayouter untiedFrameLayouter, int outerSizePos) {
                untiedFrameLayouter.layout(center - outerSizePos);
            }
        };
        this.myLeftSide.layout(leftPositionSetter);
        PositionSetter rightPositionSetter = new PositionSetter(){

            void setFrameBorderPosition(LMFrame lmFrame, int offset) {
                lmFrame.setRightBorderPosByLayout(center + offset);
            }

            void setUntiedFramePosition(UntiedFrameHorizontalLayouter untiedFrameLayouter, int outerSizePos) {
                throw new UnsupportedOperationException();
            }
        };
        this.myRightSide.layout(rightPositionSetter);
    }

    LeftSideFrameWrapper addLeftFrame(LMFrame lmFrame, int maxLeftBracketOffset, UntiedFrameHorizontalLayouter untiedFrameLayouter, boolean addAsJustReshaped) {
        LeftSideFrameWrapper frameWrapper = (LeftSideFrameWrapper)this.myLeftSide.addFrame(lmFrame, untiedFrameLayouter, maxLeftBracketOffset);
        if (addAsJustReshaped) {
            this.myLeftJustReshaped = frameWrapper;
        }
        return frameWrapper;
    }

    void addRightFrame(LMFrame lmFrame, int maxRightBracketOffset, boolean addAsJustReshaped, LeftSideFrameWrapper leftSideOnTheSameLifeline) {
        RightSideFrameWrapper frameWrapper = (RightSideFrameWrapper)this.myRightSide.addFrame(lmFrame, null, maxRightBracketOffset);
        frameWrapper.setLeftSideWrapperOnTheSameLifeline(leftSideOnTheSameLifeline);
        if (addAsJustReshaped) {
            this.myRightJustReshaped = frameWrapper;
        }
    }

    static boolean isJustCreated(LMFrame frame) {
        View reference = frame.getGdeNode().getReference();
        if (!(reference instanceof Node)) {
            return false;
        }
        LayoutConstraint notationConstraint = ((Node)reference).getLayoutConstraint();
        if (notationConstraint == null) {
            return true;
        }
        if (notationConstraint instanceof Size) {
            return !((Size)notationConstraint).eIsSet((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
        }
        return false;
    }

    private static abstract class FrameWrapper {
        private FrameWrapper myParent;
        private final ArrayList myChildren;
        protected final LMFrame myLMFrame;
        private final UntiedFrameHorizontalLayouter myUntiedFrameLayouter;
        private final int myFrameInnerAdditionalSpace;
        protected int myInnerElementsMinimalOffset;
        private int myPreferredOffset;

        FrameWrapper(LMFrame frame, int offset, UntiedFrameHorizontalLayouter untiedFrameLayouter, ArrayList children) {
            this.myLMFrame = frame;
            this.myInnerElementsMinimalOffset = offset;
            this.myUntiedFrameLayouter = untiedFrameLayouter;
            int innerSpace = this.myLMFrame.getInnerHorizontalPadding();
            if (this.myUntiedFrameLayouter != null) {
                innerSpace += this.myUntiedFrameLayouter.getWidth() + 10;
            }
            this.myFrameInnerAdditionalSpace = innerSpace;
            this.myPreferredOffset = this.myInnerElementsMinimalOffset + this.myFrameInnerAdditionalSpace;
            this.myChildren = children;
            int i = 0;
            while (i < children.size()) {
                ((FrameWrapper)children.get(i)).setParent(this);
                ++i;
            }
        }

        LMFrame getLMFrame() {
            return this.myLMFrame;
        }

        int getMinOuterOffset() {
            return this.myInnerElementsMinimalOffset + this.myFrameInnerAdditionalSpace + this.getOuterAdditionalSpace();
        }

        int getPreferredOffset() {
            return this.myPreferredOffset;
        }

        int getPreferredOuterOffset() {
            return this.myPreferredOffset + this.getOuterAdditionalSpace();
        }

        private int getOuterAdditionalSpace() {
            return this.myLMFrame.getOuterHorizontalPadding();
        }

        UntiedFrameHorizontalLayouter getUntiedFrameLayouter() {
            return this.myUntiedFrameLayouter;
        }

        void setLifelinePos(int lifelinePos, boolean considerCurrentPos) {
            this.recalculatePreferredOffset(lifelinePos, considerCurrentPos);
        }

        void revalidateOffsetsAfterReshape(int lifelinePos) {
            this.recalculatePreferredOffset(lifelinePos, false);
        }

        private void recalculatePreferredOffset(int lifelinePos, boolean considerCurrentOffset) {
            this.myInnerElementsMinimalOffset = this.recalculateMinInnerOffset(lifelinePos);
            int minPreferredOffset = this.recalculateMinPreferredOffset(lifelinePos);
            this.myPreferredOffset = Math.max(this.myPreferredOffset, minPreferredOffset);
            if (considerCurrentOffset) {
                int currentOffset = this.getCurrentOffset(lifelinePos);
                this.myPreferredOffset = Math.max(this.myPreferredOffset, currentOffset);
            }
            if (this.myParent != null) {
                this.myParent.recalculatePreferredOffset(lifelinePos, considerCurrentOffset);
            }
        }

        int getCurrentOffset(int lifelinePos) {
            if (LifeLineDressImpl.isJustCreated(this.myLMFrame)) {
                return 0;
            }
            return this.getPreviousOffset(lifelinePos);
        }

        abstract int getPreviousOffset(int var1);

        int recalculateMinInnerOffset(int lifelinePos) {
            int result = this.myInnerElementsMinimalOffset;
            int i = 0;
            while (i < this.myChildren.size()) {
                FrameWrapper frameWrapper = (FrameWrapper)this.myChildren.get(i);
                result = Math.max(result, frameWrapper.getMinOuterOffset());
                ++i;
            }
            return result;
        }

        int recalculateMinPreferredOffset(int lifelinePos) {
            int offset = this.myInnerElementsMinimalOffset;
            int i = 0;
            while (i < this.myChildren.size()) {
                FrameWrapper frameWrapper = (FrameWrapper)this.myChildren.get(i);
                offset = Math.max(offset, frameWrapper.getPreferredOuterOffset());
                ++i;
            }
            return offset + this.myFrameInnerAdditionalSpace;
        }

        void setOuterOffsetLimit(int maxOffset) {
            this.setOffsetLimit(maxOffset - this.getOuterAdditionalSpace());
        }

        void setOffsetLimit(int maxOffset) {
            if (this.myPreferredOffset > maxOffset) {
                this.myPreferredOffset = maxOffset;
                int innerMaxOffset = maxOffset - this.myFrameInnerAdditionalSpace;
                int i = 0;
                while (i < this.myChildren.size()) {
                    FrameWrapper frameWrapper = (FrameWrapper)this.myChildren.get(i);
                    frameWrapper.setOuterOffsetLimit(innerMaxOffset);
                    ++i;
                }
            }
        }

        private void setParent(FrameWrapper parent) {
            this.myParent = parent;
        }

        String treeToString(String margin) {
            StringBuffer result = new StringBuffer();
            result.append(margin).append(this.toString()).append("\n");
            margin = String.valueOf(margin) + "    ";
            int i = 0;
            while (i < this.myChildren.size()) {
                result.append(((FrameWrapper)this.myChildren.get(i)).treeToString(margin));
                ++i;
            }
            return result.toString();
        }

        public String toString() {
            return "LMFame: " + this.myLMFrame.getGdeNode().getModelEntity().eClass().getName() + "; minInnerOffset = " + this.myInnerElementsMinimalOffset + "; preferredOffset = " + this.myPreferredOffset + "; current bounds = " + this.myLMFrame.getGdeNode().getX() + ", " + this.myLMFrame.getGdeNode().getY() + ", " + this.myLMFrame.getGdeNode().getWidth() + ", " + this.myLMFrame.getGdeNode().getHeight();
        }
    }

    private static class LeftSide
    extends OneSide {
        private LeftSide() {
        }

        FrameWrapper createFrameWrapper(LMFrame frame, int offset, UntiedFrameHorizontalLayouter untiedFrameLayouter, ArrayList children) {
            return new LeftSideFrameWrapper(frame, offset, untiedFrameLayouter, children);
        }

        public String toString() {
            return "<LeftSide: \n" + super.toString() + "\n>";
        }
    }

    static class LeftSideFrameWrapper
    extends FrameWrapper {
        LeftSideFrameWrapper(LMFrame frame, int offset, UntiedFrameHorizontalLayouter untiedFrameLayouter, ArrayList children) {
            super(frame, offset, untiedFrameLayouter, children);
        }

        int recalculateMinInnerOffset(int lifelinePos) {
            return this.myInnerElementsMinimalOffset;
        }

        int getPreviousOffset(int lifelinePos) {
            return lifelinePos - this.myLMFrame.getGdeNode().getX();
        }

        public String toString() {
            return "<LeftSideFrameWrapper: " + super.toString() + ">";
        }
    }

    private static abstract class OneSide {
        private final List myOuterFrameWrappers = new LinkedList();
        private final List myFrameWrappers = new ArrayList();
        private final List myInnerFrameWrappers = new ArrayList();

        private OneSide() {
        }

        FrameWrapper addFrame(LMFrame lmFrame, UntiedFrameHorizontalLayouter untiedFrameLayouter, int offset) {
            ArrayList<FrameWrapper> innerFrames = new ArrayList<FrameWrapper>(this.myOuterFrameWrappers.size());
            Iterator it = this.myOuterFrameWrappers.iterator();
            while (it.hasNext()) {
                FrameWrapper frameWrapper = (FrameWrapper)it.next();
                if (frameWrapper.getLMFrame().getContainer() != lmFrame) continue;
                innerFrames.add(frameWrapper);
                int offset2 = frameWrapper.getMinOuterOffset();
                if (offset2 > offset) {
                    offset = offset2;
                }
                it.remove();
            }
            FrameWrapper frameWrapper = this.createFrameWrapper(lmFrame, offset, untiedFrameLayouter, innerFrames);
            if (innerFrames.isEmpty()) {
                this.myInnerFrameWrappers.add(frameWrapper);
            }
            this.myOuterFrameWrappers.add(frameWrapper);
            this.myFrameWrappers.add(frameWrapper);
            return frameWrapper;
        }

        abstract FrameWrapper createFrameWrapper(LMFrame var1, int var2, UntiedFrameHorizontalLayouter var3, ArrayList var4);

        void setLifelinePos(int lifelinePos, boolean considerCurrentPos) {
            int i = 0;
            while (i < this.myInnerFrameWrappers.size()) {
                FrameWrapper frameWrapper = (FrameWrapper)this.myInnerFrameWrappers.get(i);
                frameWrapper.setLifelinePos(lifelinePos, considerCurrentPos);
                ++i;
            }
        }

        void revalidateOffsets(int lifelinePos) {
            int i = 0;
            while (i < this.myInnerFrameWrappers.size()) {
                FrameWrapper frameWrapper = (FrameWrapper)this.myInnerFrameWrappers.get(i);
                frameWrapper.revalidateOffsetsAfterReshape(lifelinePos);
                ++i;
            }
        }

        void setOuterOffsetLimit(int externalPos) {
            for (FrameWrapper frameWrapper : this.myOuterFrameWrappers) {
                frameWrapper.setOuterOffsetLimit(externalPos);
            }
        }

        void layout(PositionSetter positionSetter) {
            int i = this.myFrameWrappers.size() - 1;
            while (i >= 0) {
                FrameWrapper frameWrapper = (FrameWrapper)this.myFrameWrappers.get(i);
                positionSetter.setFrameBorderPosition(frameWrapper.getLMFrame(), frameWrapper.getPreferredOffset());
                UntiedFrameHorizontalLayouter untiedFrameLayouter = frameWrapper.getUntiedFrameLayouter();
                if (untiedFrameLayouter != null) {
                    positionSetter.setUntiedFramePosition(untiedFrameLayouter, frameWrapper.getPreferredOffset() - 5);
                }
                --i;
            }
        }

        int getMinOffsetWidth() {
            int offset = 0;
            for (FrameWrapper frameWrapper : this.myOuterFrameWrappers) {
                int offset2 = frameWrapper.getMinOuterOffset();
                if (offset2 <= offset) continue;
                offset = offset2;
            }
            return offset;
        }

        int getOuterOffsetWidth() {
            int offset = 0;
            for (FrameWrapper frameWrapper : this.myOuterFrameWrappers) {
                int offset2 = frameWrapper.getPreferredOuterOffset();
                if (offset2 <= offset) continue;
                offset = offset2;
            }
            return offset;
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            for (FrameWrapper next : this.myOuterFrameWrappers) {
                result.append(next.treeToString(""));
            }
            return result.toString();
        }
    }

    private static abstract class PositionSetter {
        private PositionSetter() {
        }

        abstract void setFrameBorderPosition(LMFrame var1, int var2);

        abstract void setUntiedFramePosition(UntiedFrameHorizontalLayouter var1, int var2);
    }

    private static class RightSide
    extends OneSide {
        private RightSide() {
        }

        FrameWrapper createFrameWrapper(LMFrame frame, int offset, UntiedFrameHorizontalLayouter untiedFrameLayouter, ArrayList children) {
            return new RightSideFrameWrapper(frame, offset, untiedFrameLayouter, children);
        }

        public String toString() {
            return "<RightSide: \n" + super.toString() + "\n>";
        }
    }

    static class RightSideFrameWrapper
    extends FrameWrapper {
        private LeftSideFrameWrapper myLeftSideWrapperOnTheSameLifeline;

        RightSideFrameWrapper(LMFrame frame, int offset, UntiedFrameHorizontalLayouter untiedFrameLayouter, ArrayList children) {
            super(frame, offset, untiedFrameLayouter, children);
        }

        int getPreviousOffset(int lifelinePos) {
            int frameRightPos = this.myLMFrame.getGdeNode().getX() + this.myLMFrame.getGdeNode().getWidth();
            return frameRightPos - lifelinePos;
        }

        protected int recalculateMinInnerOffset(int lifelinePos) {
            int result = super.recalculateMinInnerOffset(lifelinePos);
            return this.stretchToPentagon(result, lifelinePos);
        }

        protected int recalculateMinPreferredOffset(int lifelinePos) {
            int result = super.recalculateMinPreferredOffset(lifelinePos);
            return this.stretchToPentagon(result, lifelinePos);
        }

        private int stretchToPentagon(int currentOffset, int lifelinePos) {
            if (this.myLMFrame instanceof LMVisibleFrameWithPentagon) {
                int minOffset;
                int pentagonWidth = ((LMVisibleFrameWithPentagon)this.myLMFrame).getMinimumWidth();
                if (this.myLeftSideWrapperOnTheSameLifeline == null) {
                    int minPos = this.myLMFrame.getGdeNode().getX() + pentagonWidth;
                    minOffset = minPos - lifelinePos;
                } else {
                    minOffset = pentagonWidth - this.myLeftSideWrapperOnTheSameLifeline.getPreferredOffset();
                }
                return Math.max(currentOffset, minOffset += 5);
            }
            return currentOffset;
        }

        public String toString() {
            return "<RightSideFrameWrapper: " + super.toString() + ">";
        }

        void setLeftSideWrapperOnTheSameLifeline(LeftSideFrameWrapper leftSideWrapperOnTheSameLifeline) {
            this.myLeftSideWrapperOnTheSameLifeline = leftSideWrapperOnTheSameLifeline;
        }
    }
}

