/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.part;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.uml2.diagram.common.part.UMLModelWizardInitialObjectCreationPage;
import org.eclipse.uml2.diagram.sequence.part.Messages;
import org.eclipse.uml2.diagram.sequence.part.UMLCreationWizardPage;
import org.eclipse.uml2.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.diagram.sequence.part.UMLDiagramEditorUtil;

public class UMLCreationWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    protected IStructuredSelection selection;
    protected UMLCreationWizardPage diagramModelFilePage;
    protected UMLCreationWizardPage domainModelFilePage;
    private UMLModelWizardInitialObjectCreationPage initialObjectCreationPage;
    protected Resource diagram;
    private boolean openNewlyCreatedDiagramEditor = true;

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public final Resource getDiagram() {
        return this.diagram;
    }

    public final boolean isOpenNewlyCreatedDiagramEditor() {
        return this.openNewlyCreatedDiagramEditor;
    }

    public void setOpenNewlyCreatedDiagramEditor(boolean openNewlyCreatedDiagramEditor) {
        this.openNewlyCreatedDiagramEditor = openNewlyCreatedDiagramEditor;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(Messages.UMLCreationWizardTitle);
        this.setDefaultPageImageDescriptor(UMLDiagramEditorPlugin.getBundledImageDescriptor("icons/wizban/NewUMLWizard.gif"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.diagramModelFilePage = new UMLCreationWizardPage("DiagramModelFile", this.getSelection(), "umlseq");
        this.diagramModelFilePage.setTitle(Messages.UMLCreationWizard_DiagramModelFilePageTitle);
        this.diagramModelFilePage.setDescription(Messages.UMLCreationWizard_DiagramModelFilePageDescription);
        this.addPage((IWizardPage)this.diagramModelFilePage);
        this.domainModelFilePage = new UMLCreationWizardPage("DomainModelFile", this.getSelection(), "uml");
        this.domainModelFilePage.setTitle(Messages.UMLCreationWizard_DomainModelFilePageTitle);
        this.domainModelFilePage.setDescription(Messages.UMLCreationWizard_DomainModelFilePageDescription);
        this.addPage((IWizardPage)this.domainModelFilePage);
    }

    public boolean performFinish() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(null){

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                UMLCreationWizard.this.diagram = UMLDiagramEditorUtil.createDiagram(UMLCreationWizard.this.diagramModelFilePage.getURI(), UMLCreationWizard.this.domainModelFilePage.getURI(), monitor);
                if (UMLCreationWizard.this.isOpenNewlyCreatedDiagramEditor() && UMLCreationWizard.this.diagram != null) {
                    try {
                        UMLDiagramEditorUtil.openDiagram(UMLCreationWizard.this.diagram);
                    }
                    catch (PartInitException e) {
                        ErrorDialog.openError((Shell)UMLCreationWizard.this.getContainer().getShell(), (String)Messages.UMLCreationWizardOpenEditorError, null, (IStatus)e.getStatus());
                    }
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.UMLCreationWizardCreationError, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                UMLDiagramEditorPlugin.getInstance().logError("Error creating diagram", e.getTargetException());
            }
            return false;
        }
        return this.diagram != null;
    }
}

