/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.am3.tools.tge.outline;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.am3.tools.tge.outline.Position;
import org.eclipse.emf.ecore.EObject;

public class OutlineNode {
    protected EObject object;
    protected String name;
    protected LinkedList label;
    protected String icon;
    protected int line;
    protected List children;
    protected OutlineNode parent;
    protected Position begin;
    protected Position end;

    public EObject getObject() {
        return this.object;
    }

    public OutlineNode(String name) {
        this.name = name;
        this.label = new LinkedList();
        this.parent = null;
        this.children = new ArrayList();
        this.begin = new Position();
        this.end = new Position();
    }

    public OutlineNode(String name, String icon) {
        this.name = name;
        this.label = new LinkedList();
        this.icon = icon;
        this.parent = null;
        this.children = new ArrayList();
        this.begin = new Position();
        this.end = new Position();
    }

    public OutlineNode(LinkedList label, String icon) {
        this.label = label;
        this.icon = icon;
        this.parent = null;
        this.begin = new Position();
        this.end = new Position();
        this.children = new ArrayList();
    }

    private OutlineNode(EObject object, String name, LinkedList label, String icon, Position begin, Position end) {
        this.object = object;
        this.name = name;
        this.label = label;
        this.icon = icon;
        this.begin = begin;
        this.end = end;
        this.parent = null;
        this.children = new ArrayList();
    }

    public String getName() {
        return this.name;
    }

    public String getIcon() {
        return this.icon;
    }

    public void addChild(OutlineNode child) {
        child.setParent(this);
        this.children.add(child);
    }

    public OutlineNode getParent() {
        return this.parent;
    }

    public void setParent(OutlineNode parent) {
        this.parent = parent;
    }

    public List getChildren() {
        return this.children;
    }

    public Object[] getArrayChild() {
        return this.children.toArray();
    }

    public Position getBegin() {
        return this.begin;
    }

    public int getLength() {
        if (this.end != null && this.begin != null) {
            return this.end.getOffset() - this.begin.getOffset();
        }
        return -1;
    }

    public LinkedList getLabel() {
        return this.label;
    }

    public OutlineNode getCopy(EObject object, String name, Position begin, Position end) {
        return new OutlineNode(object, name, this.label, this.icon, begin, end);
    }

    private int inside(int offset) {
        if (this.end != null && this.begin != null) {
            if (this.begin.getOffset() <= offset && this.end.getOffset() >= offset) {
                return offset - this.begin.getOffset();
            }
            return -1;
        }
        return -1;
    }

    public Object[] findPositionNode(int offset) {
        int pos = this.inside(offset);
        Object[] result = pos != -1 ? new Object[]{this, new Integer(pos)} : (Object[])null;
        int i = 0;
        while (i < this.children.size()) {
            Object[] tmp = ((OutlineNode)this.children.get(i)).findPositionNode(offset);
            if (result == null || tmp != null && this.isBestNode((Integer)tmp[1], (Integer)result[1])) {
                result = tmp;
            }
            ++i;
        }
        return result;
    }

    private boolean isBestNode(Integer a, Integer b) {
        return a <= b;
    }

    public OutlineNode findPosition(int offset) {
        try {
            Object[] res = this.findPositionNode(offset);
            if (res != null) {
                return (OutlineNode)res[0];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

