/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.viewsupport;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.m2m.atl.adt.ui.AtlUIPlugin;
import org.eclipse.m2m.atl.adt.ui.viewsupport.IProblemChangedListener;
import org.eclipse.swt.graphics.Image;

public class ProblemsLabelDecorator
implements ILabelDecorator,
ILightweightLabelDecorator {
    protected static Logger logger = Logger.getLogger("org.eclipse.m2m.atl");
    private ListenerList labelProviderListeners = new ListenerList();
    private IProblemChangedListener problemChangedListener;
    private Map imageCache = new HashMap();
    private static final String ERROR_OV = "error_co.gif";
    private static final String WARNING_OV = "warning_co_gif";

    public Image decorateImage(Image image, Object element) {
        IResource res = (IResource)element;
        if (!res.isAccessible()) {
            return null;
        }
        int flag = this.computeHighestServityFlag(res);
        ImageDescriptor imgDesc = null;
        switch (flag) {
            case 2: {
                imgDesc = AtlUIPlugin.getImageDescriptor(ERROR_OV);
                break;
            }
            case 1: {
                imgDesc = AtlUIPlugin.getImageDescriptor(WARNING_OV);
            }
        }
        if (imgDesc == null) {
            return null;
        }
        Image img = (Image)this.imageCache.get(imgDesc);
        if (img == null) {
            img = imgDesc.createImage();
            this.imageCache.put(imgDesc, img);
        }
        return img;
    }

    private int computeHighestServityFlag(IResource res) {
        IMarker[] pbmMarkers = null;
        try {
            pbmMarkers = res.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        }
        catch (CoreException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        int severity = -1;
        if (pbmMarkers != null) {
            int i = 0;
            while (i < pbmMarkers.length) {
                IMarker curr = pbmMarkers[i];
                severity = curr.getAttribute("severity", -1);
                if (severity == 2) {
                    return 2;
                }
                ++i;
            }
        }
        return severity;
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    public void addListener(ILabelProviderListener listener) {
        this.labelProviderListeners.add((Object)listener);
        if (this.problemChangedListener == null) {
            this.problemChangedListener = new IProblemChangedListener(){

                public void problemsChanged(IResource[] changedResources, boolean isMarkerChange) {
                    ProblemsLabelDecorator.this.fireProblemsChanged(changedResources, isMarkerChange);
                }
            };
            AtlUIPlugin.getDefault().getProblemMarkerManager().addListener(this.problemChangedListener);
        }
    }

    public void dispose() {
        if (this.problemChangedListener != null) {
            AtlUIPlugin.getDefault().getProblemMarkerManager().removeListener(this.problemChangedListener);
            this.problemChangedListener = null;
        }
        Iterator images = this.imageCache.values().iterator();
        while (images.hasNext()) {
            ((Image)images.next()).dispose();
        }
        this.imageCache.clear();
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    private void fireProblemsChanged(IResource[] changedResources, boolean isMarkerChange) {
        if (this.labelProviderListeners != null && !this.labelProviderListeners.isEmpty()) {
            ProblemsLabelChangedEvent event = new ProblemsLabelChangedEvent((IBaseLabelProvider)this, changedResources, isMarkerChange);
            Object[] listeners = this.labelProviderListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ILabelProviderListener)listeners[i]).labelProviderChanged((LabelProviderChangedEvent)event);
                ++i;
            }
        }
    }

    public void removeListener(ILabelProviderListener listener) {
        this.labelProviderListeners.remove((Object)listener);
    }

    public void decorate(Object element, IDecoration decoration) {
        IResource res = (IResource)element;
        if (!res.isAccessible()) {
            return;
        }
        int flag = this.computeHighestServityFlag(res);
        switch (flag) {
            case 2: {
                decoration.addOverlay(AtlUIPlugin.getImageDescriptor(ERROR_OV));
                break;
            }
            case 1: {
                decoration.addOverlay(AtlUIPlugin.getImageDescriptor(WARNING_OV));
            }
        }
    }

    public static class ProblemsLabelChangedEvent
    extends LabelProviderChangedEvent {
        private static final long serialVersionUID = 1L;
        private boolean fMarkerChange;

        public ProblemsLabelChangedEvent(IBaseLabelProvider source, IResource[] changedResource, boolean isMarkerChange) {
            super(source, (Object[])changedResource);
            this.fMarkerChange = isMarkerChange;
        }

        public boolean isMarkerChange() {
            return this.fMarkerChange;
        }
    }
}

