/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm.nativelib;

import org.eclipse.m2m.atl.engine.vm.StackFrame;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMBoolean;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMNumber;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclSimpleType;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclType;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMReal;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;

public class ASMInteger
extends ASMNumber {
    public static ASMOclType myType = new ASMOclSimpleType("Integer", ASMReal.myType);
    private int s;

    public ASMInteger(int s) {
        super(myType);
        this.s = s;
    }

    public String toString() {
        return "" + this.s;
    }

    public int getSymbol() {
        return this.s;
    }

    public double asDouble() {
        return this.s;
    }

    public boolean equals(Object o) {
        return o instanceof ASMInteger && ((ASMInteger)o).s == this.s;
    }

    public int hashCode() {
        return this.s;
    }

    public static ASMInteger abs(StackFrame frame, ASMInteger self) {
        return new ASMInteger(self.s < 0 ? -self.s : self.s);
    }

    public static ASMInteger mod(StackFrame frame, ASMInteger self, ASMInteger o) {
        return new ASMInteger(self.s % o.s);
    }

    public static ASMInteger div(StackFrame frame, ASMInteger self, ASMInteger o) {
        return new ASMInteger(self.s / o.s);
    }

    public static ASMInteger max(StackFrame frame, ASMInteger self, ASMInteger o) {
        return new ASMInteger(Math.max(self.s, o.s));
    }

    public static ASMInteger min(StackFrame frame, ASMInteger self, ASMInteger o) {
        return new ASMInteger(Math.max(self.s, o.s));
    }

    public static ASMNumber operatorMinus(StackFrame frame, ASMInteger self, ASMNumber o) {
        if (o instanceof ASMInteger) {
            return new ASMInteger(self.s - ((ASMInteger)o).s);
        }
        return new ASMReal((double)self.s - o.asDouble());
    }

    public static ASMNumber operatorPlus(StackFrame frame, ASMInteger self, ASMNumber o) {
        if (o instanceof ASMInteger) {
            return new ASMInteger(self.s + ((ASMInteger)o).s);
        }
        return new ASMReal((double)self.s + o.asDouble());
    }

    public static ASMNumber operatorMul(StackFrame frame, ASMInteger self, ASMNumber o) {
        if (o instanceof ASMInteger) {
            return new ASMInteger(self.s * ((ASMInteger)o).s);
        }
        return new ASMReal((double)self.s * o.asDouble());
    }

    public static ASMReal operatorDiv(StackFrame frame, ASMInteger self, ASMNumber o) {
        return new ASMReal((double)self.s / o.asDouble());
    }

    public static ASMBoolean operatorEQ(StackFrame frame, ASMInteger self, ASMOclAny o) {
        if (o instanceof ASMInteger) {
            return new ASMBoolean(self.s == ((ASMInteger)o).s);
        }
        if (o instanceof ASMNumber) {
            return new ASMBoolean((double)self.s == ((ASMNumber)o).asDouble());
        }
        return new ASMBoolean(false);
    }

    public static ASMBoolean operatorNE(StackFrame frame, ASMInteger self, ASMOclAny o) {
        if (o instanceof ASMInteger) {
            return new ASMBoolean(self.s != ((ASMInteger)o).s);
        }
        if (o instanceof ASMNumber) {
            return new ASMBoolean((double)self.s != ((ASMNumber)o).asDouble());
        }
        return new ASMBoolean(true);
    }

    public static ASMBoolean operatorLT(StackFrame frame, ASMInteger self, ASMNumber o) {
        if (o instanceof ASMInteger) {
            return new ASMBoolean(self.s < ((ASMInteger)o).s);
        }
        return new ASMBoolean((double)self.s < o.asDouble());
    }

    public static ASMBoolean operatorLE(StackFrame frame, ASMInteger self, ASMNumber o) {
        if (o instanceof ASMInteger) {
            return new ASMBoolean(self.s <= ((ASMInteger)o).s);
        }
        return new ASMBoolean((double)self.s <= o.asDouble());
    }

    public static ASMBoolean operatorGT(StackFrame frame, ASMInteger self, ASMNumber o) {
        if (o instanceof ASMInteger) {
            return new ASMBoolean(self.s > ((ASMInteger)o).s);
        }
        return new ASMBoolean((double)self.s > o.asDouble());
    }

    public static ASMBoolean operatorGE(StackFrame frame, ASMInteger self, ASMNumber o) {
        if (o instanceof ASMInteger) {
            return new ASMBoolean(self.s >= ((ASMInteger)o).s);
        }
        return new ASMBoolean((double)self.s >= o.asDouble());
    }

    public static ASMString toString(StackFrame frame, ASMInteger self) {
        return new ASMString("" + self.s);
    }

    public static ASMString toHexString(StackFrame frame, ASMInteger self) {
        return new ASMString(Integer.toHexString(self.s));
    }

    public static ASMString toBinaryString(StackFrame frame, ASMInteger self) {
        return new ASMString(Integer.toBinaryString(self.s));
    }
}

