/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.drivers.emf4atl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.drivers.emf4atl.ASMEMFModel;
import org.eclipse.m2m.atl.engine.vm.ASMExecEnv;
import org.eclipse.m2m.atl.engine.vm.ClassNativeOperation;
import org.eclipse.m2m.atl.engine.vm.Operation;
import org.eclipse.m2m.atl.engine.vm.StackFrame;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMBag;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMBoolean;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMCollection;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMEnumLiteral;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMInteger;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModelElement;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclType;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclUndefined;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOrderedSet;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMReal;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMSequence;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMSet;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMTuple;

public class ASMEMFModelElement
extends ASMModelElement {
    private static WeakHashMap methodCache = new WeakHashMap();
    private static int instanceCount;
    protected EObject object;

    static {
        try {
            ASMEMFModel.getMOF().findModelElement("EClass");
            ASMEMFModelElement.registerMOFOperation("EClass", "allInstances", new Class[0]);
            ASMEMFModelElement.registerMOFOperation("EClass", "allInstancesFrom", new Class[]{ASMString.class});
            ASMEMFModelElement.registerMOFOperation("EClassifier", "newInstance", new Class[0]);
            ASMEMFModelElement.registerMOFOperation("EClassifier", "newInstanceIn", new Class[]{ASMString.class});
            ASMEMFModelElement.registerMOFOperation("EClassifier", "getInstanceById", new Class[]{ASMString.class, ASMString.class});
        }
        catch (Exception e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected ASMEMFModelElement(Map modelElements, ASMModel model, EObject object) {
        super(model, ASMEMFModelElement.getMetaobject(model, object));
        this.object = object;
        modelElements.put(object, this);
        EStructuralFeature sfName = object.eClass().getEStructuralFeature("name");
        if (sfName != null) {
            String name = null;
            try {
                name = (String)object.eGet(sfName);
                if (name == null) {
                    name = "<notnamedyet>";
                }
            }
            catch (Exception exception) {
                name = "<nonstringname>";
            }
            this.setName(name);
        } else {
            this.setName("<unnamed>");
        }
        if (this.getMetaobject() == null) {
            this.setMetaobject(this);
        }
        this.setType((ASMOclType)this.getMetaobject());
        if (object instanceof EClass) {
            this.addSupertype(ASMOclType.myType);
            EClass cl = (EClass)object;
            for (EClass s : cl.getESuperTypes()) {
                this.addSupertype((ASMOclType)((ASMEMFModel)model).getASMModelElement((EObject)s));
            }
        }
        ATLLogger.fine((String)((Object)((Object)this) + " created (" + ++instanceCount + ")"));
    }

    public ASMBoolean conformsTo(ASMOclType other) {
        boolean ret = false;
        if (other instanceof ASMEMFModelElement) {
            EObject o = ((ASMEMFModelElement)other).object;
            EObject t = this.object;
            if (o instanceof EClass && t instanceof EClass) {
                try {
                    ret = o.equals(t) || ((EClass)o).isSuperTypeOf((EClass)t);
                }
                catch (Exception e) {
                    ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        return new ASMBoolean(ret);
    }

    public ASMModelElement getPropertyType(String name) {
        ASMModelElement ret = null;
        ASMModelElement p = this.getProperty(name);
        if (p != null) {
            ret = (ASMModelElement)p.get(null, "eType");
        }
        return ret;
    }

    public ASMModelElement getProperty(String name) {
        ASMModelElement ret = null;
        EObject t = this.object;
        if (t instanceof EClass) {
            try {
                ret = ((ASMEMFModel)this.getModel()).getASMModelElement((EObject)((EClass)t).getEStructuralFeature(name));
            }
            catch (Exception e) {
                ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return ret;
    }

    public ASMOclAny refImmediateComposite() {
        Object ret = null;
        EObject ic = this.object.eContainer();
        ret = ic == null ? super.refImmediateComposite() : ((ASMEMFModel)this.getModel()).getASMModelElement(ic);
        return ret;
    }

    public ASMOclAny get(StackFrame frame, String name) {
        ASMOclAny ret = null;
        if (frame != null && this.isHelper(frame, name)) {
            ret = this.getHelper(frame, name);
        } else if ("__xmiID__".equals(name)) {
            String id = ((XMIResource)((ASMEMFModel)this.getModel()).getExtent()).getURIFragment(this.object);
            ret = this.emf2ASM(frame, id);
        } else {
            EStructuralFeature sf = this.object.eClass().getEStructuralFeature(name);
            if (sf == null) {
                this.error("Feature " + name + " does not exist on " + this.getType(), frame);
            }
            if (sf.equals(EcorePackage.eINSTANCE.getEEnum_ELiterals())) {
                Object value = this.object.eGet(sf);
                Object col = value instanceof List ? new ASMSequence() : (value instanceof Set ? new ASMSet() : new ASMBag());
                Iterator i = ((Collection)value).iterator();
                while (i.hasNext()) {
                    col.add(this.eObjectToASM(frame, (EObject)i.next()));
                }
                ret = col;
            } else {
                ret = this.emf2ASM(frame, this.object.eGet(sf));
            }
        }
        return ret;
    }

    protected Object asm2EMF(StackFrame frame, ASMOclAny value, String propName, EStructuralFeature feature) {
        Object ret = null;
        if (value instanceof ASMString) {
            ret = ((ASMString)value).getSymbol();
            if (feature != null && feature.getEType() instanceof EEnum) {
                ret = ASMEMFModelElement.getEENumLiteral((EEnum)feature.getEType(), ((ASMString)value).getSymbol()).getInstance();
            }
        } else if (value instanceof ASMBoolean) {
            ret = new Boolean(((ASMBoolean)value).getSymbol());
        } else if (value instanceof ASMReal) {
            ret = new Double(((ASMReal)value).getSymbol());
        } else if (value instanceof ASMInteger) {
            String targetType;
            int val = ((ASMInteger)value).getSymbol();
            ret = feature != null ? (Number)((targetType = feature.getEType().getInstanceClassName()).equals("java.lang.Double") || targetType.equals("java.lang.Float") ? (Number)new Double(val) : (Number)new Integer(val)) : (Number)new Integer(val);
        } else if (value instanceof ASMEMFModelElement) {
            ret = ((ASMEMFModelElement)value).object;
        } else if (value instanceof ASMOclUndefined) {
            ret = null;
        } else if (value instanceof ASMEnumLiteral) {
            String name = ((ASMEnumLiteral)value).getName();
            EClassifier type = ((EClass)((ASMEMFModelElement)this.getMetaobject()).object).getEStructuralFeature(propName).getEType();
            ret = ASMEMFModelElement.getEENumLiteral((EEnum)type, name).getInstance();
        } else if (value instanceof ASMTuple) {
            Object f = this.asm2EMF(frame, ((ASMTuple)value).get(frame, "eStructuralFeature"), propName, feature);
            if (f instanceof EStructuralFeature) {
                Object v = this.asm2EMF(frame, ((ASMTuple)value).get(frame, "value"), propName, feature);
                ret = FeatureMapUtil.createEntry((EStructuralFeature)((EStructuralFeature)f), (Object)v);
            } else {
                this.error("Cannot convert " + value + " : " + value.getClass() + " to EMF.", frame);
            }
        } else if (value instanceof ASMCollection) {
            ret = new ArrayList();
            Iterator i = ((ASMCollection)value).iterator();
            while (i.hasNext()) {
                Object v = this.asm2EMF(frame, (ASMOclAny)i.next(), propName, feature);
                if (v == null) continue;
                ((List)ret).add(v);
            }
        } else {
            this.error("Cannot convert " + value + " : " + value.getClass() + " to EMF.", frame);
        }
        return ret;
    }

    protected ASMOclAny emf2ASM(StackFrame frame, Object value) {
        ASMString ret = null;
        if (value instanceof String) {
            ret = new ASMString((String)value);
        } else if (value instanceof Boolean) {
            ret = new ASMBoolean(((Boolean)value).booleanValue());
        } else if (value instanceof Double) {
            ret = new ASMReal(((Double)value).doubleValue());
        } else if (value instanceof Float) {
            ret = new ASMReal(((Float)value).doubleValue());
        } else if (value instanceof Integer) {
            ret = new ASMInteger(((Integer)value).intValue());
        } else if (value instanceof Long) {
            ret = new ASMInteger(((Long)value).intValue());
        } else if (value instanceof Byte) {
            ret = new ASMInteger(((Byte)value).intValue());
        } else if (value instanceof Short) {
            ret = new ASMInteger(((Short)value).intValue());
        } else if (value instanceof Character) {
            ret = new ASMInteger((int)((Character)value).charValue());
        } else if (value instanceof Enumerator) {
            ret = new ASMEnumLiteral(((Enumerator)value).getName());
        } else if (value instanceof FeatureMap.Entry) {
            ret = new ASMTuple();
            ret.set(frame, "eStructuralFeature", this.emf2ASM(frame, ((FeatureMap.Entry)value).getEStructuralFeature()));
            ret.set(frame, "value", this.emf2ASM(frame, ((FeatureMap.Entry)value).getValue()));
        } else if (value instanceof EObject) {
            ret = this.eObjectToASM(frame, (EObject)value);
        } else if (value == null) {
            ret = new ASMOclUndefined();
        } else if (value instanceof Collection) {
            Object col = value instanceof List ? new ASMSequence() : (value instanceof Set ? new ASMSet() : new ASMBag());
            Iterator i = ((Collection)value).iterator();
            while (i.hasNext()) {
                col.add(this.emf2ASM(frame, i.next()));
            }
            ret = col;
        } else {
            this.error("Cannot convert " + value + " : " + value.getClass() + " from EMF.", frame);
        }
        return ret;
    }

    private void error(String msg, StackFrame frame, Exception e) {
        if (frame == null) {
            throw new RuntimeException(msg, e);
        }
        frame.printStackTrace(msg, e);
    }

    private void error(String msg, StackFrame frame) {
        if (frame == null) {
            throw new RuntimeException(msg);
        }
        frame.printStackTrace(msg);
    }

    private ASMOclAny eObjectToASM(StackFrame frame, EObject value) {
        ASMEMFModel model = (ASMEMFModel)this.getModel();
        Resource valueExtent = value.eResource();
        if (model.getExtent().equals(valueExtent)) {
            return model.getASMModelElement(value);
        }
        for (Object m : frame.getModels().values()) {
            if (!(m instanceof ASMEMFModel) || ((Object)((Object)model)).equals(m) || !((ASMEMFModel)((Object)m)).getExtent().equals(valueExtent)) continue;
            return ((ASMEMFModel)((Object)m)).getASMModelElement(value);
        }
        return model.getASMModelElement(value);
    }

    public static EEnumLiteral getEENumLiteral(EEnum eEnum, String id) {
        EEnumLiteral ret = eEnum.getEEnumLiteralByLiteral(id);
        if (ret == null) {
            ret = eEnum.getEEnumLiteral(id);
        }
        return ret;
    }

    public void set(StackFrame frame, String name, ASMOclAny value) {
        block11: {
            Object val;
            EStructuralFeature feature;
            block12: {
                block10: {
                    ASMExecEnv execEnv;
                    super.set(frame, name, value);
                    feature = this.object.eClass().getEStructuralFeature(name);
                    if ("__xmiID__".equals(name)) {
                        Resource r = ((ASMEMFModel)this.getModel()).getExtent();
                        ATLLogger.warning((String)("Manual setting of " + (Object)((Object)this) + ":" + this.getType() + " XMI ID."));
                        ((XMLResource)r).setID(this.object, ((ASMString)value).cString());
                        return;
                    }
                    if (frame != null && (execEnv = (ASMExecEnv)frame.getExecEnv()).isWeavingHelper((ASMOclType)this.getMetaobject(), name)) {
                        execEnv.setHelperValue(frame, (ASMOclAny)this, name, value);
                        return;
                    }
                    if (feature != null) break block10;
                    this.error("Feature " + name + " does not exist on " + this.getType(), frame);
                    break block11;
                }
                if (!feature.isChangeable()) {
                    this.error("Feature " + name + " is not changeable", frame);
                }
                if (!feature.isMany()) break block12;
                EList l = (EList)this.object.eGet(feature);
                if (value instanceof ASMCollection) {
                    for (ASMOclAny sv : (ASMCollection)value) {
                        Object val2;
                        if (this.isNotAssignable(feature, sv) || (val2 = this.asm2EMF(frame, sv, name, feature)) == null) continue;
                        try {
                            l.add(val2);
                            this.checkContainment(feature, val2);
                        }
                        catch (Exception e) {
                            this.error("Cannot set feature " + this.getType() + "." + name + " to value " + val2, frame, e);
                        }
                    }
                } else {
                    Object val3 = this.asm2EMF(frame, value, name, feature);
                    l.add(val3);
                    this.checkContainment(feature, val3);
                }
                break block11;
            }
            if (this.isNotAssignable(feature, value) || (val = this.asm2EMF(frame, value, name, feature)) == null) break block11;
            try {
                this.object.eSet(feature, val);
                this.checkContainment(feature, val);
            }
            catch (Exception e) {
                this.error("Cannot set feature " + this.getType() + "." + name + " to value " + val, frame, e);
            }
        }
    }

    private boolean isNotAssignable(EStructuralFeature feature, ASMOclAny value) {
        if (value instanceof ASMModelElement && ((ASMModelElement)value).getModel() != this.getModel()) {
            if (((ASMEMFModel)this.getModel()).isCheckSameModel()) {
                return true;
            }
            if (feature instanceof EReference) {
                EReference ref = (EReference)feature;
                return ref.isContainer() || ref.isContainment();
            }
        }
        return false;
    }

    private void checkContainment(EStructuralFeature feature, Object val) {
        if (val != null && feature instanceof EReference) {
            ASMEMFModel model;
            EList toplevelElements;
            EReference ref = (EReference)feature;
            if (ref.isContainment()) {
                ASMEMFModel model2 = (ASMEMFModel)this.getModel();
                EList toplevelElements2 = model2.getExtent().getContents();
                if (toplevelElements2.contains(val)) {
                    toplevelElements2.remove(val);
                }
            } else if (ref.isContainer() && (toplevelElements = (model = (ASMEMFModel)this.getModel()).getExtent().getContents()).contains((Object)this.object)) {
                toplevelElements.remove((Object)this.object);
            }
        }
    }

    private static ASMModelElement getMetaobject(ASMModel model, EObject object) {
        ASMModelElement ret = null;
        EClass metaobject = object.eClass();
        if (metaobject != object) {
            ret = ((ASMEMFModel)model.getMetamodel()).getASMModelElement((EObject)metaobject);
        }
        return ret;
    }

    private static void registerMOFOperation(String modelelementName, String methodName, Class[] args) throws Exception {
        ArrayList<Class> realArgs = new ArrayList<Class>(Arrays.asList(args));
        realArgs.add(0, ASMEMFModelElement.class);
        realArgs.add(0, StackFrame.class);
        ClassNativeOperation no = new ClassNativeOperation(ASMEMFModelElement.class.getMethod(methodName, realArgs.toArray(args)));
        ASMModelElement amme = ASMEMFModel.getMOF().findModelElement(modelelementName);
        amme.registerVMOperation((Operation)no);
    }

    public static ASMOclAny getInstanceById(StackFrame frame, ASMEMFModelElement self, ASMString modelName, ASMString id) {
        EObject eo;
        ASMOclUndefined ret = null;
        ASMModel model = (ASMModel)frame.getModels().get(modelName.getSymbol());
        if (model instanceof ASMEMFModel && (eo = ((XMIResource)((ASMEMFModel)model).getExtent()).getEObject(id.getSymbol())) != null) {
            ret = ((ASMEMFModel)model).getASMModelElement(eo);
        }
        return ret == null ? new ASMOclUndefined() : ret;
    }

    public static ASMOrderedSet allInstances(StackFrame frame, ASMEMFModelElement self) {
        return ASMEMFModelElement.allInstancesFrom(frame, self, null);
    }

    public static ASMOrderedSet allInstancesFrom(StackFrame frame, ASMEMFModelElement self, ASMString sourceModelName) {
        ASMOrderedSet aret = new ASMOrderedSet();
        Collection ret = aret.collection();
        for (String mname : frame.getModels().keySet()) {
            ASMModel am;
            if (sourceModelName != null && !mname.equals(sourceModelName.getSymbol()) || !(am = (ASMModel)frame.getModels().get(mname)).getMetamodel().equals(self.getModel())) continue;
            Set elems = am.getElementsByType((ASMModelElement)self);
            ret.addAll(elems);
        }
        return aret;
    }

    public static ASMModelElement newInstance(StackFrame frame, ASMEMFModelElement self) {
        ASMModelElement ret = null;
        if (self.object.eClass().getName().equals("EClass")) {
            ret = ASMEMFModelElement.createNewInstance((StackFrame)frame, (ASMModelElement)self);
        }
        return ret;
    }

    public static ASMModelElement newInstanceIn(StackFrame frame, ASMEMFModelElement self, ASMString modelName) {
        ASMModelElement ret = null;
        if (self.object.eClass().getName().equals("EClass")) {
            for (ASMModel model : frame.getExecEnv().getModels().values()) {
                if (!model.isTarget() || !model.getName().equals(modelName.cString())) continue;
                return model.newModelElement((ASMModelElement)self);
            }
        }
        return ret;
    }

    protected Method findMethod(Class cls, String name, Class[] argumentTypes) {
        String sig = this.getMethodSignature(name, argumentTypes);
        Method ret = this.findCachedMethod(sig);
        if (ret != null) {
            return ret;
        }
        Method[] methods = cls.getDeclaredMethods();
        int i = 0;
        while (i < methods.length && ret == null) {
            Class<?>[] pts;
            Method method = methods[i];
            if (method.getName().equals(name) && (pts = method.getParameterTypes()).length == argumentTypes.length) {
                boolean ok = true;
                int j = 0;
                while (j < pts.length && ok) {
                    if (!(pts[j].isAssignableFrom(argumentTypes[j]) || pts[j] == Boolean.TYPE && argumentTypes[j] == Boolean.class || pts[j] == Integer.TYPE && argumentTypes[j] == Integer.class || pts[j] == Character.TYPE && argumentTypes[j] == Character.class || pts[j] == Long.TYPE && argumentTypes[j] == Long.class || pts[j] == Float.TYPE && argumentTypes[j] == Float.class || pts[j] == Double.TYPE && argumentTypes[j] == Double.class)) {
                        ok = false;
                    }
                    ++j;
                }
                if (ok) {
                    ret = method;
                }
            }
            ++i;
        }
        if (ret == null && cls.getSuperclass() != null) {
            ret = this.findMethod(cls.getSuperclass(), name, argumentTypes);
        }
        this.cacheMethod(sig, ret);
        return ret;
    }

    private Method findCachedMethod(String signature) {
        Method ret = null;
        Map sigMap = (Map)methodCache.get(this.getMetaobject());
        if (sigMap != null) {
            ret = (Method)sigMap.get(signature);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheMethod(String signature, Method method) {
        ASMModelElement mo = this.getMetaobject();
        WeakHashMap weakHashMap = methodCache;
        synchronized (weakHashMap) {
            HashMap<String, Method> sigMap = (HashMap<String, Method>)methodCache.get(mo);
            if (sigMap == null) {
                sigMap = new HashMap<String, Method>();
                methodCache.put(mo, sigMap);
            }
            sigMap.put(signature, method);
        }
    }

    private String getMethodSignature(String name, Class[] argumentTypes) {
        StringBuffer sig = new StringBuffer();
        sig.append(name);
        sig.append('(');
        int i = 0;
        while (i < argumentTypes.length) {
            if (i > 0) {
                sig.append(',');
            }
            sig.append(argumentTypes[i].getName());
            ++i;
        }
        sig.append(')');
        return sig.toString();
    }

    public ASMOclAny invoke(StackFrame frame, String opName, List arguments) {
        ASMOclAny ret = null;
        Operation oper = this.findOperation(frame, opName, arguments, this.getType());
        if (oper != null) {
            ret = this.invoke(frame, oper, arguments);
        } else {
            Object[] args = new Object[arguments.size()];
            Class[] argumentTypes = new Class[arguments.size()];
            int k = 0;
            Iterator i = arguments.iterator();
            while (i.hasNext()) {
                args[k] = this.asm2EMF(frame, (ASMOclAny)i.next(), null, null);
                argumentTypes[k] = args[k].getClass();
                ++k;
            }
            Method method = this.findMethod(this.object.getClass(), opName, argumentTypes);
            try {
                if (method != null) {
                    ret = this.emf2ASM(frame, method.invoke((Object)this.object, args));
                } else {
                    this.error("Could not find operation " + opName + " on " + this.getType() + " having supertypes: " + this.getType().getSupertypes() + " (including Java operations)", frame);
                }
            }
            catch (IllegalAccessException e) {
                this.error("Could not invoke operation " + opName + " on " + this.getType() + " having supertypes: " + this.getType().getSupertypes() + " (including Java operations)", frame, e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                Exception toReport = cause instanceof Exception ? (Exception)cause : e;
                this.error("Exception during invocation of operation " + opName + " on " + this.getType() + " (java method: " + method + ")", frame, toReport);
            }
        }
        return ret;
    }

    public ASMOclAny invokeSuper(StackFrame frame, String opName, List arguments) {
        ASMOclAny ret = null;
        Operation oper = null;
        Iterator i = this.getType().getSupertypes().iterator();
        while (i.hasNext() && oper == null) {
            oper = this.findOperation(frame, opName, arguments, (ASMOclType)i.next());
        }
        if (oper != null) {
            ret = this.invoke(frame, oper, arguments);
        } else {
            Object[] args = new Object[arguments.size()];
            Class[] argumentTypes = new Class[arguments.size()];
            int k = 0;
            Iterator i2 = arguments.iterator();
            while (i2.hasNext()) {
                args[k] = this.asm2EMF(frame, (ASMOclAny)i2.next(), null, null);
                argumentTypes[k] = args[k].getClass();
                ++k;
            }
            Method method = this.findMethod(this.object.getClass().getSuperclass(), opName, argumentTypes);
            try {
                if (method != null) {
                    ret = this.emf2ASM(frame, method.invoke((Object)this.object, args));
                } else {
                    this.error("Could not find operation " + opName + " on " + this.getType() + " having supertypes: " + this.getType().getSupertypes() + " (including Java operations)", frame);
                }
            }
            catch (IllegalAccessException e) {
                this.error("Could not invoke operation " + opName + " on " + this.getType() + " having supertypes: " + this.getType().getSupertypes() + " (including Java operations)", frame, e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                Exception toReport = cause instanceof Exception ? (Exception)cause : e;
                this.error("Exception during invocation of operation " + opName + " on " + this.getType() + " (java method: " + method + ")", frame, toReport);
            }
        }
        return ret;
    }

    public EObject getObject() {
        return this.object;
    }

    protected void finalize() throws Throwable {
        ATLLogger.fine((String)((Object)((Object)this) + " is being collected (" + --instanceCount + ")"));
        super.finalize();
    }
}

