/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.debug.core.adwp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.m2m.atl.debug.core.adwp.ADWPDebugger;
import org.eclipse.m2m.atl.debug.core.adwp.IntegerValue;
import org.eclipse.m2m.atl.debug.core.adwp.ObjectReference;
import org.eclipse.m2m.atl.debug.core.adwp.StringValue;
import org.eclipse.m2m.atl.debug.core.adwp.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RemoteObjectReference
extends ObjectReference {
    private static Map<List<Object>, ObjectReference> values = new HashMap<List<Object>, ObjectReference>();
    private ADWPDebugger debugger;

    private RemoteObjectReference(ADWPDebugger debugger, int id) {
        super(id);
        this.debugger = debugger;
    }

    @Override
    public Value get(String propName) {
        Value ret = null;
        ret = this.debugger.request(10, Arrays.asList(this, StringValue.valueOf(propName)));
        return ret;
    }

    @Override
    public void set(String propName, Value value) {
        this.debugger.sendCommand(11, Arrays.asList(IntegerValue.valueOf(this.id), StringValue.valueOf(propName), value));
    }

    @Override
    public Value call(String opName, List<Value> args) {
        Value ret = null;
        ArrayList<Value> params = new ArrayList<Value>();
        params.add(this);
        params.add(StringValue.valueOf(opName));
        params.add(IntegerValue.valueOf(args.size()));
        Iterator<Value> i = args.iterator();
        while (i.hasNext()) {
            params.add(i.next());
        }
        ret = this.debugger.request(12, params);
        return ret;
    }

    @Override
    public String toString() {
        return this.call("toString", Collections.<Value>emptyList()).toString();
    }

    public static ObjectReference valueOf(ADWPDebugger debugger, int objectId) {
        Integer id = objectId;
        ArrayList<Object> key = new ArrayList<Object>();
        key.add(id);
        key.add(debugger);
        ObjectReference ret = values.get(key);
        if (ret == null) {
            ret = new RemoteObjectReference(debugger, objectId);
            values.put(key, ret);
        }
        return ret;
    }
}

