/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtp2qvts;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.AbstractNode;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.MergedMappingRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Node;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SimpleNode;

public class MergedNode
extends AbstractNode {
    protected final @NonNull List<@NonNull SimpleNode> simpleNodes = new ArrayList<SimpleNode>();

    public MergedNode(@NonNull MergedMappingRegion mergedRegion, @NonNull Node node) {
        super(node.getNodeRole(), mergedRegion, node.getName(), node.getClassDatumAnalysis());
    }

    public void addNode(@NonNull SimpleNode node) {
        CompleteClass completeClass1 = this.getCompleteClass();
        SimpleNode simpleNode = node;
        CompleteClass completeClass2 = simpleNode.getCompleteClass();
        assert (completeClass1 == completeClass2);
        assert (!this.simpleNodes.contains(simpleNode));
        this.simpleNodes.add(simpleNode);
        this.mergeRole(simpleNode.getNodeRole());
    }

    public @NonNull Iterable<SimpleNode> getNodes() {
        return this.simpleNodes;
    }

    @Override
    public @NonNull Iterable<@NonNull SimpleNode> getSimpleNodes() {
        return this.simpleNodes;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull Iterable<@NonNull TypedElement> getTypedElements() {
        @NonNull @NonNull @NonNull Iterable transform = Iterables.transform(this.simpleNodes, (Function)NodeToTypedElementsFunction.INSTANCE);
        @NonNull @NonNull Iterable concat = Iterables.concat((Iterable)transform);
        return concat;
    }

    public void setRecursion(@NonNull MergedNode recursionNode) {
    }

    private static final class NodeToTypedElementsFunction
    implements Function<Node, Iterable<TypedElement>> {
        public static final @NonNull NodeToTypedElementsFunction INSTANCE = new NodeToTypedElementsFunction();

        private NodeToTypedElementsFunction() {
        }

        public @NonNull Iterable<@NonNull TypedElement> apply(@NonNull Node node) {
            return node.getTypedElements();
        }
    }
}

