/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvtc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionItem;
import org.eclipse.ocl.pivot.CollectionLiteralExp;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.IntegerLiteralExp;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.InvokedRelationToMappingForEnforcement;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.QVTr2QVTc;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.VariablesAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Pattern;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtcore.Mapping;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreHelper;
import org.eclipse.qvtd.pivot.qvtcorebase.Area;
import org.eclipse.qvtd.pivot.qvtcorebase.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcorebase.CorePattern;
import org.eclipse.qvtd.pivot.qvtcorebase.GuardPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtcorebase.VariableAssignment;
import org.eclipse.qvtd.pivot.qvtrelation.DomainPattern;
import org.eclipse.qvtd.pivot.qvtrelation.Key;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationCallExp;
import org.eclipse.qvtd.pivot.qvtrelation.RelationDomain;
import org.eclipse.qvtd.pivot.qvtrelation.RelationalTransformation;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvttemplate.CollectionTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.ObjectTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.PropertyTemplateItem;
import org.eclipse.qvtd.pivot.qvttemplate.TemplateExp;

abstract class AbstractQVTr2QVTcRelations
extends QVTcoreHelper {
    protected final @NonNull QVTr2QVTc qvtr2qvtc;
    protected final @NonNull Relation rRelation;
    protected final @NonNull RelationalTransformation rTransformation;
    protected final @NonNull String rRelationName;
    protected final @NonNull Set<@NonNull Variable> rAllDomainVariables;
    protected final @NonNull Map<@NonNull Variable, @Nullable RelationDomain> rWhenVariable2rDomain;
    protected final @NonNull Map<@NonNull Variable, @Nullable RelationDomain> rWhereVariable2rDomain;
    protected final @NonNull Set<@NonNull Predicate> rWhenPredicates;
    protected final @NonNull Set<@NonNull Predicate> rWherePredicates;
    protected final @NonNull Set<@NonNull Variable> rSharedVariables;
    protected final @NonNull Set<@NonNull Variable> rMiddleBottomDomainVariables;
    protected final @NonNull Transformation cTransformation;

    protected AbstractQVTr2QVTcRelations(@NonNull QVTr2QVTc qvtr2qvtc, @NonNull Relation rRelation) {
        super(qvtr2qvtc.getEnvironmentFactory());
        this.qvtr2qvtc = qvtr2qvtc;
        this.rRelation = rRelation;
        this.rTransformation = (RelationalTransformation)ClassUtil.nonNullState((Object)rRelation.getTransformation());
        this.rRelationName = (String)ClassUtil.nonNullState((Object)rRelation.getName());
        this.rWhenVariable2rDomain = new HashMap<Variable, RelationDomain>();
        this.rWhenPredicates = new HashSet<Predicate>();
        Pattern rWhenPattern = rRelation.getWhen();
        if (rWhenPattern != null) {
            VariablesAnalysis.gatherReferredVariablesWithDomains(this.rWhenVariable2rDomain, (Element)rWhenPattern);
            for (Predicate rWhenPredicate : ClassUtil.nullFree((EList)rWhenPattern.getPredicate())) {
                if (rWhenPredicate.getConditionExpression() instanceof RelationCallExp) continue;
                this.rWhenPredicates.add(rWhenPredicate);
            }
        }
        this.rWhereVariable2rDomain = new HashMap<Variable, RelationDomain>();
        this.rWherePredicates = new HashSet<Predicate>();
        Pattern rWherePattern = rRelation.getWhere();
        if (rWherePattern != null) {
            VariablesAnalysis.gatherReferredVariablesWithDomains(this.rWhereVariable2rDomain, (Element)rWherePattern);
            for (Predicate rWherePredicate : ClassUtil.nullFree((EList)rWherePattern.getPredicate())) {
                if (rWherePredicate.getConditionExpression() instanceof RelationCallExp) continue;
                this.rWherePredicates.add(rWherePredicate);
            }
        }
        this.rAllDomainVariables = new HashSet<Variable>();
        VariablesAnalysis.gatherReferredVariables(this.rAllDomainVariables, (Iterable<? extends Element>)ClassUtil.nullFree((EList)rRelation.getDomain()));
        this.rSharedVariables = VariablesAnalysis.getMiddleDomainVariables(rRelation);
        this.rMiddleBottomDomainVariables = new HashSet<Variable>(this.rWhereVariable2rDomain.keySet());
        this.rMiddleBottomDomainVariables.removeAll(this.rWhenVariable2rDomain.keySet());
        this.rMiddleBottomDomainVariables.removeAll(this.rAllDomainVariables);
        this.rMiddleBottomDomainVariables.addAll(this.rSharedVariables);
        this.cTransformation = qvtr2qvtc.getCoreTransformation(this.rTransformation);
    }

    protected abstract @NonNull List<@NonNull ? extends AbstractEnforceableRelationDomain2CoreMapping> analyze() throws CompilerChainException;

    public void transform() throws CompilerChainException {
        List<@NonNull ? extends AbstractEnforceableRelationDomain2CoreMapping> enforceableRelationDomain2coreMappings = this.analyze();
        for (AbstractEnforceableRelationDomain2CoreMapping abstractEnforceableRelationDomain2CoreMapping : enforceableRelationDomain2coreMappings) {
            abstractEnforceableRelationDomain2CoreMapping.synthesize();
            abstractEnforceableRelationDomain2CoreMapping.variablesAnalysis.check();
        }
    }

    protected abstract class AbstractEnforceableRelationDomain2CoreMapping {
        protected final @NonNull RelationDomain rEnforcedDomain;
        protected final @NonNull TypedModel rEnforcedTypedModel;
        protected final @NonNull String rEnforcedDomainName;
        protected final @NonNull Map<@NonNull Variable, @Nullable TemplateExp> rEnforcedBoundVariables;
        protected final @NonNull Set<@NonNull Variable> rEnforcedReferredVariables;
        protected final @NonNull List<@NonNull TemplateExp> rEnforcedTemplateExpressions;
        protected final @NonNull List<@NonNull Variable> rEnforcedRootVariables;
        protected final @NonNull List<@NonNull AbstractOtherRelationDomain2CoreDomain> otherDomain2coreDomains;
        protected final @NonNull Set<@NonNull Variable> rAllOtherBoundVariables;
        protected final @NonNull Set<@NonNull Variable> rAllOtherReferredVariables;
        protected final @NonNull Mapping cMapping;
        protected final @NonNull GuardPattern cMiddleGuardPattern;
        protected final @NonNull BottomPattern cMiddleBottomPattern;
        protected final @NonNull TypedModel cEnforcedTypedModel;
        protected final @NonNull CoreDomain cEnforcedDomain;
        protected final @NonNull GuardPattern cEnforcedGuardPattern;
        protected final @NonNull BottomPattern cEnforcedBottomPattern;
        protected final @NonNull VariablesAnalysis variablesAnalysis;
        protected final @NonNull RealizedVariable cMiddleRealizedVariable;
        private final @NonNull Map<@NonNull Element, @NonNull List<@NonNull Element>> source2targets = new HashMap<Element, List<Element>>();
        private final @NonNull Map<@NonNull Element, @NonNull Element> target2source = new HashMap<Element, Element>();

        public AbstractEnforceableRelationDomain2CoreMapping(@NonNull RelationDomain rEnforcedDomain, String cMappingName) {
            Variable rVariable;
            VariablesAnalysis.RelationVariableAnalysis variableAnalysis;
            RelationDomain rWhenDomain;
            Variable rWhenVariable;
            this.rEnforcedDomain = rEnforcedDomain;
            this.rEnforcedBoundVariables = new HashMap<Variable, TemplateExp>();
            VariablesAnalysis.gatherBoundVariables(this.rEnforcedBoundVariables, (Element)rEnforcedDomain);
            this.rEnforcedReferredVariables = new HashSet<Variable>();
            VariablesAnalysis.gatherReferredVariables(this.rEnforcedReferredVariables, (Element)rEnforcedDomain);
            this.rEnforcedTemplateExpressions = this.getTemplateExpressions(rEnforcedDomain);
            this.rEnforcedRootVariables = QVTrelationUtil.getRootVariables((RelationDomain)rEnforcedDomain);
            this.rEnforcedTypedModel = (TypedModel)ClassUtil.nonNullState((Object)rEnforcedDomain.getTypedModel());
            this.rEnforcedDomainName = (String)ClassUtil.nonNullState((Object)rEnforcedDomain.getName());
            @NonNull Class traceClass = AbstractQVTr2QVTcRelations.this.qvtr2qvtc.getTraceClass(AbstractQVTr2QVTcRelations.this.rRelation);
            this.cEnforcedTypedModel = this.getCoreTypedModel(this.rEnforcedTypedModel);
            this.cMapping = AbstractQVTr2QVTcRelations.this.qvtr2qvtc.createMapping(AbstractQVTr2QVTcRelations.this.rRelation, cMappingName);
            this.cMiddleGuardPattern = (GuardPattern)ClassUtil.nonNullState((Object)this.cMapping.getGuardPattern());
            this.cMiddleBottomPattern = (BottomPattern)ClassUtil.nonNullState((Object)this.cMapping.getBottomPattern());
            this.cEnforcedDomain = this.createCoreDomain(this.cEnforcedTypedModel, true);
            this.cEnforcedGuardPattern = (GuardPattern)ClassUtil.nonNullState((Object)this.cEnforcedDomain.getGuardPattern());
            this.cEnforcedBottomPattern = (BottomPattern)ClassUtil.nonNullState((Object)this.cEnforcedDomain.getBottomPattern());
            this.variablesAnalysis = new VariablesAnalysis(AbstractQVTr2QVTcRelations.this.qvtr2qvtc, this.cEnforcedDomain, (Type)traceClass, this instanceof InvokedRelationToMappingForEnforcement.InvokedEnforceableRelationDomain2CoreMapping);
            this.cMiddleRealizedVariable = this.variablesAnalysis.getMiddleRealizedVariable();
            this.otherDomain2coreDomains = new ArrayList<AbstractOtherRelationDomain2CoreDomain>();
            this.rAllOtherBoundVariables = new HashSet<Variable>();
            for (Domain rDomain : ClassUtil.nullFree((EList)rEnforcedDomain.getRule().getDomain())) {
                if (rDomain == rEnforcedDomain || !(rDomain instanceof RelationDomain)) continue;
                RelationDomain rRelationDomain = (RelationDomain)rDomain;
                this.otherDomain2coreDomains.add(this.createOtherDomain2CoreDomain(rRelationDomain));
            }
            HashSet<@NonNull Variable> rUnsharedEnforcedDomainVariables = new HashSet<Variable>(this.rEnforcedReferredVariables);
            rUnsharedEnforcedDomainVariables.removeAll(AbstractQVTr2QVTcRelations.this.rSharedVariables);
            this.rAllOtherReferredVariables = new HashSet<Variable>(AbstractQVTr2QVTcRelations.this.rAllDomainVariables);
            this.rAllOtherReferredVariables.removeAll(rUnsharedEnforcedDomainVariables);
            for (Map.Entry<Variable, RelationDomain> entry : AbstractQVTr2QVTcRelations.this.rWhenVariable2rDomain.entrySet()) {
                rWhenVariable = entry.getKey();
                rWhenDomain = entry.getValue();
                variableAnalysis = this.variablesAnalysis.getVariableAnalysis(rWhenVariable);
                if (rWhenDomain == null) continue;
                variableAnalysis.setWhen(this.getCoreDomain(rWhenDomain));
            }
            for (Map.Entry<Variable, RelationDomain> entry : AbstractQVTr2QVTcRelations.this.rWhereVariable2rDomain.entrySet()) {
                RelationDomain rWhereDomain = entry.getValue();
                if (rWhereDomain == null) continue;
                this.variablesAnalysis.getVariableAnalysis(entry.getKey()).setWhere(this.getCoreDomain(rWhereDomain));
            }
            for (Variable rVariable2 : this.rEnforcedBoundVariables.keySet()) {
                Key rKey = AbstractQVTr2QVTcRelations.this.qvtr2qvtc.getKeyForType((Type)ClassUtil.nonNullState((Object)rVariable2.getType()));
                this.variablesAnalysis.getVariableAnalysis(rVariable2).setIsEnforcedBound(this.rEnforcedBoundVariables.get(rVariable2), rKey);
            }
            for (Variable rVariable2 : this.rEnforcedReferredVariables) {
                this.variablesAnalysis.getVariableAnalysis(rVariable2).setIsEnforcedReferred();
            }
            for (Variable rVariable2 : this.rEnforcedRootVariables) {
                this.variablesAnalysis.getVariableAnalysis(rVariable2).setIsRoot();
            }
            block6: for (Map.Entry<Variable, RelationDomain> entry : AbstractQVTr2QVTcRelations.this.rWhenVariable2rDomain.entrySet()) {
                OCLExpression rWhenInit;
                rWhenVariable = entry.getKey();
                rWhenDomain = entry.getValue();
                variableAnalysis = this.variablesAnalysis.getVariableAnalysis(rWhenVariable);
                if (rWhenDomain != null || (rWhenInit = rWhenVariable.getOwnedInit()) == null) continue;
                HashSet<@NonNull Variable> rReferredVariables = new HashSet<Variable>();
                VariablesAnalysis.gatherReferredVariables(rReferredVariables, (Element)rWhenInit);
                for (Variable rReferredVariable : rReferredVariables) {
                    VariablesAnalysis.RelationVariableAnalysis referredVariableAnalysis = this.variablesAnalysis.basicGetVariableAnalysis(rReferredVariable);
                    if (referredVariableAnalysis == null) continue;
                    CorePattern corePattern = referredVariableAnalysis.getCorePattern();
                    variableAnalysis.setPredicate((Area)ClassUtil.nonNullState((Object)corePattern.getArea()));
                    continue block6;
                }
            }
            QVTr2QVTc.VARIABLES.println(" In " + this.cMapping + "\n\t\t" + this.variablesAnalysis.toString().replace("\n", "\n\t\t"));
            for (VariablesAnalysis.RelationVariableAnalysis analysis : this.variablesAnalysis.getAnalyses()) {
                rVariable = analysis.getRelationVariable();
                Variable cVariable = analysis.synthesize();
                this.putTrace((Element)cVariable, (Element)rVariable);
            }
            for (VariablesAnalysis.RelationVariableAnalysis analysis : this.variablesAnalysis.getAnalyses()) {
                rVariable = analysis.getRelationVariable();
                OCLExpression rOwnedInit = rVariable.getOwnedInit();
                if (rOwnedInit == null) continue;
                Variable cVariable = analysis.getCoreVariable();
                cVariable.setOwnedInit(this.mapExpression(rOwnedInit));
            }
        }

        private void addPropertyAssignmentToMiddleBottomPattern(@NonNull Variable rTargetVariable, @NonNull Property targetProperty, @NonNull OCLExpression rExpression) throws CompilerChainException {
            Variable cTargetVariable = null;
            OCLExpression cExpression = null;
            if (rExpression instanceof ObjectTemplateExp) {
                Variable rBoundVariable = (Variable)ClassUtil.nonNullState((Object)((ObjectTemplateExp)rExpression).getBindsTo());
                if (!AbstractQVTr2QVTcRelations.this.rSharedVariables.contains(rBoundVariable)) {
                    Variable cBoundVariable = this.variablesAnalysis.getCoreVariable(rBoundVariable);
                    cTargetVariable = this.variablesAnalysis.getCoreVariable(rTargetVariable);
                    cExpression = AbstractQVTr2QVTcRelations.this.createVariableExp(cBoundVariable);
                }
            } else if (rExpression instanceof VariableExp) {
                cTargetVariable = this.variablesAnalysis.getCoreVariable(rTargetVariable);
                Variable rReferredVariable = (Variable)ClassUtil.nonNullState((Object)((Variable)((VariableExp)rExpression).getReferredVariable()));
                Variable cReferredVariable = this.variablesAnalysis.getCoreVariable(rReferredVariable);
                if (!AbstractQVTr2QVTcRelations.this.rSharedVariables.contains(rReferredVariable) && !this.cEnforcedBottomPattern.getRealizedVariable().contains((Object)cTargetVariable)) {
                    this.cEnforcedBottomPattern.getRealizedVariable().add((Object)((RealizedVariable)cTargetVariable));
                }
                cExpression = AbstractQVTr2QVTcRelations.this.createVariableExp(cReferredVariable);
            } else {
                cTargetVariable = this.variablesAnalysis.getCoreVariable(rTargetVariable);
                cExpression = this.mapExpression(rExpression);
            }
            if (cTargetVariable != null && cExpression != null) {
                this.variablesAnalysis.addNavigationAssignment(rTargetVariable, targetProperty, cExpression);
            }
        }

        private @NonNull CoreDomain createCoreDomain(@NonNull TypedModel cTypedModel, boolean isEnforced) {
            CoreDomain coreDomain = AbstractQVTr2QVTcRelations.this.qvtr2qvtc.createCoreDomain(cTypedModel);
            coreDomain.setIsEnforceable(isEnforced);
            coreDomain.setRule((Rule)this.cMapping);
            return coreDomain;
        }

        protected abstract @NonNull AbstractOtherRelationDomain2CoreDomain createOtherDomain2CoreDomain(@NonNull RelationDomain var1);

        protected @NonNull CoreDomain getCoreDomain(@NonNull RelationDomain rDomain) {
            TypedModel rTypedModel = (TypedModel)ClassUtil.nonNullState((Object)rDomain.getTypedModel());
            TypedModel cTypedModel = this.getCoreTypedModel(rTypedModel);
            for (Domain cDomain : ClassUtil.nullFree((EList)this.cMapping.getDomain())) {
                if (cDomain.getTypedModel() != cTypedModel) continue;
                return (CoreDomain)cDomain;
            }
            throw new IllegalStateException();
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        protected @NonNull TypedModel getCoreTypedModel(@NonNull TypedModel rTypedModel) {
            String name = (String)ClassUtil.nonNullState((Object)rTypedModel.getName());
            @NonNull EList usedPackages = ClassUtil.nullFree((EList)rTypedModel.getUsedPackage());
            for (TypedModel tm : AbstractQVTr2QVTcRelations.this.cTransformation.getModelParameter()) {
                if (!name.equals(tm.getName())) continue;
                assert (tm.getUsedPackage().equals((Object)usedPackages));
                return tm;
            }
            return (TypedModel)ClassUtil.nonNullState(null);
        }

        protected abstract @NonNull Set<@NonNull Variable> getEnforcedBottomDomainVariables();

        protected @NonNull Set<@NonNull RelationDomain> getOtherRelationDomains() {
            HashSet<@NonNull RelationDomain> relationDomains = new HashSet<RelationDomain>();
            for (Domain relationDomain : ClassUtil.nullFree((EList)AbstractQVTr2QVTcRelations.this.rRelation.getDomain())) {
                relationDomains.add((RelationDomain)relationDomain);
            }
            relationDomains.remove(this.rEnforcedDomain);
            return relationDomains;
        }

        protected @NonNull List<@NonNull TemplateExp> getTemplateExpressions(@NonNull RelationDomain rRelationDomain) {
            ArrayList<@NonNull TemplateExp> rTemplateExpressions = new ArrayList<TemplateExp>();
            for (DomainPattern rDomainPattern : ClassUtil.nullFree((EList)rRelationDomain.getPattern())) {
                TemplateExp rTemplateExpression = rDomainPattern.getTemplateExpression();
                assert (rTemplateExpression != null);
                rTemplateExpressions.add(rTemplateExpression);
            }
            return rTemplateExpressions;
        }

        private boolean isVarBoundToSomeOtherTemplate(ObjectTemplateExp rootTe, TemplateExp skipTe, Variable v) {
            if (rootTe == skipTe) {
                return false;
            }
            if (rootTe.getBindsTo().equals(v)) {
                return true;
            }
            boolean exists = false;
            for (PropertyTemplateItem p : rootTe.getPart()) {
                if (!(p.getValue() instanceof ObjectTemplateExp)) continue;
                exists |= this.isVarBoundToSomeOtherTemplate((ObjectTemplateExp)p.getValue(), skipTe, v);
            }
            return exists;
        }

        protected void mapEnforcedCollectionTemplateExpression(@NonNull CollectionTemplateExp rEnforcedCollectionTemplateExp, @Nullable Key key) throws CompilerChainException {
            System.err.println("Missing mapEnforcedCollectionTemplateExpression support");
        }

        protected void mapEnforcedDomainPatterns() throws CompilerChainException {
            for (TemplateExp rEnforcedTemplateExpression : this.rEnforcedTemplateExpressions) {
                this.mapEnforcedTemplateExpression(rEnforcedTemplateExpression);
            }
        }

        protected void mapEnforcedObjectTemplateExpression(@NonNull ObjectTemplateExp rEnforcedObjectTemplateExpression, Key key) throws CompilerChainException {
            Variable rTemplateVariable = (Variable)ClassUtil.nonNullState((Object)rEnforcedObjectTemplateExpression.getBindsTo());
            for (PropertyTemplateItem pt : ClassUtil.nullFree((EList)rEnforcedObjectTemplateExpression.getPart())) {
                Property partProperty = (Property)ClassUtil.nonNullState((Object)pt.getReferredProperty());
                OCLExpression rPartValue = (OCLExpression)ClassUtil.nonNullState((Object)pt.getValue());
                if (key != null && key.getPart().contains((Object)partProperty)) {
                    this.addPropertyAssignmentToMiddleBottomPattern(rTemplateVariable, partProperty, rPartValue);
                    continue;
                }
                if (rPartValue instanceof TemplateExp) {
                    TemplateExp pte = (TemplateExp)rPartValue;
                    Variable pv = (Variable)ClassUtil.nonNullState((Object)pte.getBindsTo());
                    Variable cTargetVariable = this.variablesAnalysis.getCoreVariable(pv);
                    Variable cTemplateVariable = this.variablesAnalysis.getCoreVariable(rTemplateVariable);
                    this.variablesAnalysis.addNavigationAssignment(rTemplateVariable, partProperty, (OCLExpression)AbstractQVTr2QVTcRelations.this.createVariableExp(cTargetVariable));
                    this.mapEnforcedTemplateExpression(pte);
                    continue;
                }
                Variable cTemplateVariable = this.variablesAnalysis.getCoreVariable(rTemplateVariable);
                for (TemplateExp rTemplateExpression : this.rEnforcedTemplateExpressions) {
                    Variable rReferredVariable;
                    if (rPartValue instanceof VariableExp && rTemplateExpression instanceof ObjectTemplateExp && this.isVarBoundToSomeOtherTemplate((ObjectTemplateExp)rTemplateExpression, (TemplateExp)rEnforcedObjectTemplateExpression, rReferredVariable = (Variable)ClassUtil.nonNullState((Object)((VariableExp)rPartValue).getReferredVariable()))) {
                        Variable cReferredVariable = this.variablesAnalysis.getCoreVariable(rReferredVariable);
                        Property cTargetProperty = AbstractQVTr2QVTcRelations.this.qvtr2qvtc.getProperty(cReferredVariable.getType(), (NamedElement)cReferredVariable);
                        NavigationCallExp cPropertyCallExp = AbstractQVTr2QVTcRelations.this.createNavigationCallExp((OCLExpression)AbstractQVTr2QVTcRelations.this.createVariableExp((Variable)this.cMiddleRealizedVariable), cTargetProperty);
                        this.variablesAnalysis.addConditionPredicate((CorePattern)this.cMiddleGuardPattern, (OCLExpression)cPropertyCallExp, (OCLExpression)AbstractQVTr2QVTcRelations.this.createVariableExp(cReferredVariable));
                        this.cEnforcedGuardPattern.getBindsTo().add((Object)cReferredVariable);
                    }
                    this.variablesAnalysis.addNavigationAssignment(rTemplateVariable, partProperty, this.mapExpression(rPartValue));
                }
            }
        }

        private void mapEnforcedTemplateExpression(@NonNull TemplateExp rEnforcedTemplateExpression) throws CompilerChainException {
            Variable rTemplateVariable = (Variable)ClassUtil.nonNullState((Object)rEnforcedTemplateExpression.getBindsTo());
            Type rTemplateVariableType = (Type)ClassUtil.nonNullState((Object)rTemplateVariable.getType());
            Key key = AbstractQVTr2QVTcRelations.this.qvtr2qvtc.getKeyForType(rTemplateVariableType);
            if (rEnforcedTemplateExpression instanceof ObjectTemplateExp) {
                this.mapEnforcedObjectTemplateExpression((ObjectTemplateExp)rEnforcedTemplateExpression, key);
            } else if (rEnforcedTemplateExpression instanceof CollectionTemplateExp) {
                this.mapEnforcedCollectionTemplateExpression((CollectionTemplateExp)rEnforcedTemplateExpression, key);
            } else {
                throw new CompilerChainException("Missing mapEnforcedTemplateExpression support " + rEnforcedTemplateExpression.eClass().getName(), new Object[0]);
            }
            Variable cTemplateVariable = this.variablesAnalysis.getCoreVariable(rTemplateVariable);
            Property cTargetProperty = AbstractQVTr2QVTcRelations.this.qvtr2qvtc.getProperty(this.cMiddleRealizedVariable.getType(), (NamedElement)rTemplateVariable);
            this.variablesAnalysis.addTraceNavigationAssignment(cTargetProperty, (OCLExpression)AbstractQVTr2QVTcRelations.this.createVariableExp(cTemplateVariable));
        }

        protected @NonNull OCLExpression mapExpression(@NonNull OCLExpression rExpression) {
            ExpressionCopier copier = new ExpressionCopier();
            OCLExpression eOut = (OCLExpression)copier.copy((EObject)rExpression);
            copier.copyReferences();
            for (EObject eSource : copier.keySet()) {
                EObject eTarget = (EObject)copier.get(eSource);
                if (eTarget == null) continue;
                assert (eSource != null);
                this.putTrace((Element)eTarget, (Element)eSource);
            }
            assert (eOut != null);
            return eOut;
        }

        protected void mapInvocation() throws CompilerChainException {
        }

        protected void mapOtherDomainPatterns() throws CompilerChainException {
            for (AbstractOtherRelationDomain2CoreDomain otherDomain2coreDomain : this.otherDomain2coreDomains) {
                otherDomain2coreDomain.synthesize();
            }
        }

        protected void mapOtherDomainVariables(@NonNull Set<@NonNull Variable> rDomainVariables) throws CompilerChainException {
            for (Variable rDomainVariable : rDomainVariables) {
                Property cProperty = AbstractQVTr2QVTcRelations.this.qvtr2qvtc.basicGetProperty(this.cMiddleRealizedVariable.getType(), (NamedElement)rDomainVariable);
                if (cProperty == null) continue;
                Variable cVariable = this.variablesAnalysis.getCoreVariable(rDomainVariable);
                this.variablesAnalysis.addTraceNavigationAssignment(cProperty, (OCLExpression)AbstractQVTr2QVTcRelations.this.createVariableExp(cVariable));
            }
        }

        protected void mapRelationImplementation() {
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        protected void mapWhenPattern() throws CompilerChainException {
            Pattern rWhenPattern = AbstractQVTr2QVTcRelations.this.rRelation.getWhen();
            if (rWhenPattern != null) {
                HashSet<@NonNull Variable> rMiddleGuardDomainVariables = new HashSet<Variable>(AbstractQVTr2QVTcRelations.this.rWhenVariable2rDomain.keySet());
                rMiddleGuardDomainVariables.removeAll(AbstractQVTr2QVTcRelations.this.rAllDomainVariables);
                for (Predicate rWhenPredicate : rWhenPattern.getPredicate()) {
                    OCLExpression rConditionExpression = (OCLExpression)ClassUtil.nonNullState((Object)rWhenPredicate.getConditionExpression());
                    if (rConditionExpression instanceof RelationCallExp) {
                        RelationCallExp rInvocation = (RelationCallExp)rConditionExpression;
                        Relation rInvokedRelation = (Relation)ClassUtil.nonNullState((Object)rInvocation.getReferredRelation());
                        Class invokedTraceClass = AbstractQVTr2QVTcRelations.this.qvtr2qvtc.getTraceClass(rInvokedRelation);
                        @NonNull EList rArguments = ClassUtil.nullFree((EList)rInvocation.getArgument());
                        String invokedName = "when_" + invokedTraceClass.getName();
                        Variable cCalledVariable = this.variablesAnalysis.addCoreGuardVariable(invokedName, (Type)invokedTraceClass);
                        List<@NonNull Variable> rParameters = AbstractQVTr2QVTcRelations.this.qvtr2qvtc.getRootVariables(rInvokedRelation);
                        int iSize = rArguments.size();
                        assert (iSize == rParameters.size());
                        int i = 0;
                        while (i < iSize) {
                            VariableExp rArgument = (VariableExp)rArguments.get(i);
                            Variable rParameter = rParameters.get(i);
                            Variable rArgumentVariable = (Variable)ClassUtil.nonNullState((Object)rArgument.getReferredVariable());
                            Variable cArgumentVariable = this.variablesAnalysis.getCoreVariable(rArgumentVariable);
                            Property cCalledProperty = AbstractQVTr2QVTcRelations.this.qvtr2qvtc.getProperty(cCalledVariable.getType(), (NamedElement)rParameter);
                            NavigationCallExp cCalledValue = AbstractQVTr2QVTcRelations.this.createNavigationCallExp((OCLExpression)AbstractQVTr2QVTcRelations.this.createVariableExp(cCalledVariable), cCalledProperty);
                            this.variablesAnalysis.addConditionPredicate((CorePattern)this.cMiddleGuardPattern, (OCLExpression)cCalledValue, (OCLExpression)AbstractQVTr2QVTcRelations.this.createVariableExp(cArgumentVariable));
                            ++i;
                        }
                        continue;
                    }
                    OCLExpression cConditionExpression = this.mapExpression(rConditionExpression);
                    this.variablesAnalysis.addPredicate((CorePattern)this.cMiddleGuardPattern, cConditionExpression);
                }
            }
        }

        protected void mapWhereBottomPredicates(@NonNull Iterable<@NonNull Predicate> rWherePredicates) {
            for (Predicate rWherePredicate : rWherePredicates) {
                OCLExpression rExpression = (OCLExpression)ClassUtil.nonNullState((Object)rWherePredicate.getConditionExpression());
                this.variablesAnalysis.addPredicate((CorePattern)this.cMiddleBottomPattern, this.mapExpression(rExpression));
            }
        }

        protected void mapWhereGuardPredicates(@NonNull Set<@NonNull Predicate> rWhereGuardPredicates, @NonNull Set<@NonNull Variable> rEnforcedBottomDomainVariables) throws CompilerChainException {
            HashSet<@NonNull Variable> nonRootEnforcedBottomDomainVariables = new HashSet<Variable>(rEnforcedBottomDomainVariables);
            nonRootEnforcedBottomDomainVariables.removeAll(this.rEnforcedRootVariables);
            Set<@NonNull Predicate> wherePredicatesWithVarBindings = this.selectPredicatesThatReferToVariables(rWhereGuardPredicates, nonRootEnforcedBottomDomainVariables);
            HashSet<@NonNull Predicate> remainingWherePredicatesWithoutVarBindings = new HashSet<Predicate>(rWhereGuardPredicates);
            remainingWherePredicatesWithoutVarBindings.removeAll(wherePredicatesWithVarBindings);
        }

        private void putTrace(@NonNull Element coreElement, @NonNull Element relationElement) {
            Element oldRelationElement = this.target2source.put(coreElement, relationElement);
            assert (oldRelationElement == null);
            List<@NonNull Element> targets = this.source2targets.get(relationElement);
            if (targets == null) {
                targets = new ArrayList<Element>();
                this.source2targets.put(relationElement, targets);
            }
            targets.add(coreElement);
        }

        protected @NonNull Set<@NonNull Predicate> selectPredicatesThatReferToVariables(@NonNull Set<@NonNull Predicate> rPredicates, @NonNull Set<@NonNull Variable> rVariables) {
            HashSet<@NonNull Predicate> rPredicatesThatReferToVariables = new HashSet<Predicate>();
            for (Predicate rPredicate : rPredicates) {
                HashSet<@NonNull Variable> rPredicateVariables = new HashSet<Variable>();
                VariablesAnalysis.gatherReferredVariables(rPredicateVariables, (Element)rPredicate);
                rPredicateVariables.retainAll(rVariables);
                if (!rPredicateVariables.isEmpty()) continue;
                rPredicatesThatReferToVariables.add(rPredicate);
            }
            return rPredicatesThatReferToVariables;
        }

        protected void synthesize() throws CompilerChainException {
            Set<@NonNull Variable> rEnforcedBottomDomainVariables = this.getEnforcedBottomDomainVariables();
            Set<@NonNull Predicate> rWhereBottomPredicates = this.selectPredicatesThatReferToVariables(AbstractQVTr2QVTcRelations.this.rWherePredicates, rEnforcedBottomDomainVariables);
            HashSet<@NonNull Predicate> rWhereGuardPredicates = new HashSet<Predicate>(AbstractQVTr2QVTcRelations.this.rWherePredicates);
            rWhereGuardPredicates.removeAll(rWhereBottomPredicates);
            this.mapWhereBottomPredicates(rWhereBottomPredicates);
            this.mapOtherDomainPatterns();
            this.mapInvocation();
            this.mapOtherDomainVariables(this.rAllOtherReferredVariables);
            this.mapWhenPattern();
            this.mapWhereGuardPredicates(rWhereGuardPredicates, rEnforcedBottomDomainVariables);
            this.mapEnforcedDomainPatterns();
            this.mapRelationImplementation();
        }

        public @NonNull String toString() {
            return String.valueOf(AbstractQVTr2QVTcRelations.this.rRelationName) + "::" + this.rEnforcedDomainName + " => " + this.cMapping.getName() + "::" + this.cEnforcedDomain.getName();
        }

        protected abstract class AbstractOtherRelationDomain2CoreDomain {
            protected final @NonNull RelationDomain rOtherDomain;
            protected final @NonNull String rOtherDomainName;
            protected final @NonNull TypedModel rOtherTypedModel;
            protected final @NonNull TypedModel cOtherTypedModel;
            protected final @NonNull CoreDomain cOtherDomain;
            protected final @NonNull GuardPattern cOtherGuardPattern;
            protected final @NonNull BottomPattern cOtherBottomPattern;
            protected final @NonNull Map<@NonNull Variable, @Nullable TemplateExp> rOtherBoundVariables;
            protected final @NonNull Set<@NonNull Variable> rOtherReferredVariables;
            protected final @NonNull List<@NonNull Variable> rOtherRootVariables;

            public AbstractOtherRelationDomain2CoreDomain(RelationDomain rOtherDomain) {
                this.rOtherDomain = rOtherDomain;
                this.rOtherDomainName = (String)ClassUtil.nonNullState((Object)rOtherDomain.getName());
                this.rOtherTypedModel = (TypedModel)ClassUtil.nonNullState((Object)rOtherDomain.getTypedModel());
                this.cOtherTypedModel = AbstractEnforceableRelationDomain2CoreMapping.this.getCoreTypedModel(this.rOtherTypedModel);
                this.cOtherDomain = AbstractEnforceableRelationDomain2CoreMapping.this.createCoreDomain(this.cOtherTypedModel, false);
                this.cOtherDomain.setIsCheckable(rOtherDomain.isIsCheckable());
                this.cOtherGuardPattern = (GuardPattern)ClassUtil.nonNullState((Object)this.cOtherDomain.getGuardPattern());
                this.cOtherBottomPattern = (BottomPattern)ClassUtil.nonNullState((Object)this.cOtherDomain.getBottomPattern());
                this.rOtherBoundVariables = new HashMap<Variable, TemplateExp>();
                VariablesAnalysis.gatherBoundVariables(this.rOtherBoundVariables, (Element)rOtherDomain);
                this.rOtherReferredVariables = new HashSet<Variable>();
                VariablesAnalysis.gatherReferredVariables(this.rOtherReferredVariables, (Element)rOtherDomain);
                this.rOtherRootVariables = QVTrelationUtil.getRootVariables((RelationDomain)rOtherDomain);
                for (Variable rVariable : this.rOtherBoundVariables.keySet()) {
                    AbstractEnforceableRelationDomain2CoreMapping.this.variablesAnalysis.getVariableAnalysis(rVariable).setOtherBound(this.cOtherDomain);
                }
                for (Variable rVariable : this.rOtherReferredVariables) {
                    AbstractEnforceableRelationDomain2CoreMapping.this.variablesAnalysis.getVariableAnalysis(rVariable).setOtherReferred(this.cOtherDomain);
                }
                for (Variable rVariable : this.rOtherRootVariables) {
                    AbstractEnforceableRelationDomain2CoreMapping.this.variablesAnalysis.getVariableAnalysis(rVariable).setIsRoot();
                }
            }

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            private void mapOtherCollectionTemplateExpression(@NonNull Variable cTemplateVariable, @NonNull Property partProperty, @NonNull CollectionTemplateExp cte) throws CompilerChainException {
                Variable vcte = (Variable)ClassUtil.nonNullState((Object)cte.getBindsTo());
                Variable mvcte = AbstractEnforceableRelationDomain2CoreMapping.this.variablesAnalysis.getCoreVariable(vcte);
                NavigationCallExp pce = AbstractQVTr2QVTcRelations.this.createNavigationCallExp((OCLExpression)AbstractQVTr2QVTcRelations.this.createVariableExp(cTemplateVariable), partProperty);
                VariableAssignment a = AbstractQVTr2QVTcRelations.this.createVariableAssignment(mvcte, (OCLExpression)pce);
                AbstractEnforceableRelationDomain2CoreMapping.this.cMiddleBottomPattern.getAssignment().add((Object)a);
                HashMap<@NonNull OCLExpression, @NonNull Variable> rMember2mVariable = new HashMap<OCLExpression, Variable>();
                @NonNull EList rMembers = ClassUtil.nullFree((EList)cte.getMember());
                for (OCLExpression rMember : rMembers) {
                    Variable mVariable;
                    if (rMember instanceof TemplateExp) {
                        TemplateExp rTemplateExp = (TemplateExp)rMember;
                        this.mapOtherTemplateExpression(rTemplateExp);
                        Variable rVariable = (Variable)ClassUtil.nonNullState((Object)rTemplateExp.getBindsTo());
                        mVariable = AbstractEnforceableRelationDomain2CoreMapping.this.variablesAnalysis.getCoreVariable(rVariable);
                    } else if (rMember instanceof VariableExp) {
                        Variable rVariable = (Variable)ClassUtil.nonNullState((Object)((Variable)((VariableExp)rMember).getReferredVariable()));
                        mVariable = AbstractEnforceableRelationDomain2CoreMapping.this.variablesAnalysis.getCoreVariable(rVariable);
                    } else {
                        OCLExpression mMember = AbstractEnforceableRelationDomain2CoreMapping.this.mapExpression(rMember);
                        mVariable = AbstractEnforceableRelationDomain2CoreMapping.this.variablesAnalysis.addCoreVariable("member", mMember);
                    }
                    rMember2mVariable.put(rMember, mVariable);
                }
                CollectionType collectionType = (CollectionType)ClassUtil.nonNullState((Object)cte.getReferredCollectionType());
                int size = rMembers.size();
                Variable rRest = cte.getRest();
                if (rRest == null) {
                    ArrayList<@NonNull CollectionItem> mParts = new ArrayList<CollectionItem>();
                    for (OCLExpression rMember : rMembers) {
                        Variable mVariable = (Variable)ClassUtil.nonNullState((Object)((Variable)rMember2mVariable.get(rMember)));
                        CollectionItem mItem = AbstractQVTr2QVTcRelations.this.createCollectionItem((OCLExpression)AbstractQVTr2QVTcRelations.this.createVariableExp(mVariable));
                        mParts.add(mItem);
                    }
                    CollectionLiteralExp cle = AbstractQVTr2QVTcRelations.this.createCollectionLiteralExp(collectionType, mParts);
                    AbstractEnforceableRelationDomain2CoreMapping.this.variablesAnalysis.addConditionPredicate((CorePattern)AbstractEnforceableRelationDomain2CoreMapping.this.cMiddleBottomPattern, (OCLExpression)AbstractQVTr2QVTcRelations.this.createVariableExp(mvcte), (OCLExpression)cle);
                } else {
                    Variable mRest = AbstractEnforceableRelationDomain2CoreMapping.this.variablesAnalysis.getCoreVariable(rRest);
                    if (collectionType.isOrdered()) {
                        VariableExp vRest = AbstractQVTr2QVTcRelations.this.createVariableExp(rRest);
                        String opName = collectionType.isUnique() ? "subOrderedSet" : "subSequence";
                        IntegerLiteralExp eStart = AbstractQVTr2QVTcRelations.this.createIntegerLiteralExp(size);
                        OperationCallExp eFinish = AbstractQVTr2QVTcRelations.this.createOperationCallExp((OCLExpression)AbstractQVTr2QVTcRelations.this.createVariableExp(mvcte), "size", new OCLExpression[0]);
                        OperationCallExp eTail = AbstractQVTr2QVTcRelations.this.createOperationCallExp((OCLExpression)AbstractQVTr2QVTcRelations.this.createVariableExp(mvcte), opName, new OCLExpression[]{vRest, eStart, eFinish});
                        VariableAssignment aRest = AbstractQVTr2QVTcRelations.this.createVariableAssignment(mRest, (OCLExpression)eTail);
                        AbstractEnforceableRelationDomain2CoreMapping.this.cMiddleBottomPattern.getAssignment().add((Object)aRest);
                        int i = 0;
                        while (i < size) {
                            IntegerLiteralExp eIndex = AbstractQVTr2QVTcRelations.this.createIntegerLiteralExp(i + 1);
                            OperationCallExp vElement = AbstractQVTr2QVTcRelations.this.createOperationCallExp((OCLExpression)AbstractQVTr2QVTcRelations.this.createVariableExp(mvcte), "at", new OCLExpression[]{eIndex});
                            OCLExpression rMember = (OCLExpression)rMembers.get(i);
                            Variable mVariable = (Variable)ClassUtil.nonNullState((Object)((Variable)rMember2mVariable.get(rMember)));
                            AbstractEnforceableRelationDomain2CoreMapping.this.variablesAnalysis.addConditionPredicate((CorePattern)AbstractEnforceableRelationDomain2CoreMapping.this.cMiddleBottomPattern, (OCLExpression)AbstractQVTr2QVTcRelations.this.createVariableExp(mVariable), (OCLExpression)vElement);
                            ++i;
                        }
                    } else {
                        VariableExp exclusions = AbstractQVTr2QVTcRelations.this.createVariableExp(mvcte);
                        for (OCLExpression rMember : rMembers) {
                            Variable mVariable = (Variable)ClassUtil.nonNullState((Object)((Variable)rMember2mVariable.get(rMember)));
                            exclusions = AbstractQVTr2QVTcRelations.this.createOperationCallExp((OCLExpression)exclusions, "excluding", new OCLExpression[]{AbstractQVTr2QVTcRelations.this.createVariableExp(mVariable)});
                        }
                        VariableAssignment aRest = AbstractQVTr2QVTcRelations.this.createVariableAssignment(mRest, (OCLExpression)exclusions);
                        AbstractEnforceableRelationDomain2CoreMapping.this.cMiddleBottomPattern.getAssignment().add((Object)aRest);
                        int i = 0;
                        while (i < size) {
                            @NonNull VariableExp eTerm = AbstractQVTr2QVTcRelations.this.createVariableExp(mvcte);
                            int j = 0;
                            while (j < i) {
                                OCLExpression rMember = (OCLExpression)rMembers.get(j);
                                Variable mVariable = (Variable)ClassUtil.nonNullState((Object)((Variable)rMember2mVariable.get(rMember)));
                                eTerm = AbstractQVTr2QVTcRelations.this.createOperationCallExp((OCLExpression)eTerm, "excluding", new OCLExpression[]{AbstractQVTr2QVTcRelations.this.createVariableExp(mVariable)});
                                ++j;
                            }
                            OCLExpression rMember = (OCLExpression)rMembers.get(i);
                            Variable mVariable = (Variable)ClassUtil.nonNullState((Object)((Variable)rMember2mVariable.get(rMember)));
                            eTerm = AbstractQVTr2QVTcRelations.this.createOperationCallExp((OCLExpression)eTerm, "includes", new OCLExpression[]{AbstractQVTr2QVTcRelations.this.createVariableExp(mVariable)});
                            AbstractEnforceableRelationDomain2CoreMapping.this.variablesAnalysis.addPredicate((CorePattern)AbstractEnforceableRelationDomain2CoreMapping.this.cMiddleBottomPattern, (OCLExpression)eTerm);
                            ++i;
                        }
                    }
                }
            }

            private void mapOtherObjectTemplateExpression(@NonNull Variable rTemplateVariable, @NonNull Property partProperty, @NonNull ObjectTemplateExp pte) throws CompilerChainException {
                Variable vpte = (Variable)ClassUtil.nonNullState((Object)pte.getBindsTo());
                Variable mvpte = AbstractEnforceableRelationDomain2CoreMapping.this.variablesAnalysis.getCoreVariable(vpte);
                this.mapOtherTemplateExpression((TemplateExp)pte);
                AbstractEnforceableRelationDomain2CoreMapping.this.variablesAnalysis.addNavigationAssignment(rTemplateVariable, partProperty, (OCLExpression)AbstractQVTr2QVTcRelations.this.createVariableExp(mvpte));
            }

            private void mapOtherSimpleNonVariableExpression(@NonNull Variable rTemplateVariable, @NonNull Property partProperty, @NonNull OCLExpression ptv) {
                AbstractEnforceableRelationDomain2CoreMapping.this.variablesAnalysis.addNavigationAssignment(rTemplateVariable, partProperty, AbstractEnforceableRelationDomain2CoreMapping.this.mapExpression(ptv));
            }

            private void mapOtherSimpleVariableExpression(@NonNull Variable rTemplateVariable, @NonNull Property partProperty, @NonNull VariableExp e) {
                Variable rVariable = (Variable)ClassUtil.nonNullState((Object)((Variable)e.getReferredVariable()));
                Variable cVariable = AbstractEnforceableRelationDomain2CoreMapping.this.variablesAnalysis.getCoreVariable(rVariable);
                AbstractEnforceableRelationDomain2CoreMapping.this.variablesAnalysis.addNavigationAssignment(rTemplateVariable, partProperty, (OCLExpression)AbstractQVTr2QVTcRelations.this.createVariableExp(cVariable));
            }

            protected void mapOtherTemplateExpression(@NonNull TemplateExp rTemplateExpression) throws CompilerChainException {
                OCLExpression rGuardPredicate;
                Variable rTemplateVariable = (Variable)ClassUtil.nonNullState((Object)rTemplateExpression.getBindsTo());
                if (rTemplateExpression instanceof ObjectTemplateExp) {
                    for (PropertyTemplateItem propertyTemplateItem : ClassUtil.nullFree((EList)((ObjectTemplateExp)rTemplateExpression).getPart())) {
                        Property partProperty = (Property)ClassUtil.nonNullState((Object)propertyTemplateItem.getReferredProperty());
                        Variable cTemplateVariable = AbstractEnforceableRelationDomain2CoreMapping.this.variablesAnalysis.getCoreVariable(rTemplateVariable);
                        OCLExpression propertyTemplateValue = (OCLExpression)ClassUtil.nonNullState((Object)propertyTemplateItem.getValue());
                        if (propertyTemplateValue instanceof VariableExp) {
                            this.mapOtherSimpleVariableExpression(rTemplateVariable, partProperty, (VariableExp)propertyTemplateValue);
                            continue;
                        }
                        if (propertyTemplateValue instanceof CollectionTemplateExp) {
                            this.mapOtherCollectionTemplateExpression(cTemplateVariable, partProperty, (CollectionTemplateExp)propertyTemplateValue);
                            continue;
                        }
                        if (propertyTemplateValue instanceof ObjectTemplateExp) {
                            this.mapOtherObjectTemplateExpression(rTemplateVariable, partProperty, (ObjectTemplateExp)propertyTemplateValue);
                            continue;
                        }
                        this.mapOtherSimpleNonVariableExpression(rTemplateVariable, partProperty, propertyTemplateValue);
                    }
                }
                if ((rGuardPredicate = rTemplateExpression.getWhere()) != null) {
                    AbstractEnforceableRelationDomain2CoreMapping.this.cMiddleBottomPattern.getPredicate().add((Object)AbstractQVTr2QVTcRelations.this.createPredicate(AbstractEnforceableRelationDomain2CoreMapping.this.mapExpression(rGuardPredicate)));
                }
            }

            public void synthesize() throws CompilerChainException {
                List<@NonNull TemplateExp> rOtherTemplateExpressions = AbstractEnforceableRelationDomain2CoreMapping.this.getTemplateExpressions(this.rOtherDomain);
                for (TemplateExp rOtherTemplateExpression : rOtherTemplateExpressions) {
                    this.mapOtherTemplateExpression(rOtherTemplateExpression);
                }
            }
        }

        protected class ExpressionCopier
        extends EcoreUtil.Copier {
            protected ExpressionCopier() {
            }

            public EObject get(Object oIn) {
                if (oIn instanceof Element) {
                    List<@NonNull Element> oOuts = (List<Element>)AbstractEnforceableRelationDomain2CoreMapping.this.source2targets.get(oIn);
                    if (oOuts != null) {
                        assert (oOuts.size() == 1);
                        return (EObject)oOuts.get(0);
                    }
                    oOuts = ((AbstractEnforceableRelationDomain2CoreMapping)AbstractEnforceableRelationDomain2CoreMapping.this).AbstractQVTr2QVTcRelations.this.qvtr2qvtc.getGlobalTargets((Element)oIn);
                    if (oOuts != null) {
                        assert (oOuts.size() == 1);
                        return (EObject)oOuts.get(0);
                    }
                }
                return (EObject)super.get(oIn);
            }
        }
    }
}

