/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtbase.utilities;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.IfExp;
import org.eclipse.ocl.pivot.LetExp;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.NullLiteralExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.ShadowExp;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.internal.complete.CompletePackageInternal;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.scoping.EnvironmentView;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.pivot.qvtbase.BaseModel;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Function;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;

public class QVTbaseUtil {
    public static void addAllClasses(@NonNull EnvironmentView environmentView, @NonNull Package pPackage) {
        String packageName = pPackage.getName();
        if (packageName == null || "".equals(packageName)) {
            environmentView.addNamedElements((Iterable)pPackage.getOwnedClasses());
        } else {
            CompletePackageInternal completePackage = environmentView.getEnvironmentFactory().getCompleteModel().getCompletePackage(pPackage);
            environmentView.addNamedElements(completePackage.getAllClasses());
        }
    }

    public static <T extends NamedElement> void addAllNamedElements(@NonNull EnvironmentView environmentView, @NonNull Iterable<T> namedElements) {
        String name = environmentView.getName();
        if (name != null) {
            for (NamedElement namedElement : namedElements) {
                if (namedElement == null || !name.equals(namedElement.getName())) continue;
                environmentView.addElement(name, (Element)namedElement);
            }
        } else {
            for (NamedElement namedElement : namedElements) {
                if (namedElement == null) continue;
                environmentView.addNamedElement(namedElement);
            }
        }
    }

    public static @NonNull List<@NonNull Transformation> getAllTransformations(@NonNull Model asModel) {
        ArrayList<@NonNull Transformation> asTransformations = new ArrayList<Transformation>();
        QVTbaseUtil.getAllTransformations(ClassUtil.nullFree((List)asModel.getOwnedPackages()), asTransformations);
        return asTransformations;
    }

    public static void getAllTransformations(@NonNull List<@NonNull Package> asPackages, @NonNull List<@NonNull Transformation> asTransformations) {
        for (Package asPackage : asPackages) {
            for (Class asClass : ClassUtil.nullFree((List)asPackage.getOwnedClasses())) {
                if (!(asClass instanceof Transformation)) continue;
                asTransformations.add((Transformation)asClass);
            }
            QVTbaseUtil.getAllTransformations(ClassUtil.nullFree((List)asPackage.getOwnedPackages()), asTransformations);
        }
    }

    public static @NonNull Set<TypedModel> getAllTypedModels(@NonNull TypedModel typedModel) {
        HashSet<TypedModel> allTypedModels = new HashSet<TypedModel>();
        QVTbaseUtil.getAllTypedModelsInternal(allTypedModels, typedModel);
        return allTypedModels;
    }

    private static void getAllTypedModelsInternal(@NonNull Set<TypedModel> allTypedModels, @NonNull TypedModel typedModel) {
        if (allTypedModels.add(typedModel)) {
            for (TypedModel dependsOn : typedModel.getDependsOn()) {
                QVTbaseUtil.getAllTypedModelsInternal(allTypedModels, dependsOn);
            }
        }
    }

    public static @NonNull Set<Package> getAllUsedPackages(@NonNull Transformation transformation) {
        HashSet<Package> allPackages = new HashSet<Package>();
        for (TypedModel typedModel : transformation.getModelParameter()) {
            QVTbaseUtil.getAllUsedPackagesInternal(allPackages, typedModel);
        }
        return allPackages;
    }

    public static @NonNull Set<@NonNull Package> getAllUsedPackages(@NonNull TypedModel typedModel) {
        HashSet<@NonNull Package> allUsedPackages = new HashSet<Package>();
        QVTbaseUtil.getAllUsedPackagesInternal(allUsedPackages, typedModel);
        return allUsedPackages;
    }

    private static void getAllUsedPackagesInternal(@NonNull Set<@NonNull Package> allUsedPackages, @NonNull TypedModel typedModel) {
        QVTbaseUtil.getAllUsedPackagesInternal(allUsedPackages, typedModel.getUsedPackage());
        for (TypedModel dependsOn : typedModel.getDependsOn()) {
            QVTbaseUtil.getAllUsedPackagesInternal(allUsedPackages, dependsOn);
        }
    }

    private static void getAllUsedPackagesInternal(@NonNull Set<Package> allUsedPackages, @NonNull Iterable<Package> moreUsedPackages) {
        for (Package usedPackage : moreUsedPackages) {
            if (!allUsedPackages.add(usedPackage)) continue;
            QVTbaseUtil.getAllUsedPackagesInternal(allUsedPackages, usedPackage.getImportedPackages());
        }
    }

    public static @Nullable Domain getContainingDomain(@Nullable EObject eObject) {
        while (eObject != null) {
            if (eObject instanceof Domain) {
                return (Domain)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    public static @Nullable BaseModel getContainingModel(@Nullable EObject eObject) {
        while (eObject != null) {
            if (eObject instanceof BaseModel) {
                return (BaseModel)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    public static @Nullable Rule getContainingRule(@Nullable EObject eObject) {
        while (eObject != null) {
            if (eObject instanceof Rule) {
                return (Rule)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    public static @Nullable Transformation getContainingTransformation(@Nullable EObject eObject) {
        while (eObject != null) {
            if (eObject instanceof Transformation) {
                return (Transformation)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    public static @NonNull Variable getContextVariable(@NonNull StandardLibrary standardLibrary, @NonNull Transformation transformation) {
        Variable ownedContext = transformation.getOwnedContext();
        if (ownedContext == null) {
            Class transformationType = ((StandardLibraryInternal)standardLibrary).getLibraryType("Transformation");
            ownedContext = PivotFactory.eINSTANCE.createVariable();
            ownedContext.setName("this");
            ownedContext.setType((Type)transformationType);
            ownedContext.setTypeValue((Type)transformation);
            ownedContext.setIsRequired(true);
            transformation.setOwnedContext(ownedContext);
        } else {
            ownedContext.setTypeValue((Type)transformation);
        }
        return ownedContext;
    }

    public static @NonNull Variable getContextVariable(@NonNull StandardLibraryInternal standardLibrary, @NonNull TypedModel typedModel) {
        Variable ownedContext = typedModel.getOwnedContext();
        if (ownedContext == null) {
            ownedContext = PivotFactory.eINSTANCE.createVariable();
            ownedContext.setName(typedModel.getName());
            ownedContext.setType((Type)standardLibrary.getLibraryType("Model"));
            ownedContext.setIsRequired(true);
            typedModel.setOwnedContext(ownedContext);
        }
        return ownedContext;
    }

    public static @Nullable Domain getDomain(@NonNull Rule rule, @NonNull TypedModel typedModel) {
        for (Domain domain : rule.getDomain()) {
            if (domain.getTypedModel() != typedModel) continue;
            return domain;
        }
        return null;
    }

    public static @NonNull Type getElementalType(@NonNull Type type) {
        Type elementType = type;
        while (elementType instanceof CollectionType) {
            elementType = ((CollectionType)elementType).getElementType();
            assert (elementType != null);
        }
        return elementType;
    }

    public static @NonNull Set<@NonNull TypedModel> getEnforceableTypedModels(@NonNull Transformation transformation) {
        HashSet<@NonNull TypedModel> enforceableTypedModels = new HashSet<TypedModel>();
        HashSet<@NonNull TypedModel> notEnforceableTypedModels = new HashSet<TypedModel>();
        for (Rule rule : transformation.getRule()) {
            for (Domain domain : rule.getDomain()) {
                TypedModel typedModel = domain.getTypedModel();
                assert (typedModel != null);
                if (domain.isIsEnforceable()) {
                    enforceableTypedModels.add(typedModel);
                    continue;
                }
                notEnforceableTypedModels.add(typedModel);
            }
        }
        enforceableTypedModels.removeAll(notEnforceableTypedModels);
        return enforceableTypedModels;
    }

    public static boolean isIdentification(Operation asOperation) {
        OCLExpression queryExpression;
        return asOperation instanceof Function && (queryExpression = ((Function)asOperation).getQueryExpression()) instanceof ShadowExp;
    }

    public static @NonNull Transformation loadTransformation(@NonNull java.lang.Class<? extends Model> modelClass, @NonNull EnvironmentFactory environmentFactory, @NonNull URI transformationURI, boolean keepDebug) throws IOException {
        ASResource asResource;
        CSResource xtextResource = null;
        if (PivotUtilInternal.isASURI((URI)transformationURI)) {
            asResource = (ASResource)environmentFactory.getMetamodelManager().getASResourceSet().getResource(transformationURI, true);
        } else {
            xtextResource = (CSResource)environmentFactory.getResourceSet().getResource(transformationURI, true);
            if (xtextResource == null) {
                throw new IOException("Failed to load '" + transformationURI + "'");
            }
            String csMessage = PivotUtil.formatResourceDiagnostics((List)((List)ClassUtil.nonNullEMF((Object)xtextResource.getErrors())), (String)("Failed to load '" + transformationURI + "'"), (String)"\n");
            if (csMessage != null) {
                throw new IOException(csMessage);
            }
            asResource = xtextResource.getASResource();
        }
        try {
            String asMessage = PivotUtil.formatResourceDiagnostics((List)((List)ClassUtil.nonNullEMF((Object)asResource.getErrors())), (String)("Failed to load '" + asResource.getURI() + "'"), (String)"\n");
            if (asMessage != null) {
                throw new IOException(asMessage);
            }
            for (EObject eContent : asResource.getContents()) {
                if (!modelClass.isInstance(eContent)) continue;
                for (Package asPackage : ClassUtil.nullFree((List)((Model)eContent).getOwnedPackages())) {
                    Transformation asTransformation = QVTbaseUtil.loadTransformationRecursion(asPackage);
                    if (asTransformation == null) continue;
                    Transformation transformation = asTransformation;
                    return transformation;
                }
            }
        }
        finally {
            if (!keepDebug && xtextResource instanceof CSResource.CSResourceExtension) {
                ((CSResource.CSResourceExtension)xtextResource).dispose();
            }
        }
        throw new IOException("Failed to locate a transformation in '" + transformationURI + "'");
    }

    private static @Nullable Transformation loadTransformationRecursion(@NonNull Package asPackage) {
        for (Class asClass : ClassUtil.nullFree((List)asPackage.getOwnedClasses())) {
            if (!(asClass instanceof Transformation)) continue;
            return (Transformation)asClass;
        }
        for (Package asNestedPackage : ClassUtil.nullFree((List)asPackage.getOwnedPackages())) {
            Transformation asTransformation = QVTbaseUtil.loadTransformationRecursion(asNestedPackage);
            if (asTransformation == null) continue;
            return asTransformation;
        }
        return null;
    }

    public static @NonNull Resource loadTransformations(@NonNull java.lang.Class<? extends Model> modelClass, @NonNull EnvironmentFactory environmentFactory, @NonNull URI transformationURI, boolean keepDebug) throws IOException {
        ASResource asResource;
        CSResource xtextResource = null;
        if (PivotUtilInternal.isASURI((URI)transformationURI)) {
            asResource = (ASResource)environmentFactory.getMetamodelManager().getASResourceSet().getResource(transformationURI, true);
        } else {
            xtextResource = (CSResource)environmentFactory.getResourceSet().getResource(transformationURI, true);
            if (xtextResource == null) {
                throw new IOException("Failed to load '" + transformationURI + "'");
            }
            String csMessage = PivotUtil.formatResourceDiagnostics((List)((List)ClassUtil.nonNullEMF((Object)xtextResource.getErrors())), (String)("Failed to load '" + transformationURI + "'"), (String)"\n");
            if (csMessage != null) {
                throw new IOException(csMessage);
            }
            asResource = xtextResource.getASResource();
        }
        if (asResource == null) {
            throw new IOException("Failed to load '" + transformationURI + "'");
        }
        return asResource;
    }

    public static @Nullable List<OperationCallExp> rewriteMissingOperationCallSources(@NonNull EnvironmentFactory environmentFactory, @NonNull Resource asResource) {
        ArrayList<OperationCallExp> missingSources = null;
        TreeIterator tit = asResource.getAllContents();
        while (tit.hasNext()) {
            OperationCallExp operationCallExp;
            EObject eObject = (EObject)tit.next();
            if (!(eObject instanceof OperationCallExp) || (operationCallExp = (OperationCallExp)eObject).getOwnedSource() != null) continue;
            if (missingSources == null) {
                missingSources = new ArrayList<OperationCallExp>();
            }
            missingSources.add(operationCallExp);
        }
        if (missingSources != null) {
            StandardLibrary standardLibrary = environmentFactory.getStandardLibrary();
            for (OperationCallExp operationCallExp : missingSources) {
                Transformation transformation = QVTbaseUtil.getContainingTransformation((EObject)operationCallExp);
                if (transformation == null) continue;
                Variable thisVariable = QVTbaseUtil.getContextVariable(standardLibrary, transformation);
                operationCallExp.setOwnedSource((OCLExpression)PivotUtil.createVariableExp((Variable)thisVariable));
            }
        }
        return missingSources;
    }

    public static void rewriteSafeNavigations(@NonNull EnvironmentFactory environmentFactory, @NonNull Element asTree) {
        List<@NonNull CallExp> unsafeCallExps = null;
        if (asTree instanceof CallExp) {
            unsafeCallExps = QVTbaseUtil.rewriteUnsafeCallExp_Gather(unsafeCallExps, (CallExp)asTree);
        }
        TreeIterator tit = asTree.eAllContents();
        while (tit.hasNext()) {
            EObject eObject = (EObject)tit.next();
            if (!(eObject instanceof CallExp)) continue;
            unsafeCallExps = QVTbaseUtil.rewriteUnsafeCallExp_Gather(unsafeCallExps, (CallExp)eObject);
        }
        if (unsafeCallExps != null) {
            PivotMetamodelManager metamodelManager = (PivotMetamodelManager)environmentFactory.getMetamodelManager();
            Class oclAnyType = environmentFactory.getStandardLibrary().getOclAnyType();
            Operation oclEqualsOperation = (Operation)NameUtil.getNameable((Iterable)oclAnyType.getOwnedOperations(), (String)"=");
            assert (oclEqualsOperation != null);
            Class collectionType = environmentFactory.getStandardLibrary().getCollectionType();
            Operation excludingOperation = (Operation)NameUtil.getNameable((Iterable)collectionType.getOwnedOperations(), (String)"excluding");
            assert (excludingOperation != null);
            for (CallExp unsafeCallExp : unsafeCallExps) {
                OCLExpression source = unsafeCallExp.getOwnedSource();
                assert (source != null);
                if (source.getType() instanceof CollectionType) {
                    QVTbaseUtil.rewriteUnsafeCollectionCallExp(metamodelManager, excludingOperation, unsafeCallExp);
                    continue;
                }
                QVTbaseUtil.rewriteUnsafeObjectCallExp(metamodelManager, oclEqualsOperation, unsafeCallExp);
            }
        }
    }

    private static @Nullable List<@NonNull CallExp> rewriteUnsafeCallExp_Gather(@Nullable List<@NonNull CallExp> unsafeCallExps, @NonNull CallExp callExp) {
        OCLExpression source = callExp.getOwnedSource();
        if (source != null && callExp.isIsSafe()) {
            if (unsafeCallExps == null) {
                unsafeCallExps = new ArrayList<CallExp>();
            }
            unsafeCallExps.add(callExp);
        }
        return unsafeCallExps;
    }

    private static void rewriteUnsafeCollectionCallExp(@NonNull PivotMetamodelManager metamodelManager, @NonNull Operation excludingOperation, @NonNull CallExp unsafeCollectionCallExp) {
        unsafeCollectionCallExp.setIsSafe(false);
        EObject eContainer = unsafeCollectionCallExp.eContainer();
        EReference eContainmentFeature = unsafeCollectionCallExp.eContainmentFeature();
        PivotUtilInternal.resetContainer((EObject)unsafeCollectionCallExp);
        NullLiteralExp nullExpression = metamodelManager.createNullLiteralExp();
        OperationCallExp safeCollectionCallExp = PivotUtil.createOperationCallExp((OCLExpression)unsafeCollectionCallExp, (Operation)excludingOperation, (OCLExpression[])new OCLExpression[]{nullExpression});
        eContainer.eSet((EStructuralFeature)eContainmentFeature, (Object)safeCollectionCallExp);
    }

    private static void rewriteUnsafeObjectCallExp(@NonNull PivotMetamodelManager metamodelManager, @NonNull Operation oclEqualsOperation, @NonNull CallExp unsafeObjectCallExp) {
        unsafeObjectCallExp.setIsSafe(false);
        EObject eContainer = unsafeObjectCallExp.eContainer();
        EReference eContainmentFeature = unsafeObjectCallExp.eContainmentFeature();
        PivotUtilInternal.resetContainer((EObject)unsafeObjectCallExp);
        OCLExpression oldSourceExpression = unsafeObjectCallExp.getOwnedSource();
        assert (oldSourceExpression != null);
        Variable unsafeSourceVariable = PivotUtil.createVariable((String)"unsafe", (OCLExpression)oldSourceExpression);
        VariableExp unsafeSourceExpression1 = PivotUtil.createVariableExp((Variable)unsafeSourceVariable);
        unsafeObjectCallExp.setOwnedSource((OCLExpression)unsafeSourceExpression1);
        VariableExp unsafeSourceExpression2 = PivotUtil.createVariableExp((Variable)unsafeSourceVariable);
        NullLiteralExp nullExpression = metamodelManager.createNullLiteralExp();
        OperationCallExp isUnsafeExpression = PivotUtil.createOperationCallExp((OCLExpression)unsafeSourceExpression2, (Operation)oclEqualsOperation, (OCLExpression[])new OCLExpression[]{nullExpression});
        NullLiteralExp thenExpression = metamodelManager.createNullLiteralExp();
        IfExp safeObjectCallExp = metamodelManager.createIfExp((OCLExpression)isUnsafeExpression, (OCLExpression)thenExpression, (OCLExpression)unsafeObjectCallExp);
        LetExp safeExp = PivotUtil.createLetExp((Variable)unsafeSourceVariable, (OCLExpression)safeObjectCallExp);
        eContainer.eSet((EStructuralFeature)eContainmentFeature, (Object)safeExp);
    }
}

