/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.utilities;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.IterateExp;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.QVTbaseFactory;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtcorebase.Area;
import org.eclipse.qvtd.pivot.qvtcorebase.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcorebase.PropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.QVTcoreBaseFactory;
import org.eclipse.qvtd.pivot.qvtcorebase.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtcorebase.utilities.QVTcoreBaseUtil;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeDomain;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeModel;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCall;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCallBinding;
import org.eclipse.qvtd.pivot.qvtimperative.MappingLoop;
import org.eclipse.qvtd.pivot.qvtimperative.MappingSequence;
import org.eclipse.qvtd.pivot.qvtimperative.MappingStatement;
import org.eclipse.qvtd.pivot.qvtimperative.QVTimperativeFactory;
import org.eclipse.qvtd.pivot.qvtimperative.VariablePredicate;

public class QVTimperativeUtil
extends QVTcoreBaseUtil {
    public static final @NonNull String ROOT_MAPPING_NAME = "__root__";
    public static final @NonNull String MIDDLE_DOMAIN_NAME = "middle";

    public static @NonNull MappingStatement addMappingStatement(@Nullable MappingStatement mappingStatementOrStatements, @NonNull MappingStatement mappingStatement) {
        if (mappingStatementOrStatements == null) {
            return mappingStatement;
        }
        if (mappingStatementOrStatements instanceof MappingSequence) {
            ((MappingSequence)mappingStatementOrStatements).getMappingStatements().add((Object)mappingStatement);
            return mappingStatementOrStatements;
        }
        MappingSequence mappingSequence = QVTimperativeFactory.eINSTANCE.createMappingSequence();
        EList<MappingStatement> mappingStatements = mappingSequence.getMappingStatements();
        mappingStatements.add(mappingStatementOrStatements);
        mappingStatements.add(mappingStatement);
        return mappingSequence;
    }

    public static @NonNull ImperativeDomain createImperativeDomain(@NonNull TypedModel typedModel) {
        ImperativeDomain coreDomain = QVTimperativeFactory.eINSTANCE.createImperativeDomain();
        coreDomain.setName(typedModel.getName());
        coreDomain.setTypedModel(typedModel);
        coreDomain.setBottomPattern(QVTimperativeFactory.eINSTANCE.createImperativeBottomPattern());
        coreDomain.setGuardPattern(QVTcoreBaseFactory.eINSTANCE.createGuardPattern());
        return coreDomain;
    }

    public static @NonNull IterateExp createIterateExp(@Nullable OCLExpression asSource, @NonNull Iteration asIteration, @NonNull List<? extends Variable> asIterators, @NonNull OCLExpression asBody) {
        IterateExp asCallExp = PivotFactory.eINSTANCE.createIterateExp();
        asCallExp.setReferredIteration(asIteration);
        asCallExp.setOwnedSource(asSource);
        asCallExp.getOwnedIterators().addAll(asIterators);
        asCallExp.setOwnedBody(asBody);
        asCallExp.setType(asIteration.getType());
        asCallExp.setIsRequired(asIteration.isIsRequired());
        return asCallExp;
    }

    public static @NonNull Mapping createMapping(@NonNull String name) {
        Mapping mapping = QVTimperativeFactory.eINSTANCE.createMapping();
        mapping.setName(name);
        mapping.setBottomPattern(QVTimperativeFactory.eINSTANCE.createImperativeBottomPattern());
        mapping.setGuardPattern(QVTcoreBaseFactory.eINSTANCE.createGuardPattern());
        return mapping;
    }

    public static @NonNull MappingCall createMappingCall(@NonNull Mapping mapping, @NonNull List<MappingCallBinding> mappingCallBindings) {
        MappingCall mappingCall = QVTimperativeFactory.eINSTANCE.createMappingCall();
        mappingCall.setReferredMapping(mapping);
        mappingCall.getBinding().addAll(mappingCallBindings);
        return mappingCall;
    }

    public static @NonNull MappingCallBinding createMappingCallBinding(@NonNull Variable variable, @NonNull OCLExpression value) {
        MappingCallBinding mappingCallBinding = QVTimperativeFactory.eINSTANCE.createMappingCallBinding();
        mappingCallBinding.setBoundVariable(variable);
        mappingCallBinding.setValue(value);
        return mappingCallBinding;
    }

    public static @NonNull MappingLoop createMappingLoop(@NonNull OCLExpression source, @NonNull Variable iterator, @NonNull MappingStatement mappingStatement) {
        assert (iterator.eContainer() == null);
        MappingLoop ml = QVTimperativeFactory.eINSTANCE.createMappingLoop();
        ml.setOwnedSource(source);
        ml.getOwnedIterators().add((Object)iterator);
        ml.setOwnedBody(mappingStatement);
        return ml;
    }

    public static @NonNull MappingSequence createMappingSequence(@NonNull List<@NonNull MappingStatement> mappingStatements) {
        MappingSequence mappingSequence = QVTimperativeFactory.eINSTANCE.createMappingSequence();
        mappingSequence.getMappingStatements().addAll(mappingStatements);
        return mappingSequence;
    }

    public static @NonNull Property createProperty(@NonNull String name, @NonNull Type type, boolean isRequired) {
        Property property = PivotUtil.createProperty((String)name, (Type)type);
        property.setIsRequired(isRequired);
        return property;
    }

    public static @NonNull PropertyAssignment createPropertyAssignment(@NonNull OCLExpression slotExpression, @NonNull Property targetProperty, @NonNull OCLExpression value) {
        PropertyAssignment propertyAssignment = QVTcoreBaseFactory.eINSTANCE.createPropertyAssignment();
        propertyAssignment.setSlotExpression(slotExpression);
        propertyAssignment.setTargetProperty(targetProperty);
        propertyAssignment.setValue(value);
        return propertyAssignment;
    }

    public static @NonNull RealizedVariable createRealizedVariable(@NonNull String name, @NonNull Type type) {
        RealizedVariable realizedVariable = QVTcoreBaseFactory.eINSTANCE.createRealizedVariable();
        realizedVariable.setName(name);
        realizedVariable.setType(type);
        realizedVariable.setIsRequired(true);
        return realizedVariable;
    }

    public static @NonNull Transformation createTransformation(@NonNull String name) {
        Transformation transformation = QVTbaseFactory.eINSTANCE.createTransformation();
        transformation.setName(name);
        return transformation;
    }

    public static @NonNull TypedModel createTypedModel(@NonNull String name) {
        TypedModel typedModel = QVTbaseFactory.eINSTANCE.createTypedModel();
        typedModel.setName(name);
        return typedModel;
    }

    public static @Nullable Mapping getContainingMapping(@Nullable EObject eObject) {
        while (eObject != null) {
            if (eObject instanceof Mapping) {
                return (Mapping)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    public static boolean isPrimitiveVariable(@NonNull Variable asVariable) {
        Area asArea = QVTimperativeUtil.getContainingArea((EObject)asVariable);
        return asArea instanceof Mapping && !(asVariable.getType() instanceof CollectionType);
    }

    public static @NonNull Transformation loadTransformation(@NonNull EnvironmentFactory environmentFactory, @NonNull URI transformationURI, boolean keepDebug) throws IOException {
        return QVTimperativeUtil.loadTransformation(ImperativeModel.class, (EnvironmentFactory)environmentFactory, (URI)transformationURI, (boolean)keepDebug);
    }

    public static @NonNull List<VariablePredicate> sortVariablePredicates(@NonNull Mapping asMapping, @NonNull List<VariablePredicate> asVariablePredicates) {
        HashSet asGuardVariables = new HashSet();
        asGuardVariables.addAll(asMapping.getGuardPattern().getVariable());
        for (Domain asDomain : asMapping.getDomain()) {
            asGuardVariables.addAll(((CoreDomain)asDomain).getGuardPattern().getVariable());
        }
        ArrayList<Variable> pendingVariables = new ArrayList<Variable>();
        HashMap<Variable, VariablePredicate> variable2predicate = new HashMap<Variable, VariablePredicate>();
        HashMap<VariableDeclaration, HashSet<VariablePredicate>> variable2predicates = new HashMap<VariableDeclaration, HashSet<VariablePredicate>>();
        HashMap<VariablePredicate, @NonNull HashSet<VariableDeclaration>> predicate2variables = new HashMap<VariablePredicate, HashSet<VariableDeclaration>>();
        for (VariablePredicate asVariablePredicate : asVariablePredicates) {
            TreeIterator treeIterator = asVariablePredicate.eAllContents();
            while (treeIterator.hasNext()) {
                VariableDeclaration asVariable;
                EObject eObject = (EObject)treeIterator.next();
                if (!(eObject instanceof VariableExp) || (asVariable = ((VariableExp)eObject).getReferredVariable()) == null || !asGuardVariables.contains(asVariable)) continue;
                HashSet<VariablePredicate> predicates = (HashSet<VariablePredicate>)variable2predicates.get(asVariable);
                if (predicates == null) {
                    predicates = new HashSet<VariablePredicate>();
                    variable2predicates.put(asVariable, predicates);
                }
                predicates.add(asVariablePredicate);
                HashSet<VariableDeclaration> variables = (HashSet<VariableDeclaration>)predicate2variables.get(asVariablePredicate);
                if (variables == null) {
                    variables = new HashSet<VariableDeclaration>();
                    predicate2variables.put(asVariablePredicate, variables);
                }
                variables.add(asVariable);
                pendingVariables.add(asVariablePredicate.getTargetVariable());
                variable2predicate.put(asVariablePredicate.getTargetVariable(), asVariablePredicate);
            }
        }
        ArrayList<VariablePredicate> asSortedVariablePredicates = new ArrayList<VariablePredicate>();
        Collections.sort(pendingVariables, NameUtil.NAMEABLE_COMPARATOR);
        while (pendingVariables.size() > 0) {
            int oldSize = asSortedVariablePredicates.size();
            for (VariableDeclaration variableDeclaration : pendingVariables) {
                VariablePredicate asVariablePredicate1 = (VariablePredicate)variable2predicate.get(variableDeclaration);
                Set variables = (Set)predicate2variables.get(asVariablePredicate1);
                if (variables == null) continue;
                variables.retainAll(pendingVariables);
                if (variables.size() > 0) continue;
                asSortedVariablePredicates.add(asVariablePredicate1);
                Set predicates = (Set)variable2predicates.get(variableDeclaration);
                if (predicates != null) {
                    for (VariablePredicate asVariablePredicate2 : predicates) {
                        Set variables2 = (Set)predicate2variables.get(asVariablePredicate2);
                        if (variables2 == null) continue;
                        variables2.remove(variableDeclaration);
                    }
                }
                pendingVariables.remove(variableDeclaration);
                predicate2variables.remove(asVariablePredicate1);
                break;
            }
            if (asSortedVariablePredicates.size() != oldSize) continue;
            for (VariablePredicate variablePredicate : predicate2variables.keySet()) {
                asSortedVariablePredicates.add(variablePredicate);
            }
        }
        return asSortedVariablePredicates;
    }

    public static final class MappingCallBindingComparator
    implements Comparator<MappingCallBinding> {
        public static final @NonNull MappingCallBindingComparator INSTANCE = new MappingCallBindingComparator();

        @Override
        public int compare(MappingCallBinding o1, MappingCallBinding o2) {
            Variable v1 = o1.getBoundVariable();
            Variable v2 = o2.getBoundVariable();
            String n1 = v1 != null ? v1.getName() : null;
            String n2 = v2 != null ? v2.getName() : null;
            return ClassUtil.safeCompareTo((Comparable)((Object)n1), (Comparable)((Object)n2));
        }
    }
}

