/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.doc.minioclcs.xtext.internal.tx;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.doc.minioclcs.xtext.internal.tx.AbstractInvocationInternal;
import org.eclipse.qvtd.doc.minioclcs.xtext.tx.AbstractInvocationManager;
import org.eclipse.qvtd.doc.minioclcs.xtext.tx.AbstractTransformer;
import org.eclipse.qvtd.doc.minioclcs.xtext.tx.Invocation;
import org.eclipse.qvtd.doc.minioclcs.xtext.tx.InvocationFailedException;
import org.eclipse.qvtd.doc.minioclcs.xtext.tx.SlotState;

public class LazyInvocationManager
extends AbstractInvocationManager {
    private @Nullable AbstractInvocationInternal blockedInvocations = null;
    private @Nullable AbstractInvocationInternal waitingInvocations = null;

    private synchronized void block(@NonNull Invocation invocation, @NonNull SlotState slotState) {
        AbstractInvocationInternal castInvocation = (AbstractInvocationInternal)invocation;
        assert (castInvocation.debug_blockedBy == null);
        castInvocation.debug_blockedBy = slotState;
        AbstractInvocationInternal blockedInvocations2 = this.blockedInvocations;
        if (blockedInvocations2 == null) {
            this.blockedInvocations = castInvocation;
        } else {
            castInvocation.insertAfter(blockedInvocations2.prev);
        }
        slotState.block(invocation);
        if (this.debugInvocations) {
            AbstractTransformer.INVOCATIONS.println("block " + invocation + " for " + slotState);
        }
    }

    @Override
    public boolean flush() {
        this.flushInternal();
        AbstractInvocationInternal blockedInvocation = this.blockedInvocations;
        if (blockedInvocation == null) {
            return true;
        }
        do {
            if (!this.debugInvocations) continue;
            AbstractTransformer.INVOCATIONS.println("still blocked " + blockedInvocation + " by " + blockedInvocation.debug_blockedBy);
        } while ((blockedInvocation = blockedInvocation.next) != this.blockedInvocations);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushInternal() {
        while (this.waitingInvocations != null) {
            AbstractInvocationInternal invocation = null;
            LazyInvocationManager lazyInvocationManager = this;
            synchronized (lazyInvocationManager) {
                AbstractInvocationInternal waitingInvocations2 = this.waitingInvocations;
                if (waitingInvocations2 != null) {
                    invocation = waitingInvocations2;
                    this.waitingInvocations = waitingInvocations2.next;
                    if (this.waitingInvocations == invocation) {
                        this.waitingInvocations = null;
                    }
                    invocation.remove();
                }
            }
            if (invocation == null) continue;
            if (this.debugInvocations) {
                AbstractTransformer.INVOCATIONS.println("re-invoke " + invocation);
            }
            this.invoke(invocation, false);
        }
    }

    @Override
    public void invoke(@NonNull Invocation invocation, boolean doFlush) {
        try {
            invocation.execute();
            if (this.debugInvocations) {
                AbstractTransformer.INVOCATIONS.println("done " + invocation);
            }
            if (doFlush) {
                this.flushInternal();
            }
        }
        catch (InvocationFailedException e) {
            this.block(invocation, e.slotState);
        }
    }

    @Override
    public synchronized void unblock(@NonNull Invocation invocation) {
        if (this.debugInvocations) {
            AbstractTransformer.INVOCATIONS.println("unblock " + invocation);
        }
        AbstractInvocationInternal castInvocation = (AbstractInvocationInternal)invocation;
        assert (castInvocation.debug_blockedBy != null);
        castInvocation.debug_blockedBy = null;
        if (this.blockedInvocations == castInvocation) {
            this.blockedInvocations = castInvocation.next;
            if (this.blockedInvocations == castInvocation) {
                this.blockedInvocations = null;
            }
        }
        castInvocation.remove();
        AbstractInvocationInternal waitingInvocations2 = this.waitingInvocations;
        if (waitingInvocations2 == null) {
            this.waitingInvocations = castInvocation;
        } else {
            castInvocation.insertAfter(waitingInvocations2.prev);
        }
    }
}

