/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.codegen.qvti;

import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.DependencyVisitor;
import org.eclipse.ocl.examples.codegen.analyzer.NameManager;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorProperty;
import org.eclipse.ocl.examples.codegen.cgmodel.CGModelFactory;
import org.eclipse.ocl.examples.codegen.cgmodel.CGNamedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGPackage;
import org.eclipse.ocl.examples.codegen.cgmodel.CGParameter;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.util.CGModelVisitor;
import org.eclipse.ocl.examples.codegen.generator.TypeDescriptor;
import org.eclipse.ocl.examples.codegen.java.CG2JavaPreVisitor;
import org.eclipse.ocl.examples.codegen.java.CG2JavaVisitor;
import org.eclipse.ocl.examples.codegen.java.JavaCodeGenerator;
import org.eclipse.ocl.examples.codegen.java.JavaDependencyVisitor;
import org.eclipse.ocl.examples.codegen.java.JavaLocalContext;
import org.eclipse.ocl.examples.domain.evaluation.AbstractTransformation;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.ids.ElementId;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.util.Visitor;
import org.eclipse.qvtd.codegen.qvti.QVTiAnalyzer;
import org.eclipse.qvtd.codegen.qvti.QVTiCodeGenerator;
import org.eclipse.qvtd.codegen.qvti.QVTiGlobalContext;
import org.eclipse.qvtd.codegen.qvti.QVTiLocalContext;
import org.eclipse.qvtd.codegen.qvti.QVTiPivot2CGVisitor;
import org.eclipse.qvtd.codegen.qvticgmodel.CGEcorePropertyAssignment;
import org.eclipse.qvtd.codegen.qvticgmodel.CGEcoreRealizedVariable;
import org.eclipse.qvtd.codegen.qvticgmodel.CGFunction;
import org.eclipse.qvtd.codegen.qvticgmodel.CGFunctionCallExp;
import org.eclipse.qvtd.codegen.qvticgmodel.CGFunctionParameter;
import org.eclipse.qvtd.codegen.qvticgmodel.CGGuardVariable;
import org.eclipse.qvtd.codegen.qvticgmodel.CGMapping;
import org.eclipse.qvtd.codegen.qvticgmodel.CGMappingCall;
import org.eclipse.qvtd.codegen.qvticgmodel.CGMappingCallBinding;
import org.eclipse.qvtd.codegen.qvticgmodel.CGPredicate;
import org.eclipse.qvtd.codegen.qvticgmodel.CGPropertyAssignment;
import org.eclipse.qvtd.codegen.qvticgmodel.CGRealizedVariable;
import org.eclipse.qvtd.codegen.qvticgmodel.CGTransformation;
import org.eclipse.qvtd.codegen.qvticgmodel.CGTypedModel;
import org.eclipse.qvtd.codegen.qvticgmodel.util.QVTiCGModelVisitor;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtcorebase.Area;
import org.eclipse.qvtd.pivot.qvtcorebase.Assignment;
import org.eclipse.qvtd.pivot.qvtcorebase.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.PropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtcorebase.utilities.QVTcoreBaseUtil;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCall;

public class QVTiCG2JavaVisitor
extends CG2JavaVisitor
implements QVTiCGModelVisitor<Object> {
    @NonNull
    protected final QVTiAnalyzer analyzer;
    @NonNull
    protected final Transformation transformation;
    @NonNull
    protected final CGPackage cgPackage;
    @NonNull
    protected final CGTransformation cgTransformation;

    public QVTiCG2JavaVisitor(@NonNull QVTiCodeGenerator codeGenerator, @NonNull Transformation transformation, String packageName, String className) {
        super((JavaCodeGenerator)codeGenerator);
        this.analyzer = codeGenerator.getAnalyzer();
        this.transformation = transformation;
        this.cgPackage = CGModelFactory.eINSTANCE.createCGPackage();
        this.cgPackage.setName(packageName);
        QVTiPivot2CGVisitor pivot2CGVisitor = new QVTiPivot2CGVisitor(this.analyzer, this.getGlobalContext());
        this.cgTransformation = (CGTransformation)DomainUtil.nonNullState((Object)((CGNamedElement)transformation.accept((Visitor)pivot2CGVisitor)));
        this.cgPackage.getClasses().add(this.cgTransformation);
        XMIResourceImpl resource = new XMIResourceImpl(URI.createURI((String)"cg.xmi"));
        resource.getContents().add((Object)this.cgPackage);
        this.analyzer.analyze((CGElement)this.cgPackage);
    }

    protected void appendModelIndex(@Nullable CGTypedModel cgTypedModel) {
        if (cgTypedModel == null) {
            this.js.append("-1/*null*/");
        } else {
            this.js.append(String.valueOf(cgTypedModel.getModelIndex()) + "/*" + cgTypedModel.getName() + "*/");
        }
    }

    protected void doAddRealization(@NonNull CGRealizedVariable cgRealizedVariable) {
        BottomPattern pBottomPattern;
        RealizedVariable pRealizedVariable = (RealizedVariable)cgRealizedVariable.getPivot();
        Area pArea = QVTcoreBaseUtil.getContainingArea((EObject)pRealizedVariable);
        if (pArea != null && (pBottomPattern = pArea.getBottomPattern()) != null) {
            for (Assignment pAssignment : pBottomPattern.getAssignment()) {
                Property pOppositeProperty;
                Property pProperty;
                if (!(pAssignment instanceof PropertyAssignment) || (pProperty = ((PropertyAssignment)pAssignment).getTargetProperty()) == null || (pOppositeProperty = pProperty.getOpposite()) == null) continue;
                pOppositeProperty.isComposite();
            }
        }
        CGTypedModel cgTypedModel = cgRealizedVariable.getTypedModel();
        this.js.append("modelObjects[");
        this.appendModelIndex(cgTypedModel);
        this.js.append("].add(");
        this.js.appendValueName((CGValuedElement)cgRealizedVariable);
        this.js.append(");\n");
    }

    protected void doConstructor(@NonNull CGTransformation cgTransformation) {
        String evaluatorName = ((QVTiGlobalContext)this.globalContext).getEvaluatorParameter().getName();
        String className = cgTransformation.getName();
        this.js.append("public " + className + "(final ");
        this.js.appendIsRequired(true);
        this.js.append(" ");
        this.js.appendClassReference(DomainEvaluator.class);
        this.js.append(" " + evaluatorName + ") {\n");
        this.js.pushIndentation(null);
        this.js.append("super(" + evaluatorName + ", new String[] {");
        boolean isFirst = true;
        for (CGTypedModel cgTypedModel : cgTransformation.getTypedModels()) {
            String name;
            if (!isFirst) {
                this.js.append(", ");
            }
            this.js.appendString((name = cgTypedModel.getName()) != null ? name : "");
            isFirst = false;
        }
        this.js.append("});\n");
        this.js.popIndentation();
        this.js.append("}\n");
    }

    protected void doGlobals(@NonNull CGTransformation cgTransformation) {
        DependencyVisitor dependencyVisitor = ((JavaCodeGenerator)this.context).createDependencyVisitor();
        dependencyVisitor.visitAll((Iterable)this.globalContext.getGlobals());
        dependencyVisitor.visitAll((Iterable)cgTransformation.getOperations());
        Iterable sortedDependencies = dependencyVisitor.getSortedDependencies();
        this.generateGlobals(sortedDependencies);
    }

    protected void doRun(@NonNull CGTransformation cgTransformation) {
        CGMapping cgRootMapping = cgTransformation.getMappings().get(0);
        List<CGGuardVariable> cgGuardVariables = cgRootMapping.getGuardVariables();
        NameManager nameManager = this.globalContext.getNameManager();
        HashMap<CGGuardVariable, String> listNames = new HashMap<CGGuardVariable, String>();
        for (CGGuardVariable cgGuardVariable : cgGuardVariables) {
            String nameHint = "LIST_" + cgGuardVariable.getValueName();
            String listName = nameManager.getGlobalSymbolName(null, new String[]{nameHint});
            listNames.put(cgGuardVariable, listName);
        }
        this.js.append("public boolean run() {\n");
        this.js.pushIndentation(null);
        for (CGGuardVariable cgGuardVariable : cgGuardVariables) {
            TypeDescriptor typeDescriptor = ((JavaCodeGenerator)this.context).getTypeDescriptor((CGValuedElement)cgGuardVariable);
            EClassifier eClassifier = (EClassifier)DomainUtil.nonNullState((Object)typeDescriptor.getEClassifier());
            String qualifiedPackageInterfaceName = this.genModelHelper.getQualifiedPackageInterfaceName(eClassifier.getEPackage());
            String classifierLiteralName = this.genModelHelper.getLiteralName(eClassifier);
            this.js.appendClassReference(List.class, new TypeDescriptor[]{typeDescriptor});
            this.js.append(" ");
            this.js.append((String)listNames.get(cgGuardVariable));
            this.js.append(" = getObjectsByType(");
            this.js.appendClassReference(typeDescriptor);
            this.js.append(".class, ");
            this.appendModelIndex(cgGuardVariable.getTypedModel());
            this.js.append(", ");
            this.js.appendClassReference(qualifiedPackageInterfaceName);
            this.js.append(".Literals." + classifierLiteralName);
            this.js.append(");\n");
        }
        for (CGGuardVariable cgGuardVariable : cgGuardVariables) {
            this.js.append("for (");
            this.js.appendClassReference((CGValuedElement)cgGuardVariable);
            this.js.append(" ");
            this.js.appendValueName((CGValuedElement)cgGuardVariable);
            this.js.append(" : ");
            this.js.append((String)listNames.get(cgGuardVariable));
            this.js.append(") {\n");
            this.js.pushIndentation(null);
        }
        this.js.append(cgRootMapping.getName());
        this.js.append("(");
        boolean isFirst = true;
        for (CGGuardVariable cgGuardVariable : cgGuardVariables) {
            if (!isFirst) {
                this.js.append(", ");
            }
            this.js.appendValueName((CGValuedElement)cgGuardVariable);
            isFirst = false;
        }
        this.js.append(");\n");
        for (CGGuardVariable cgGuardVariable : cgGuardVariables) {
            this.js.popIndentation();
            this.js.append("}\n");
        }
        this.js.append("return true;\n");
        this.js.popIndentation();
        this.js.append("}\n");
    }

    protected CGPackage generate() {
        CG2JavaPreVisitor cg2PreVisitor = ((JavaCodeGenerator)this.context).createCG2JavaPreVisitor();
        this.cgPackage.accept((CGModelVisitor)cg2PreVisitor);
        this.safeVisit((CGElement)this.cgPackage);
        return this.cgPackage;
    }

    @NonNull
    protected QVTiGlobalContext getGlobalContext() {
        return (QVTiGlobalContext)this.globalContext;
    }

    @NonNull
    protected QVTiLocalContext getLocalContext() {
        return (QVTiLocalContext)this.localContext;
    }

    @Override
    @Nullable
    public Object visitCGEcorePropertyAssignment(@NonNull CGEcorePropertyAssignment cgPropertyAssignment) {
        EStructuralFeature eStructuralFeature = cgPropertyAssignment.getEStructuralFeature();
        CGValuedElement cgSlot = this.getExpression(cgPropertyAssignment.getSlotValue());
        String setAccessor = this.genModelHelper.getSetAccessor(eStructuralFeature);
        CGValuedElement cgInit = this.getExpression(cgPropertyAssignment.getInitValue());
        this.js.appendLocalStatements(cgSlot);
        this.js.appendLocalStatements(cgInit);
        this.js.appendValueName(cgSlot);
        this.js.append(".");
        this.js.append(setAccessor);
        this.js.append("(");
        this.js.appendValueName(cgInit);
        this.js.append(");\n");
        return null;
    }

    @Override
    @Nullable
    public Object visitCGEcoreRealizedVariable(@NonNull CGEcoreRealizedVariable cgRealizedVariable) {
        EClassifier eClassifier = cgRealizedVariable.getEClassifier();
        EPackage ePackage = eClassifier.getEPackage();
        String javaClass = this.genModelHelper.getQualifiedFactoryInterfaceName(ePackage);
        this.js.appendDeclaration((CGValuedElement)cgRealizedVariable);
        this.js.append(" = ");
        this.js.appendClassReference(javaClass);
        this.js.append(".eINSTANCE.create");
        this.js.append(eClassifier.getName());
        this.js.append("();\n");
        this.doAddRealization(cgRealizedVariable);
        return null;
    }

    @Override
    @Nullable
    public Object visitCGFunction(@NonNull CGFunction cgFunction) {
        JavaLocalContext localContext2 = this.globalContext.getLocalContext((CGElement)cgFunction);
        if (localContext2 != null) {
            this.localContext = localContext2;
            try {
                List cgParameters = cgFunction.getParameters();
                CGValuedElement body = this.getExpression(cgFunction.getBody());
                this.js.append("protected ");
                this.js.appendIsRequired(cgFunction.isRequired());
                this.js.append(" ");
                TypeDescriptor javaTypeDescriptor = ((JavaCodeGenerator)this.context).getTypeDescriptor(cgFunction.getTypeId().getElementId(), false);
                this.js.appendClassReference(javaTypeDescriptor);
                this.js.append(" ");
                this.js.append(cgFunction.getName());
                this.js.append("(");
                boolean isFirst = true;
                for (CGParameter cgParameter : cgParameters) {
                    if (!isFirst) {
                        this.js.append(", ");
                    }
                    this.js.appendDeclaration((CGValuedElement)cgParameter);
                    isFirst = false;
                }
                this.js.append(") {\n");
                this.js.pushIndentation(null);
                this.js.appendCastParameters(localContext2, cgParameters);
                JavaDependencyVisitor dependencyVisitor = new JavaDependencyVisitor(localContext2);
                dependencyVisitor.visit((CGNamedElement)body);
                dependencyVisitor.visitAll((Iterable)localContext2.getLocalVariables());
                Iterable sortedDependencies = dependencyVisitor.getSortedDependencies();
                for (CGValuedElement cgElement : sortedDependencies) {
                    if (cgElement.isInlineable() || !cgElement.isConstant() || cgElement.isGlobal()) continue;
                    cgElement.accept((CGModelVisitor)this);
                }
                if (cgFunction.getBody() != null) {
                    this.js.appendLocalStatements(body);
                    if (body.isInvalid()) {
                        this.js.append("throw ");
                    } else {
                        this.js.append("return ");
                    }
                    this.js.appendValueName(body);
                    this.js.append(";\n");
                } else {
                    this.js.append("return null;\n");
                }
                this.js.popIndentation();
                this.js.append("}\n");
            }
            finally {
                this.localContext = null;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGFunctionCallExp(@NonNull CGFunctionCallExp cgFunctionCallExp) {
        Operation pOperation = cgFunctionCallExp.getReferredOperation();
        List cgArguments = cgFunctionCallExp.getArguments();
        List pParameters = pOperation.getOwnedParameter();
        for (CGValuedElement cgArgument : cgArguments) {
            CGValuedElement argument = this.getExpression(cgArgument);
            this.js.appendLocalStatements(argument);
        }
        this.js.appendDeclaration((CGValuedElement)cgFunctionCallExp);
        this.js.append(" = ");
        this.js.append(cgFunctionCallExp.getFunction().getName());
        this.js.append("(");
        int iMax = Math.min(pParameters.size(), cgArguments.size());
        int i = 0;
        while (i < iMax) {
            if (i > 0) {
                this.js.append(", ");
            }
            CGValuedElement cgArgument = (CGValuedElement)cgArguments.get(i);
            CGValuedElement argument = this.getExpression(cgArgument);
            Parameter pParameter = (Parameter)pParameters.get(i);
            TypeDescriptor parameterTypeDescriptor = ((JavaCodeGenerator)this.context).getTypeDescriptor((ElementId)pParameter.getTypeId(), false);
            this.js.appendReferenceTo(parameterTypeDescriptor, argument);
            ++i;
        }
        this.js.append(");\n");
        return null;
    }

    @Override
    @Nullable
    public Object visitCGFunctionParameter(@NonNull CGFunctionParameter object) {
        return this.visitCGParameter(object);
    }

    @Override
    @Nullable
    public Object visitCGGuardVariable(@NonNull CGGuardVariable object) {
        return this.visitCGParameter(object);
    }

    @Override
    @Nullable
    public Object visitCGMapping(@NonNull CGMapping cgMapping) {
        JavaLocalContext localContext2 = this.globalContext.getLocalContext((CGElement)cgMapping);
        if (localContext2 != null) {
            this.localContext = localContext2;
            try {
                List<CGGuardVariable> cgGuardVariables = cgMapping.getGuardVariables();
                this.js.appendCommentWithOCL(null, (Element)cgMapping.getPivot());
                this.js.append("protected boolean " + cgMapping.getName() + "(");
                boolean isFirst = true;
                for (CGGuardVariable cgGuardVariable : cgGuardVariables) {
                    if (!isFirst) {
                        this.js.append(", ");
                    }
                    this.js.appendDeclaration((CGValuedElement)cgGuardVariable);
                    isFirst = false;
                }
                this.js.append(") {\n");
                this.js.pushIndentation(null);
                DependencyVisitor dependencyVisitor = ((JavaCodeGenerator)this.context).createDependencyVisitor(localContext2);
                dependencyVisitor.visitAll((Iterable)localContext2.getLocalVariables());
                Iterable sortedDependencies = dependencyVisitor.getSortedDependencies();
                for (CGValuedElement cgElement : sortedDependencies) {
                    if (cgElement.isInlineable() || !cgElement.isConstant() || cgElement.isGlobal()) continue;
                    cgElement.accept((CGModelVisitor)this);
                }
                this.js.append("// guards\n");
                for (CGPredicate cgPredicate : cgMapping.getPredicates()) {
                    cgPredicate.accept(this);
                }
                this.js.append("// creations\n");
                for (CGRealizedVariable cgRealizedVariable : cgMapping.getRealizedVariables()) {
                    cgRealizedVariable.accept(this);
                }
                this.js.append("// assignments\n");
                for (CGPropertyAssignment cgAssignment : cgMapping.getAssignments()) {
                    cgAssignment.accept(this);
                }
                this.js.append("// mapping calls\n");
                for (CGMappingCall cgMappingCall : cgMapping.getMappingCalls()) {
                    cgMappingCall.accept(this);
                }
                this.js.append("return true;\n");
                this.js.popIndentation();
                this.js.append("}\n");
            }
            finally {
                this.localContext = null;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGMappingCall(@NonNull CGMappingCall cgMappingCall) {
        MappingCall pMappingCall = (MappingCall)cgMappingCall.getPivot();
        Mapping pReferredMapping = pMappingCall.getReferredMapping();
        CGMapping cgReferredMapping = this.analyzer.getMapping(pReferredMapping);
        if (cgReferredMapping == null) {
            return null;
        }
        List<CGMappingCallBinding> cgMappingCallBindings = cgMappingCall.getMappingCallBindings();
        for (CGMappingCallBinding cgMappingCallBinding : cgMappingCallBindings) {
            this.js.appendLocalStatements(cgMappingCallBinding.getValueOrValues());
        }
        for (CGMappingCallBinding cgMappingCallBinding : cgMappingCallBindings) {
            if (!cgMappingCallBinding.isLoop()) continue;
            this.js.append("for (");
            this.js.appendClassReference((CGValuedElement)cgMappingCallBinding);
            this.js.append(" ");
            this.js.appendValueName((CGValuedElement)cgMappingCallBinding);
            this.js.append(" : ");
            this.js.appendValueName(cgMappingCallBinding.getValueOrValues());
            this.js.append(") {\n");
            this.js.pushIndentation(null);
        }
        this.js.append(String.valueOf(cgReferredMapping.getName()) + "(");
        boolean isFirst = true;
        for (CGMappingCallBinding cgMappingCallBinding : cgMappingCallBindings) {
            if (!isFirst) {
                this.js.append(", ");
            }
            if (cgMappingCallBinding.isLoop()) {
                this.js.appendValueName((CGValuedElement)cgMappingCallBinding);
            } else {
                this.js.appendValueName(cgMappingCallBinding.getValueOrValues());
            }
            isFirst = false;
        }
        this.js.append(");\n");
        for (CGMappingCallBinding cgMappingCallBinding : cgMappingCallBindings) {
            if (!cgMappingCallBinding.isLoop()) continue;
            this.js.popIndentation();
            this.js.append("}\n");
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGMappingCallBinding(@NonNull CGMappingCallBinding object) {
        return null;
    }

    @Override
    @Nullable
    public Object visitCGPredicate(@NonNull CGPredicate cgPredicate) {
        CGValuedElement cgConditionExpression = cgPredicate.getConditionExpression();
        this.js.appendLocalStatements(cgConditionExpression);
        this.js.append("if (");
        this.js.appendValueName(cgConditionExpression);
        this.js.append(" != ");
        this.js.appendClassReference(ValuesUtil.class);
        this.js.append(".TRUE_VALUE) {\n");
        this.js.pushIndentation(null);
        this.js.append("return false;\n");
        this.js.popIndentation();
        this.js.append("}\n");
        return null;
    }

    @Override
    @Nullable
    public Object visitCGPropertyAssignment(@NonNull CGPropertyAssignment cgPropertyAssignment) {
        CGExecutorProperty cgExecutorProperty = this.localContext.getExecutorProperty(cgPropertyAssignment.getReferredProperty());
        this.js.appendLocalStatements(cgPropertyAssignment.getInitValue());
        this.js.appendValueName((CGValuedElement)cgExecutorProperty);
        this.js.append(".initValue(");
        this.js.appendValueName(cgPropertyAssignment.getInitValue());
        this.js.append(");\n");
        return null;
    }

    @Override
    @Nullable
    public Object visitCGRealizedVariable(@NonNull CGRealizedVariable cgRealizedVariable) {
        this.js.appendDeclaration((CGValuedElement)cgRealizedVariable);
        this.js.append(" = ");
        this.js.appendReferenceTo((CGValuedElement)this.localContext.getExecutorType(cgRealizedVariable.getPivotTypeId()));
        this.js.append(".createInstance();\n");
        this.doAddRealization(cgRealizedVariable);
        return null;
    }

    @Override
    @Nullable
    public Object visitCGTransformation(@NonNull CGTransformation cgTransformation) {
        String className = cgTransformation.getName();
        this.js.append("/**\n");
        this.js.append(" * The " + className + " transformation:\n");
        this.js.append(" * <p>\n");
        this.js.append(" * Construct with an evaluator\n");
        this.js.append(" * <br>\n");
        this.js.append(" * Populate each input model with {@link addRootObjects(String,List)}\n");
        this.js.append(" * <br>\n");
        this.js.append(" * {@link run()}\n");
        this.js.append(" * <br>\n");
        this.js.append(" * Extract each output model with {@link getRootObjects(String)}\n");
        this.js.append(" */\n");
        this.js.append("@SuppressWarnings(\"nls\")\n");
        this.js.append("public class " + className + " extends ");
        this.js.appendClassReference(AbstractTransformation.class);
        this.js.append("\n");
        this.js.append("{\n");
        this.js.pushIndentation(null);
        this.doGlobals(cgTransformation);
        this.js.append("\n");
        this.doConstructor(cgTransformation);
        this.js.append("\n");
        this.doRun(cgTransformation);
        for (CGOperation cgOperation : cgTransformation.getOperations()) {
            this.js.append("\n");
            cgOperation.accept((CGModelVisitor)this);
        }
        for (CGMapping cgMapping : cgTransformation.getMappings()) {
            this.js.append("\n");
            cgMapping.accept(this);
        }
        this.js.popIndentation();
        this.js.append("}\n");
        return null;
    }

    @Override
    @Nullable
    public Object visitCGTypedModel(@NonNull CGTypedModel object) {
        return null;
    }
}

