/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtrelation.utilities;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.pivot.qvtbase.Pattern;
import org.eclipse.qvtd.pivot.qvtbase.QVTbaseFactory;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseHelper;
import org.eclipse.qvtd.pivot.qvtrelation.DomainPattern;
import org.eclipse.qvtd.pivot.qvtrelation.Key;
import org.eclipse.qvtd.pivot.qvtrelation.QVTrelationFactory;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationCallExp;
import org.eclipse.qvtd.pivot.qvtrelation.RelationDomain;
import org.eclipse.qvtd.pivot.qvtrelation.RelationalTransformation;
import org.eclipse.qvtd.pivot.qvtrelation.SharedVariable;
import org.eclipse.qvtd.pivot.qvtrelation.TemplateVariable;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvttemplate.CollectionTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.ObjectTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.PropertyTemplateItem;
import org.eclipse.qvtd.pivot.qvttemplate.QVTtemplateFactory;
import org.eclipse.qvtd.pivot.qvttemplate.TemplateExp;

public class QVTrelationHelper
extends QVTbaseHelper {
    public QVTrelationHelper(@NonNull EnvironmentFactory environmentFactory) {
        super(environmentFactory);
    }

    public void addWhenPredicate(@NonNull Relation qvtrRelation, @NonNull OCLExpression asExpression) {
        Pattern asPattern = qvtrRelation.getWhen();
        if (asPattern == null) {
            asPattern = QVTbaseFactory.eINSTANCE.createPattern();
            qvtrRelation.setWhen(asPattern);
        }
        asPattern.getPredicate().add((Object)this.createPredicate(asExpression));
    }

    public void addWherePredicate(@NonNull Relation qvtrRelation, @NonNull OCLExpression asExpression) {
        Pattern asPattern = qvtrRelation.getWhere();
        if (asPattern == null) {
            asPattern = QVTbaseFactory.eINSTANCE.createPattern();
            qvtrRelation.setWhere(asPattern);
        }
        asPattern.getPredicate().add((Object)this.createPredicate(asExpression));
    }

    public void computeBoundVariables(@NonNull List<@NonNull Variable> boundVariables, @NonNull OCLExpression asExpression) {
        block5: {
            block4: {
                if (!(asExpression instanceof ObjectTemplateExp)) break block4;
                ObjectTemplateExp asObjectTemplateExp = (ObjectTemplateExp)asExpression;
                Variable asBoundVariable = QVTrelationUtil.getBindsTo((TemplateExp)asObjectTemplateExp);
                if (!boundVariables.contains(asBoundVariable)) {
                    boundVariables.add(asBoundVariable);
                }
                for (PropertyTemplateItem asPart : QVTrelationUtil.getOwnedParts((ObjectTemplateExp)asObjectTemplateExp)) {
                    this.computeBoundVariables(boundVariables, QVTrelationUtil.getOwnedValue(asPart));
                }
                break block5;
            }
            if (!(asExpression instanceof CollectionTemplateExp)) break block5;
            CollectionTemplateExp asCollectionTemplateExp = (CollectionTemplateExp)asExpression;
            Variable asBoundVariable = QVTrelationUtil.getBindsTo((TemplateExp)asCollectionTemplateExp);
            if (!boundVariables.contains(asBoundVariable)) {
                boundVariables.add(asBoundVariable);
            }
            for (OCLExpression asMemberExpression : QVTrelationUtil.getOwnedMembers((CollectionTemplateExp)asCollectionTemplateExp)) {
                this.computeBoundVariables(boundVariables, asMemberExpression);
            }
        }
    }

    public @NonNull CollectionTemplateExp createCollectionTemplateExp(@NonNull TemplateVariable asTemplateVariable, @NonNull Class asClass, boolean isRequired) {
        CollectionTemplateExp asCollectionTemplateExp = QVTtemplateFactory.eINSTANCE.createCollectionTemplateExp();
        asCollectionTemplateExp.setType((Type)asClass);
        asCollectionTemplateExp.setReferredCollectionType((CollectionType)asClass);
        asCollectionTemplateExp.setIsRequired(isRequired);
        asCollectionTemplateExp.setBindsTo((Variable)asTemplateVariable);
        return asCollectionTemplateExp;
    }

    public @NonNull DomainPattern createDomainPattern(@NonNull TemplateExp asTemplateExp) {
        DomainPattern asDomainPattern = QVTrelationFactory.eINSTANCE.createDomainPattern();
        asDomainPattern.setTemplateExpression(asTemplateExp);
        return asDomainPattern;
    }

    public @NonNull Key createKey(@NonNull Class asClass, @NonNull Iterable<@NonNull Property> asProperties) {
        Key asKey = QVTrelationFactory.eINSTANCE.createKey();
        asKey.setIdentifies(asClass);
        Iterables.addAll(QVTrelationUtil.Internal.getOwnedPartsList(asKey), asProperties);
        return asKey;
    }

    public @NonNull ObjectTemplateExp createObjectTemplateExp(@NonNull TemplateVariable asTemplateVariable, @NonNull Class asClass, boolean isRequired) {
        ObjectTemplateExp asObjectTemplateExp = QVTtemplateFactory.eINSTANCE.createObjectTemplateExp();
        this.setType((TypedElement)asObjectTemplateExp, (Type)asClass, isRequired);
        asObjectTemplateExp.setReferredClass(asClass);
        asObjectTemplateExp.setBindsTo((Variable)asTemplateVariable);
        return asObjectTemplateExp;
    }

    public @NonNull PropertyTemplateItem createPropertyTemplateItem(@NonNull Property asProperty, @NonNull OCLExpression asExpression) {
        PropertyTemplateItem asPropertyTemplateItem = QVTtemplateFactory.eINSTANCE.createPropertyTemplateItem();
        boolean isOpposite = asProperty.isIsImplicit();
        asPropertyTemplateItem.setIsOpposite(isOpposite);
        asPropertyTemplateItem.setReferredProperty(isOpposite ? PivotUtil.getOpposite((Property)asProperty) : asProperty);
        asPropertyTemplateItem.setValue(asExpression);
        return asPropertyTemplateItem;
    }

    public @NonNull Relation createRelation(@NonNull String name, @NonNull Iterable<@NonNull RelationDomain> asRelationDomains) {
        Relation asRelation = QVTrelationFactory.eINSTANCE.createRelation();
        asRelation.setName(name);
        Iterables.addAll(QVTrelationUtil.Internal.getOwnedDomainsList(asRelation), asRelationDomains);
        return asRelation;
    }

    public @NonNull RelationCallExp createRelationCallExp(@NonNull Relation asRelation, @NonNull List<? extends @NonNull OCLExpression> asArguments) {
        RelationCallExp asRelationCallExp = QVTrelationFactory.eINSTANCE.createRelationCallExp();
        asRelationCallExp.setReferredRelation(asRelation);
        Iterables.addAll(QVTrelationUtil.Internal.getOwnedArgumentsList(asRelationCallExp), asArguments);
        this.setType((TypedElement)asRelationCallExp, (Type)this.environmentFactory.getStandardLibrary().getBooleanType(), true);
        return asRelationCallExp;
    }

    public @NonNull RelationDomain createRelationDomain(@NonNull TypedModel asTypedModel) {
        RelationDomain asRelationDomain = QVTrelationFactory.eINSTANCE.createRelationDomain();
        asRelationDomain.setTypedModel(asTypedModel);
        return asRelationDomain;
    }

    public @NonNull RelationalTransformation createRelationalTransformation(@NonNull String name, @NonNull Iterable<@NonNull TypedModel> asTypedModels) {
        StandardLibrary standardLibrary = this.environmentFactory.getStandardLibrary();
        RelationalTransformation asRelationalTransformation = QVTrelationFactory.eINSTANCE.createRelationalTransformation();
        asRelationalTransformation.setName(name);
        Iterables.addAll((Collection)QVTrelationUtil.Internal.getModelParameterList((Transformation)asRelationalTransformation), asTypedModels);
        asRelationalTransformation.getSuperClasses().add(standardLibrary.getOclElementType());
        return asRelationalTransformation;
    }

    public @NonNull SharedVariable createSharedVariable(@Nullable String name, @NonNull Type asType, boolean isRequired, @Nullable OCLExpression asInitExpression) {
        SharedVariable asVariable = QVTrelationFactory.eINSTANCE.createSharedVariable();
        asVariable.setName(name);
        asVariable.setIsImplicit(name == null);
        this.setType((TypedElement)asVariable, asType, isRequired);
        asVariable.setOwnedInit(asInitExpression);
        return asVariable;
    }

    public @NonNull TemplateVariable createTemplateVariable(@NonNull String name, @NonNull Type asType, boolean isRequired, @Nullable OCLExpression asInitExpression) {
        TemplateVariable asVariable = QVTrelationFactory.eINSTANCE.createTemplateVariable();
        asVariable.setName(name);
        this.setType((TypedElement)asVariable, asType, isRequired);
        asVariable.setOwnedInit(asInitExpression);
        return asVariable;
    }
}

