/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RegionHelper;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractPartialPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.MappingPartitioner;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitioningVisitor;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.utilities.ReachabilityForest;
import org.eclipse.qvtd.pivot.qvtschedule.BooleanLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.MicroMappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.SuccessEdge;
import org.eclipse.qvtd.pivot.qvtschedule.SuccessNode;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

class SpeculatingPartition
extends AbstractPartialPartition {
    private final @NonNull Node traceNode;
    private final @NonNull Iterable<@NonNull Node> executionNodes;
    private final @NonNull Set<@NonNull Node> tracedInputNodes = new HashSet<Node>();

    public SpeculatingPartition(@NonNull MappingPartitioner partitioner, @NonNull ReachabilityForest reachabilityForest) {
        super(partitioner, reachabilityForest, "\u00abspeculating\u00bb");
        this.traceNode = partitioner.getTraceNode();
        this.executionNodes = partitioner.getExecutionNodes();
        if (this.hasSynthesizedTrace) {
            for (Node traceNode : this.executionNodes) {
                this.addNode(traceNode, Role.PREDICATED);
            }
            Node dispatchNode = partitioner.basicGetDispatchNode();
            if (dispatchNode != null) {
                assert (dispatchNode.isPredicated());
                this.addNode(dispatchNode);
            }
        } else {
            this.resolveTraceNodes();
        }
        if (this.hasSynthesizedTrace) {
            for (Node whenNode : partitioner.getPredicatedWhenNodes()) {
                if (partitioner.hasPredicatedNode(whenNode)) continue;
                this.addNode(whenNode);
            }
        } else {
            this.resolvePredicatedMiddleNodes();
            this.resolvePredicatedOutputNodes();
        }
        this.resolveSuccessNodes();
        this.resolveConstantOutputNodes();
        this.resolvePrecedingNodes();
        this.resolveEdges();
    }

    @Override
    public @NonNull MappingRegion createMicroMappingRegion(int partitionNumber) {
        return this.createMicroMappingRegion("\u00abspeculating\u00bb", "_p" + partitionNumber);
    }

    @Override
    protected @NonNull PartitioningVisitor createPartitioningVisitor(@NonNull MicroMappingRegion partialRegion) {
        return new PartitioningVisitor(new RegionHelper<MicroMappingRegion>(this.scheduleManager, partialRegion), this){

            public @Nullable Element visitSuccessNode(@NonNull SuccessNode node) {
                for (Node traceNode : SpeculatingPartition.this.executionNodes) {
                    if (node != SpeculatingPartition.this.partitioner.basicGetLocalSuccessNode(traceNode)) continue;
                    RegionHelper<@NonNull MicroMappingRegion> partialRegionHelper = new RegionHelper<MicroMappingRegion>(SpeculatingPartition.this.scheduleManager, this.partialRegion);
                    BooleanLiteralNode partialNode = partialRegionHelper.createBooleanLiteralNode(true);
                    this.addNode((Node)node, (Node)partialNode);
                    return partialNode;
                }
                return (Element)super.visitSuccessNode(node);
            }
        };
    }

    @Override
    protected @Nullable Iterable<@NonNull Node> getPreferredHeadNodes() {
        return this.executionNodes;
    }

    private boolean isDownstreamFromCorollary(@NonNull Node node) {
        if (this.transformationAnalysis.isCorollary(node)) {
            return true;
        }
        if (node.isOperation()) {
            boolean allReachable = true;
            for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
                Node sourceNode;
                if (!edge.isComputation() || !this.isDownstreamFromCorollary(sourceNode = QVTscheduleUtil.getSourceNode((Edge)edge))) continue;
                allReachable = false;
                break;
            }
            if (allReachable) {
                return false;
            }
        }
        for (Node precedingNode : this.getPredecessors(node)) {
            if (this.isDownstreamFromCorollary(precedingNode)) continue;
            return false;
        }
        return true;
    }

    protected void resolveConstantOutputNodes() {
        for (Node constantOutputNode : this.partitioner.getConstantOutputNodes()) {
            if (this.partitioner.hasPredicatedNode(constantOutputNode)) continue;
            this.addNode(constantOutputNode);
        }
    }

    @Override
    protected @Nullable Role resolveEdgeRole(@NonNull Role sourceNodeRole, @NonNull Edge edge, @NonNull Role targetNodeRole) {
        boolean hasRealizedEdge;
        Role edgeRole = QVTscheduleUtil.getEdgeRole((Edge)edge);
        if (edgeRole == Role.REALIZED) {
            if (this.partitioner.hasRealizedEdge(edge)) {
                edgeRole = Role.PREDICATED;
            }
        } else if (edgeRole == Role.PREDICATED && edge instanceof SuccessEdge && !(hasRealizedEdge = this.partitioner.hasRealizedEdge(edge))) {
            edgeRole = Role.SPECULATED;
        }
        return edgeRole;
    }

    protected void resolvePredicatedMiddleNodes() {
        for (Node node : this.partitioner.getPredicatedMiddleNodes()) {
            if (this.hasNode(node) || !node.isMatched()) continue;
            Role nodeRole = QVTscheduleUtil.getNodeRole((Node)node);
            this.addNode(node, nodeRole);
        }
    }

    protected void resolvePredicatedOutputNodes() {
        for (Node node : this.partitioner.getPredicatedOutputNodes()) {
            if (this.hasNode(node) || this.transformationAnalysis.isCorollary(node) || this.isDownstreamFromCorollary(node)) continue;
            this.addNode(node, QVTscheduleUtil.getNodeRole((Node)node));
        }
    }

    protected void resolveSuccessNodes() {
        for (Node traceNode : this.executionNodes) {
            Node localSuccessNode = this.partitioner.getLocalSuccessNode(traceNode);
            this.addNode(localSuccessNode, Role.PREDICATED);
            Node globalSuccessNode = this.partitioner.getGlobalSuccessNode(traceNode);
            this.addNode(globalSuccessNode, Role.REALIZED);
        }
    }

    protected void resolveTraceNodes() {
        List<@NonNull Node> traceNodes = this.partitioner.getTraceNodes();
        for (Node traceNode : traceNodes) {
            this.addNode(traceNode, Role.SPECULATED);
        }
        for (Node traceNode : traceNodes) {
            for (NavigableEdge edge : traceNode.getNavigableEdges()) {
                if (!this.partitioner.hasRealizedEdge((Edge)edge)) continue;
                this.tracedInputNodes.add(edge.getEdgeTarget());
            }
            Node globalSuccessNode = this.partitioner.basicGetGlobalSuccessNode(traceNode);
            if (globalSuccessNode == null) continue;
            this.addNode(globalSuccessNode, Role.REALIZED);
        }
    }
}

