/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.runtime.evaluation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.qvtd.runtime.evaluation.AbstractTransformer;
import org.eclipse.qvtd.runtime.evaluation.Connection;
import org.eclipse.qvtd.runtime.evaluation.ExecutionVisitor;
import org.eclipse.qvtd.runtime.evaluation.Interval;
import org.eclipse.qvtd.runtime.evaluation.InvocationConstructor;

public abstract class AbstractConnection
implements Connection {
    protected final boolean debugAppends = AbstractTransformer.APPENDS.isActive();
    protected final @NonNull Interval interval;
    protected final @NonNull String name;
    protected final @NonNull TypeId typeId;
    protected final @NonNull List<@NonNull InvocationConstructor> consumers = new ArrayList<InvocationConstructor>();
    private @Nullable AbstractConnection nextConnection = null;
    private boolean isQueued = false;

    protected AbstractConnection(@NonNull Interval interval, @NonNull String name, @NonNull TypeId typeId) {
        this.interval = interval;
        this.name = name;
        this.typeId = typeId;
    }

    @Override
    public <R> R accept(@NonNull ExecutionVisitor<R> visitor) {
        return visitor.visitConnection(this);
    }

    @Override
    public boolean addConsumer(@NonNull InvocationConstructor consumer) {
        if (!this.consumers.contains(consumer)) {
            this.consumers.add(consumer);
            return true;
        }
        return false;
    }

    @Override
    public @NonNull Iterable<@NonNull InvocationConstructor> getConsumers() {
        return this.consumers;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public final @Nullable AbstractConnection getNextConnection() {
        return this.nextConnection;
    }

    public boolean isQueued() {
        return this.isQueued;
    }

    @Override
    public void propagate() {
        for (InvocationConstructor consumer : this.consumers) {
            consumer.propagate();
        }
    }

    @Override
    public final void queue() {
        if (!this.isQueued) {
            this.isQueued = true;
            this.interval.queue(this);
        }
    }

    public void resetQueued() {
        this.isQueued = false;
        this.nextConnection = null;
    }

    public void setNextConnection(@NonNull AbstractConnection nextConnection) {
        assert (nextConnection != this);
        this.nextConnection = nextConnection;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("<");
        s.append(this.interval.getIndex());
        s.append(">");
        s.append(this.name);
        s.append("[");
        s.append(this.getCapacity());
        s.append("]");
        return s.toString();
    }
}

