/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.runtime.evaluation;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.runtime.evaluation.AbstractTransformer;
import org.eclipse.qvtd.runtime.evaluation.ExecutionVisitor;
import org.eclipse.qvtd.runtime.evaluation.Invocation;
import org.eclipse.qvtd.runtime.evaluation.InvocationManager;
import org.eclipse.qvtd.runtime.evaluation.ObjectManager;
import org.eclipse.qvtd.runtime.evaluation.SlotState;

public abstract class AbstractObjectManager
implements ObjectManager {
    protected static final @NonNull List<@NonNull SlotState> EMPTY_SLOT_STATE_LIST = Collections.emptyList();
    protected final @NonNull InvocationManager invocationManager;
    protected final boolean debugAssignments = AbstractTransformer.ASSIGNMENTS.isActive();
    protected final boolean debugGettings = AbstractTransformer.GETTINGS.isActive();

    protected AbstractObjectManager(@NonNull InvocationManager invocationManager) {
        this.invocationManager = invocationManager;
    }

    @Override
    public <R> R accept(@NonNull ExecutionVisitor<R> visitor) {
        return visitor.visitObjectManager(this);
    }

    @Override
    @Deprecated
    public synchronized void assigned(@NonNull Object eObject, EStructuralFeature eFeature, @Nullable Object ecoreValue, @Nullable Object childKey) {
        this.assigned(eObject, eFeature, ecoreValue);
    }

    @Override
    @Deprecated
    public void assigned(@NonNull Invocation.Incremental invocation, @NonNull Object eObject, EStructuralFeature eFeature, @Nullable Object ecoreValue, @Nullable Object childKey) {
        this.assigned(invocation, eObject, eFeature, ecoreValue);
    }

    public static @NonNull String toDebugString(@Nullable Object object) {
        if (object == null) {
            return "null";
        }
        StringBuilder s = new StringBuilder();
        if (object instanceof EObject) {
            EClass eClass = ((EObject)object).eClass();
            EPackage ePackage = eClass.getEPackage();
            s.append(ePackage.getName());
            s.append("::");
            s.append(eClass.getName());
        } else {
            String className = object.getClass().getName();
            int index = className.lastIndexOf(46);
            if (index >= 0) {
                className = className.substring(index + 1);
            }
            s.append(className);
        }
        s.append("@");
        s.append(Integer.toHexString(System.identityHashCode(object)));
        return s.toString();
    }
}

