/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.qvtd.compiler.CompilerConstants;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.HeadAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.HeadNodeGroup;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.TracedHeadNodeGroup;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtschedule.CastEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.KeyPartEdge;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.PredicateEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class TracedHeadAnalysis
extends HeadAnalysis {
    public static final @NonNull TracingOption TRACED_HEAD_NODE_GROUPS = new TracingOption(CompilerConstants.PLUGIN_ID, "qvtr2qvts/trace/headNodeGroups");
    public static final @NonNull TracingOption TRACED_HEAD_IMMEDIATE_SOURCES = new TracingOption(CompilerConstants.PLUGIN_ID, "qvtr2qvts/trace/headSources");

    public static @NonNull List<@NonNull HeadNodeGroup> computeTraceHeadGroupNodes(@NonNull ScheduleManager scheduleManager, @NonNull MappingRegion mappingRegion) {
        TracedHeadAnalysis mappingRegionAnalysis = new TracedHeadAnalysis(mappingRegion);
        Map<@NonNull Node, @NonNull Set<@NonNull Node>> targetFromSources = mappingRegionAnalysis.computeTracedTargetFromSources();
        if (TRACED_HEAD_IMMEDIATE_SOURCES.isActive()) {
            StringBuilder s = new StringBuilder();
            ArrayList<@NonNull Node> targets = new ArrayList<Node>(targetFromSources.keySet());
            Collections.sort(targets, NameUtil.NAMEABLE_COMPARATOR);
            for (Node target : targets) {
                s.append("\n  " + target.getName() + ":");
                ArrayList<@NonNull E> sources = new ArrayList(targetFromSources.get(target));
                Collections.sort(sources, NameUtil.NAMEABLE_COMPARATOR);
                for (Node source : sources) {
                    s.append(" " + source.getName());
                }
            }
            TRACED_HEAD_IMMEDIATE_SOURCES.println(s.toString());
        }
        Map<@NonNull Node, @NonNull Set<@NonNull Node>> targetFromSourcesClosure = CompilerUtil.computeClosure(targetFromSources);
        Map<@NonNull Node, @NonNull Set<@NonNull Node>> sourceToTargetsClosure = CompilerUtil.computeInverseClosure(targetFromSourcesClosure);
        List<@NonNull HeadNodeGroup> headNodeGroups = mappingRegionAnalysis.computeHeadNodeGroups(targetFromSourcesClosure, sourceToTargetsClosure, null);
        Collections.sort(headNodeGroups, NameUtil.NAMEABLE_COMPARATOR);
        if (TRACED_HEAD_NODE_GROUPS.isActive()) {
            StringBuilder s = new StringBuilder();
            s.append(mappingRegion.getName());
            for (HeadNodeGroup headNodeGroup : headNodeGroups) {
                s.append("\n\t");
                headNodeGroup.appendTo(s);
            }
            TRACED_HEAD_NODE_GROUPS.println(s.toString());
        }
        return headNodeGroups;
    }

    protected TracedHeadAnalysis(@NonNull MappingRegion mappingRegion) {
        super(mappingRegion);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull Map<@NonNull Node, @NonNull Set<@NonNull Node>> computeTracedTargetFromSources() {
        HashMap<@NonNull Node, @NonNull Set<@NonNull Node>> targetFromSources = new HashMap<Node, Set<Node>>();
        for (Node targetNode : QVTscheduleUtil.getOwnedNodes((Region)this.mappingRegion)) {
            if (!targetNode.isMatched() || targetNode.isConstant()) continue;
            @NonNull Set sources = (Set)targetFromSources.get(targetNode);
            if (sources == null) {
                sources = Sets.newHashSet((Object[])new Node[]{targetNode});
                targetFromSources.put(targetNode, sources);
            }
            for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)targetNode)) {
                Node sourceNode = edge.getEdgeSource();
                if (!sourceNode.isMatched() || sourceNode.isConstant()) continue;
                if (edge instanceof NavigationEdge) {
                    if (((NavigationEdge)edge).isPartial()) continue;
                    sources.add(sourceNode);
                    continue;
                }
                if (edge instanceof CastEdge) {
                    sources.add(sourceNode);
                    continue;
                }
                if (edge instanceof KeyPartEdge) {
                    sources.add(sourceNode);
                    continue;
                }
                if (!(edge instanceof PredicateEdge)) continue;
                sources.add(sourceNode);
            }
        }
        return targetFromSources;
    }

    @Override
    protected @NonNull HeadNodeGroup createHeadNodeGroup(@NonNull List<@NonNull Node> headNodeGroup) {
        return new TracedHeadNodeGroup(headNodeGroup);
    }
}

