/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtm2qvts;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.qvtd.compiler.CompilerOptions;
import org.eclipse.qvtd.compiler.ProblemHandler;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.AbstractQVTb2QVTs;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.AbstractTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.QVTcoreScheduleManager;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.RootRegion;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.ScheduleModel;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.Graphable;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class QVTm2QVTs
extends AbstractQVTb2QVTs {
    public QVTm2QVTs(@NonNull ProblemHandler problemHandler, @NonNull EnvironmentFactory environmentFactory, @Nullable CompilerOptions.StepOptions schedulerOptions) {
        super(new QVTcoreScheduleManager(environmentFactory, problemHandler, schedulerOptions), problemHandler);
    }

    public @NonNull Map<@NonNull RootRegion, Iterable<@NonNull MappingRegion>> transform() throws IOException {
        this.scheduleManager.analyzeSourceModel();
        Iterable<@NonNull AbstractTransformationAnalysis> transformationAnalyses = this.scheduleManager.getOrderedTransformationAnalyses();
        for (AbstractTransformationAnalysis transformationAnalysis : transformationAnalyses) {
            transformationAnalysis.analyzeMappingRegions();
        }
        this.scheduleManager.analyzeOriginalContents();
        Map<@NonNull RootRegion, @NonNull Iterable<@NonNull RuleRegion>> rootRegion2activeRegions = this.scheduleManager.analyzeTransformations();
        for (MappingRegion ruleRegion : QVTscheduleUtil.getOwnedMappingRegions((ScheduleModel)this.scheduleManager.getScheduleModel())) {
            this.scheduleManager.writeDebugGraphs((Graphable)ruleRegion, null);
        }
        HashMap<@NonNull RootRegion, @NonNull Iterable<@NonNull MappingRegion>> rootRegion2mergedRegions = new HashMap<RootRegion, Iterable<MappingRegion>>();
        for (RootRegion rootRegion : rootRegion2activeRegions.keySet()) {
            Iterable<@NonNull RuleRegion> activeRegions = rootRegion2activeRegions.get(rootRegion);
            assert (activeRegions != null);
            rootRegion2mergedRegions.put(rootRegion, Lists.newArrayList(activeRegions));
        }
        return rootRegion2mergedRegions;
    }
}

