/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.merger;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.NodeMerger;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.RegionMerger;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

class EdgeMerger {
    protected final @NonNull RegionMerger regionMerger;
    protected final @NonNull NodeMerger mergedSourceNodeMerger;
    protected final @NonNull NodeMerger mergedTargetNodeMerger;
    protected final @NonNull List<@NonNull Edge> originalEdges = new ArrayList<Edge>();
    private @NonNull Role edgeRole;
    private @Nullable Edge mergedEdge = null;

    public EdgeMerger(@NonNull RegionMerger regionMerger, @NonNull Edge originalEdge) {
        assert (!originalEdge.isSecondary());
        this.regionMerger = regionMerger;
        this.mergedSourceNodeMerger = regionMerger.getNodeMerger(originalEdge.getEdgeSource());
        this.mergedTargetNodeMerger = regionMerger.getNodeMerger(originalEdge.getEdgeTarget());
        this.originalEdges.add(originalEdge);
        this.edgeRole = QVTscheduleUtil.getEdgeRole((Edge)originalEdge);
        regionMerger.mapOriginalEdge(originalEdge, this);
        this.mergedSourceNodeMerger.addOutgoingEdgeMerger(this, this.mergedTargetNodeMerger);
        this.mergedTargetNodeMerger.addIncomingEdgeMerger(this, this.mergedSourceNodeMerger);
    }

    public void addOriginalEdge(@NonNull Edge originalEdge) {
        assert (!originalEdge.isSecondary());
        assert (!this.originalEdges.contains(originalEdge));
        this.originalEdges.add(originalEdge);
        this.edgeRole = QVTscheduleUtil.mergeToMoreKnownPhase((Role)this.edgeRole, (Role)QVTscheduleUtil.getEdgeRole((Edge)originalEdge));
        this.regionMerger.mapOriginalEdge(originalEdge, this);
    }

    public @Nullable Edge createMergedEdge(@NonNull Node sourceNodeMerger, @NonNull Node targetNodeMerger) {
        Edge mergedEdge2 = this.mergedEdge;
        assert (mergedEdge2 == null);
        Iterator<Edge> iterator = this.originalEdges.iterator();
        if (iterator.hasNext()) {
            @NonNull Edge originalEdge = iterator.next();
            mergedEdge2 = this.mergedEdge = originalEdge.createEdge(this.edgeRole, sourceNodeMerger, targetNodeMerger);
        }
        if (mergedEdge2 == null) {
            return null;
        }
        return mergedEdge2;
    }

    public void destroy() {
        this.mergedSourceNodeMerger.removeOutgoingEdgeMerger(this, this.mergedTargetNodeMerger);
        this.mergedTargetNodeMerger.removeIncomingEdgeMerger(this, this.mergedSourceNodeMerger);
        for (Edge originalEdge : this.originalEdges) {
            this.regionMerger.unmapOriginalEdge(originalEdge, this);
        }
    }

    public @NonNull Edge getMergedEdge() {
        return (Edge)ClassUtil.nonNullState((Object)this.mergedEdge);
    }

    public @NonNull Iterable<@NonNull Edge> getOriginalEdges() {
        return this.originalEdges;
    }

    public @NonNull Node getOriginalSource() {
        return this.getPrimaryEdge().getEdgeSource();
    }

    public @NonNull Node getOriginalTarget() {
        return this.getPrimaryEdge().getEdgeTarget();
    }

    private @NonNull Edge getPrimaryEdge() {
        return this.originalEdges.get(0);
    }

    public @Nullable Property getProperty() {
        Edge primaryEdge = this.getPrimaryEdge();
        if (primaryEdge instanceof NavigationEdge) {
            return QVTscheduleUtil.getReferredProperty((NavigationEdge)((NavigationEdge)primaryEdge));
        }
        return null;
    }

    public @NonNull NodeMerger getSource() {
        return this.mergedSourceNodeMerger;
    }

    public @NonNull NodeMerger getTarget() {
        return this.mergedTargetNodeMerger;
    }

    private boolean isCast() {
        return this.getPrimaryEdge().isCast();
    }

    public boolean isConstant() {
        return this.getPrimaryEdge().isConstant();
    }

    public boolean isFoldable() {
        return this.isCast() && this.mergedTargetNodeMerger.isNew() && !this.mergedSourceNodeMerger.isNew();
    }

    public boolean isLoaded() {
        return this.getPrimaryEdge().isLoaded();
    }

    public boolean isNew() {
        return this.getPrimaryEdge().isNew();
    }

    public boolean isOld() {
        return this.getPrimaryEdge().isOld();
    }

    public boolean isUnconditional() {
        return this.getPrimaryEdge().isUnconditional();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @Nullable Edge sameEdge(@NonNull Edge mergedEdge) {
        if (mergedEdge instanceof NavigationEdge) {
            Property mergedProperty = QVTscheduleUtil.getReferredProperty((NavigationEdge)((NavigationEdge)mergedEdge));
            for (Edge originalEdge : this.originalEdges) {
                Property originalProperty;
                if (!(originalEdge instanceof NavigationEdge) || (originalProperty = QVTscheduleUtil.getReferredProperty((NavigationEdge)((NavigationEdge)originalEdge))) != mergedProperty) continue;
                return originalEdge;
            }
        } else {
            Class<@NonNull ?> mergedClass = mergedEdge.getClass();
            for (Edge originalEdge : this.originalEdges) {
                Class<@NonNull ?> originalClass = originalEdge.getClass();
                if (originalClass != mergedClass) continue;
                return originalEdge;
            }
        }
        return null;
    }

    public String toString() {
        return this.mergedEdge != null ? this.mergedEdge.toString() : this.getPrimaryEdge().toString();
    }
}

