/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ui.wizards.project;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.m2m.internal.qvt.oml.builder.QvtBuilderConfig;
import org.eclipse.m2m.internal.qvt.oml.ui.QVTUIPlugin;
import org.eclipse.m2m.internal.qvt.oml.ui.QvtPluginImages;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.INewQVTElementDestinationWizardDelegate;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.Messages;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.NewQVTProjectContentPage;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.NewQVTProjectCreationPage;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.QVTProjectFieldData;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.QVTWizardListSelectionPage;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.SourceContainerUpdater;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.plugin.NewProjectCreationOperation;
import org.eclipse.pde.ui.IFieldData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class NewQVTProjectWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private QVTProjectFieldData fMDAProjectFieldData;
    private NewQVTProjectCreationPage fMainPage;
    private NewQVTProjectContentPage fContentPage;
    private IConfigurationElement fConfig;
    private WizardSelectionPage fWizardSelectionPage;
    private boolean fIsFinishPerformed;
    protected IWorkbench fWorkbench;

    public NewQVTProjectWizard() {
        this.setDefaultPageImageDescriptor(QvtPluginImages.getInstance().getImageDescriptor("new_project_wizard"));
        this.setWindowTitle(Messages.NewTransformationProjectWizard_Title);
        this.setNeedsProgressMonitor(true);
        this.fMDAProjectFieldData = QVTProjectFieldData.Factory.INSTANCE.create();
        this.fIsFinishPerformed = false;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fWorkbench = workbench;
    }

    public void addPages() {
        super.addPages();
        this.fMainPage = new NewQVTProjectCreationPage("main", this.fMDAProjectFieldData);
        this.fMainPage.setTitle(Messages.NewTransformationProject_Title);
        this.fMainPage.setDescription(Messages.NewTransformationProject_Description);
        this.addPage((IWizardPage)this.fMainPage);
        this.fContentPage = new NewQVTProjectContentPage("page2", this.fMainPage, this.fMDAProjectFieldData);
        this.fWizardSelectionPage = new QVTWizardListSelectionPage(this.getDestinationProvider());
        this.addPage((IWizardPage)this.fContentPage);
        this.addPage((IWizardPage)this.fWizardSelectionPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = super.getNextPage(page);
        if (nextPage == this.fContentPage && !this.fMainPage.isCreatePlugin()) {
            nextPage = this.fWizardSelectionPage;
        }
        return nextPage;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        Object prevPage = super.getPreviousPage(page);
        if (prevPage == this.fContentPage && !this.fMainPage.isCreatePlugin()) {
            prevPage = this.fMainPage;
        }
        return prevPage;
    }

    public boolean canFinish() {
        IWizardPage page = this.getContainer().getCurrentPage();
        return super.canFinish() && page != this.fMainPage;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        this.fConfig = config;
    }

    private WorkspaceModifyOperation createNewSimpleProjectOperation() {
        final IProject newProjectHandle = this.fMainPage.getProjectHandle();
        URI location = null;
        if (!this.fMainPage.useDefaults()) {
            location = this.fMainPage.getLocationURI();
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
        description.setLocationURI(location);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                NewQVTProjectWizard.this.createProject(description, newProjectHandle, monitor);
                NewQVTProjectWizard.this.doPostCreateProjectAction(newProjectHandle, monitor);
            }
        };
        return op;
    }

    private WorkspaceModifyOperation createNewPluginProjectOperation() {
        final IProjectProvider projectProvider = new IProjectProvider(){

            public String getProjectName() {
                return NewQVTProjectWizard.this.fMainPage.getProjectName();
            }

            public IProject getProject() {
                return NewQVTProjectWizard.this.fMainPage.getProjectHandle();
            }

            public IPath getLocationPath() {
                return NewQVTProjectWizard.this.fMainPage.getLocationPath();
            }
        };
        return new NewProjectCreationOperation((IFieldData)this.fMDAProjectFieldData, projectProvider, null){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                super.execute(monitor);
                NewQVTProjectWizard.this.doPostCreateProjectAction(projectProvider.getProject(), monitor);
            }
        };
    }

    void createProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask("", 2000);
            projectHandle.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        }
        finally {
            monitor.done();
        }
    }

    public boolean performFinish() {
        if (this.fIsFinishPerformed) {
            return true;
        }
        try {
            this.fMainPage.updateData();
            this.fContentPage.updateData();
            if (this.fConfig != null) {
                BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfig);
            }
            if (this.fMDAProjectFieldData.isSimple()) {
                this.fMDAProjectFieldData.setDoGenerateClass(false);
            }
            WorkspaceModifyOperation operation = this.fMainPage.isCreatePlugin() ? this.createNewPluginProjectOperation() : this.createNewSimpleProjectOperation();
            this.getContainer().run(false, true, (IRunnableWithProgress)operation);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e) {
            QVTUIPlugin.log(e);
            String title = Messages.NewQVTProjectWizard_Error;
            String message = Messages.NewQVTProjectWizard_ErrorSeeLog;
            Exception exc = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e;
            Status status = new Status(4, "org.eclipse.m2m.qvt.oml.ui", 4, message, (Throwable)exc);
            ErrorDialog.openError((Shell)this.getShell(), (String)title, (String)e.getMessage(), (IStatus)status);
            return false;
        }
        this.fIsFinishPerformed = true;
        return true;
    }

    private void doPostCreateProjectAction(IProject createdProject, IProgressMonitor monitor) throws CoreException {
        IContainer srcContainer = this.fMainPage.getQVTSourceContainerHandle();
        if (srcContainer instanceof IFolder) {
            SourceContainerUpdater.ensureDestinationExists((IFolder)srcContainer, monitor);
        }
        QvtBuilderConfig qvtConfig = QvtBuilderConfig.getConfig((IProject)createdProject);
        qvtConfig.setSourceContainer(srcContainer);
        qvtConfig.addTransformationNature();
        monitor.worked(1);
    }

    private INewQVTElementDestinationWizardDelegate getDestinationProvider() {
        assert (this.fMainPage != null);
        return new INewQVTElementDestinationWizardDelegate(){

            public IProject getProjectHandle() {
                return NewQVTProjectWizard.this.fMainPage.getProjectHandle();
            }

            public IContainer getSourceContainer() {
                return NewQVTProjectWizard.this.fMainPage.getQVTSourceContainerHandle();
            }

            public boolean createDestination() {
                return NewQVTProjectWizard.this.performFinish();
            }
        };
    }
}

