/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.m2m.internal.qvt.oml.builder.QvtBuilder;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledModule;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.ActionMessages;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.BracketInserter;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.ColorManager;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.IQVTReconcilingListener;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtConfiguration;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtDocumentProvider;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtEditorSelectionChangedListener;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtPairMatcher;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtReconciler;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtSourceViewer;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.actions.OpenDeclarationAction;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.outline.QvtOutlineContentProvider;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.outline.QvtOutlineInput;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.outline.QvtOutlineLabelProvider;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.outline.QvtOutlineNodeSelector;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.outline.QvtOutlineSelectionListener;
import org.eclipse.m2m.internal.qvt.oml.emf.util.Logger;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtEditor
extends TextEditor {
    private static final String QVT_EDITOR_UI_CONTEXT = "org.eclipse.m2m.qvt.oml.editor.ui.context";
    public static final String ID = "org.eclipse.m2m.qvt.oml.editor.ui.QvtEditor";
    protected static final String MATCHING_BRACKETS = "matchingBrackets";
    protected static final String MATCHING_BRACKETS_COLOR = "matchingBracketsColor";
    private QvtReconciler fReconciler;
    private ProjectionSupport myProjectionSupport;
    private Annotation[] myOldAnnotations = new Annotation[0];
    private ContentOutlinePage myOutlinePage;
    private TreeViewer myTreeViewer;
    private ColorManager myColorManager;
    protected static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']'};
    private QvtPairMatcher myBracketMatcher = new QvtPairMatcher(BRACKETS);
    private QvtEditorSelectionChangedListener mySelectionChangedListener;
    private QvtOutlineSelectionListener myOutlineSelectionListener;
    private QvtOutlineNodeSelector myOutlineSelector;
    private BracketInserter myBracketInserter;
    private ASTProvider fASTProvider;
    private Object fASTProviderLock = new Object();
    private QvtBuilder.BuildListener myBuildListener = new QvtBuilder.BuildListener(){

        public void buildPerformed() {
        }
    };

    public QvtEditor() {
        this.myColorManager = new ColorManager();
        this.setSourceViewerConfiguration(new QvtConfiguration(this, this.myColorManager));
        this.setDocumentProvider((IDocumentProvider)new QvtDocumentProvider());
        this.setRulerContextMenuId("#QvtEditorRulerContext");
        this.setEditorContextMenuId("#QvtEditorContext");
        QvtBuilder.addBuildListener((QvtBuilder.BuildListener)this.myBuildListener);
    }

    void setReconciler(QvtReconciler reconciler) {
        this.fReconciler = reconciler;
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{QVT_EDITOR_UI_CONTEXT});
    }

    public void dispose() {
        if (this.myBracketMatcher != null) {
            this.myBracketMatcher.dispose();
            this.myBracketMatcher = null;
        }
        if (this.myColorManager != null) {
            this.myColorManager.dispose();
            this.myColorManager = null;
        }
        if (this.mySelectionChangedListener != null) {
            this.mySelectionChangedListener.uninstall();
            this.mySelectionChangedListener = null;
        }
        if (this.myBuildListener != null) {
            QvtBuilder.removeBuildListener((QvtBuilder.BuildListener)this.myBuildListener);
            this.myBuildListener = null;
        }
        if (this.fASTProvider != null) {
            this.fASTProvider.dispose();
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor progress) {
        super.doSave(progress);
        this.refresh();
    }

    public void selectionChanged(TextSelection selection) {
        if (this.myTreeViewer != null && !this.myTreeViewer.getControl().isDisposed()) {
            this.myTreeViewer.removeSelectionChangedListener((ISelectionChangedListener)this.myOutlineSelectionListener);
            this.myOutlineSelector.selectCorrespondingNode(selection);
            this.myTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this.myOutlineSelectionListener);
        }
    }

    public Object getAdapter(Class required) {
        if (IContentOutlinePage.class.equals((Object)required)) {
            return this.myOutlinePage;
        }
        if (IShowInTargetList.class.equals((Object)required)) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.ui.views.ResourceNavigator", "org.eclipse.jdt.ui.PackageExplorer"};
                }
            };
        }
        return super.getAdapter(required);
    }

    public void forceReconciling() {
        if (this.fReconciler != null) {
            this.fReconciler.doForceReconciling();
        }
    }

    public ISourceViewer getSourceViewerOpened() {
        return this.getSourceViewer();
    }

    public void createPartControl(Composite parent) {
        this.setHelpContextId("org.eclipse.m2m.qvt.oml._editor");
        super.createPartControl(parent);
        this.initASTProvider();
        this.getPreferenceStore().setValue(MATCHING_BRACKETS, true);
        this.getPreferenceStore().setValue(MATCHING_BRACKETS_COLOR, StringConverter.asString((RGB)new RGB(196, 196, 196)));
        this.myOutlinePage = new ContentOutlinePage(){

            public void createControl(Composite parent) {
                super.createControl(parent);
                QvtEditor.this.myTreeViewer = this.getTreeViewer();
                QvtEditor.this.myTreeViewer.setContentProvider((IContentProvider)new QvtOutlineContentProvider());
                QvtEditor.this.myTreeViewer.setLabelProvider((IBaseLabelProvider)new QvtOutlineLabelProvider());
                QvtEditor.this.myOutlineSelectionListener = new QvtOutlineSelectionListener(QvtEditor.this.getSourceViewerOpened());
                QvtEditor.this.myTreeViewer.addSelectionChangedListener((ISelectionChangedListener)QvtEditor.this.myOutlineSelectionListener);
                QvtEditor.this.myTreeViewer.addDoubleClickListener((IDoubleClickListener)QvtEditor.this.myOutlineSelectionListener);
                QvtEditor.this.myOutlineSelector = new QvtOutlineNodeSelector(QvtEditor.this.myTreeViewer);
                QvtEditor.this.myTreeViewer.setInput((Object)new QvtOutlineInput());
                QvtEditor.this.myTreeViewer.getControl().addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        QvtEditor.this.myTreeViewer.removeSelectionChangedListener((ISelectionChangedListener)QvtEditor.this.myOutlineSelectionListener);
                        QvtEditor.this.myTreeViewer.removeDoubleClickListener((IDoubleClickListener)QvtEditor.this.myOutlineSelectionListener);
                        QvtEditor.this.myTreeViewer = null;
                        QvtEditor.this.myOutlineSelectionListener = null;
                        QvtEditor.this.myOutlineSelector = null;
                    }
                });
                QvtEditor.this.refresh();
            }
        };
        this.mySelectionChangedListener = new QvtEditorSelectionChangedListener(this);
        this.mySelectionChangedListener.install();
        this.myProjectionSupport = new ProjectionSupport(this.getProjectionSourceViewer(), this.getAnnotationAccess(), this.getSharedColors());
        this.myProjectionSupport.install();
        this.getProjectionSourceViewer().doOperation(19);
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension) {
            if (this.myBracketInserter == null) {
                this.myBracketInserter = new BracketInserter(this.getSourceViewer());
            }
            ((ITextViewerExtension)sourceViewer).prependVerifyKeyListener((VerifyKeyListener)this.myBracketInserter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initASTProvider() {
        Object object = this.fASTProviderLock;
        synchronized (object) {
            this.fASTProvider = new ASTProvider();
            this.fASTProviderLock.notifyAll();
        }
    }

    public void updateFoldingStructure(List<Position> positions) {
        if (this.getProjectionSourceViewer() == null || this.getProjectionSourceViewer().getProjectionAnnotationModel() == null) {
            return;
        }
        Annotation[] annotations = new Annotation[positions.size()];
        ProjectionAnnotationModel model = this.getProjectionSourceViewer().getProjectionAnnotationModel();
        ArrayList annotationsToRemove = new ArrayList(Arrays.asList(this.myOldAnnotations));
        HashMap<Position, Annotation> oldPositions = new HashMap<Position, Annotation>();
        int i = 0;
        while (i < this.myOldAnnotations.length) {
            Annotation annotation = this.myOldAnnotations[i];
            oldPositions.put(model.getPosition(annotation), annotation);
            ++i;
        }
        HashMap<ProjectionAnnotation, Position> newAnnotations = new HashMap<ProjectionAnnotation, Position>();
        int i2 = 0;
        while (i2 < positions.size()) {
            Position position = positions.get(i2);
            ProjectionAnnotation annotation = (ProjectionAnnotation)oldPositions.get(position);
            if (annotation == null) {
                annotation = new ProjectionAnnotation();
                newAnnotations.put(annotation, position);
            } else {
                annotationsToRemove.remove(annotation);
            }
            annotations[i2] = annotation;
            ++i2;
        }
        model.replaceAnnotations(annotationsToRemove.toArray(new Annotation[annotationsToRemove.size()]), newAnnotations);
        this.myOldAnnotations = annotations;
    }

    private ProjectionViewer getProjectionSourceViewer() {
        return (ProjectionViewer)this.getSourceViewer();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        try {
            super.init(site, input);
        }
        catch (PartInitException e) {
            Logger.getLogger().log(Logger.SEVERE, "Failed to initialize QVT editor", e);
            throw e;
        }
    }

    public int getTabWidth() {
        return this.getSourceViewerConfiguration().getTabWidth(this.getSourceViewer());
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        support.setCharacterPairMatcher((ICharacterPairMatcher)this.myBracketMatcher);
        support.setMatchingCharacterPainterPreferenceKeys(MATCHING_BRACKETS, MATCHING_BRACKETS_COLOR);
        super.configureSourceViewerDecorationSupport(support);
    }

    protected void createActions() {
        super.createActions();
        Object action = new ContentAssistAction(ActionMessages.getResourceBundle(), "ContentAssistProposal.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
        this.markAsStateDependentAction("ContentAssistProposal", true);
        action = new OpenDeclarationAction(ActionMessages.getResourceBundle(), "OpenDeclaration", (ITextEditor)this);
        this.setAction(action.getActionDefinitionId(), (IAction)action);
        action = new TextOperationAction(ActionMessages.getResourceBundle(), "ShowOutline.", (ITextEditor)this, 100, true);
        action.setActionDefinitionId("org.eclipse.m2m.qvt.oml.editor.ui.show.outline");
        this.setAction("org.eclipse.m2m.qvt.oml.editor.ui.show.outline", (IAction)action);
    }

    public void refresh() {
        IWorkbenchPartSite s = this.getSite();
        if (s == null) {
            return;
        }
        if (s.getShell() == null || s.getShell().isDisposed() || s.getShell().getDisplay() == null || s.getShell().getDisplay().isDisposed()) {
            return;
        }
        s.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                CompiledModule mm;
                if (QvtEditor.this.myTreeViewer != null && !QvtEditor.this.myTreeViewer.getControl().isDisposed() && (mm = ((QvtDocumentProvider)QvtEditor.this.getDocumentProvider()).getCompiledModule()) != null) {
                    QvtOutlineInput input = (QvtOutlineInput)QvtEditor.this.myTreeViewer.getInput();
                    input.mappingModuleUpdated(mm.getSyntaxElement());
                    QvtEditor.this.myTreeViewer.refresh();
                    QvtEditor.this.selectionChanged((TextSelection)QvtEditor.this.getSelectionProvider().getSelection());
                }
            }
        });
    }

    public IAnnotationModel getAnnotationModel() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        return sourceViewer != null ? sourceViewer.getAnnotationModel() : null;
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        QvtSourceViewer viewer = new QvtSourceViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    public QvtConfiguration getQvtConfiguration() {
        return (QvtConfiguration)this.getSourceViewerConfiguration();
    }

    public ISourceViewer getEditorSourceViewer() {
        return this.getSourceViewer();
    }

    public CompiledModule getValidCompiledModule(long timeoutInMilisec) {
        return this.fASTProvider.getValidCompiledModule(timeoutInMilisec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    IQVTReconcilingListener getReconcilingListener() {
        Object object = this.fASTProviderLock;
        synchronized (object) {
            while (true) {
                if (this.fASTProvider != null) {
                    return this.fASTProvider;
                }
                try {
                    this.fASTProviderLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class ASTProvider
    implements IQVTReconcilingListener {
        private IDocumentListener fDocListener;
        private boolean fNeedsReconciling = true;
        private long fModifyTimeStamp = 0L;
        private long fStartReconcileTimeStamp = 0L;
        private Object fLock = new Object();

        public ASTProvider() {
            IDocument doc = this.getDoc();
            if (doc == null) {
                throw new IllegalStateException("Editor source viewer document must be available");
            }
            this.fDocListener = new IDocumentListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void documentAboutToBeChanged(DocumentEvent event) {
                    Object object = ASTProvider.this.fLock;
                    synchronized (object) {
                        ASTProvider.this.fNeedsReconciling = true;
                        ASTProvider.this.fModifyTimeStamp = event.fModificationStamp;
                    }
                }

                public void documentChanged(DocumentEvent event) {
                }
            };
            doc.addDocumentListener(this.fDocListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public CompiledModule getValidCompiledModule(long timeoutInMilisec) {
            QvtDocumentProvider documentProvider = (QvtDocumentProvider)QvtEditor.this.getDocumentProvider();
            Object object = this.fLock;
            synchronized (object) {
                while (this.fNeedsReconciling) {
                    try {
                        this.fLock.wait(timeoutInMilisec);
                        if (!this.fNeedsReconciling) continue;
                        return null;
                    }
                    catch (InterruptedException interruptedException) {
                        return null;
                    }
                }
                return documentProvider.getCompiledModule();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void aboutToBeReconciled() {
            Object object = this.fLock;
            synchronized (object) {
                this.fStartReconcileTimeStamp = this.fModifyTimeStamp;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reconciled(CompiledModule ast) {
            Object object = this.fLock;
            synchronized (object) {
                if (this.fModifyTimeStamp == this.fStartReconcileTimeStamp) {
                    this.fNeedsReconciling = false;
                }
                this.fLock.notifyAll();
            }
        }

        private IDocument getDoc() {
            ISourceViewer viewer = QvtEditor.this.getEditorSourceViewer();
            if (viewer != null) {
                return viewer.getDocument();
            }
            return null;
        }

        void dispose() {
            IDocument doc = this.getDoc();
            if (doc != null) {
                doc.removeDocumentListener(this.fDocListener);
            }
        }
    }
}

