/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.compiler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.compiler.IImportResolver;

public interface IImportResolverFactory {
    public boolean isAccepted(Object var1);

    public IImportResolver createResolver(Object var1);

    public static interface Registry {
        public static final String POINT_ID = "org.eclipse.m2m.qvt.oml.importResolverFactory";
        public static final String CLASS_ATTR = "class";
        public static final Registry INSTANCE = new Registry(){
            private List<IImportResolverFactory> factories = this.readFactories();

            @Override
            public IImportResolverFactory getFactory(Object source) {
                for (IImportResolverFactory nextFactory : this.factories) {
                    if (!nextFactory.isAccepted(source)) continue;
                    return nextFactory;
                }
                throw new IllegalStateException("No import resolver factory available for: " + source);
            }

            private List<IImportResolverFactory> readFactories() {
                ArrayList<IImportResolverFactory> factoryEntries = new ArrayList<IImportResolverFactory>();
                IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
                IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint(Registry.POINT_ID);
                if (extensionPoint != null) {
                    IExtension[] allExtensions;
                    IExtension[] iExtensionArray = allExtensions = extensionPoint.getExtensions();
                    int n = allExtensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IExtension nextExtension = iExtensionArray[n2];
                        IConfigurationElement[] elements = nextExtension.getConfigurationElements();
                        Object factoryObj = null;
                        try {
                            factoryObj = elements[0].createExecutableExtension(Registry.CLASS_ATTR);
                            if (factoryObj instanceof IImportResolverFactory) {
                                factoryEntries.add((IImportResolverFactory)factoryObj);
                            }
                        }
                        catch (CoreException e) {
                            QvtPlugin.log(e);
                        }
                        ++n2;
                    }
                }
                return factoryEntries;
            }
        };

        public IImportResolverFactory getFactory(Object var1);
    }
}

