/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.tools.coverage.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.m2m.internal.qvt.oml.tools.coverage.ui.CoverageAnnotator;
import org.eclipse.m2m.internal.qvt.oml.tools.coverage.ui.CoverageModel;
import org.eclipse.m2m.internal.qvt.oml.tools.coverage.ui.ProjectCoverageModel;
import org.eclipse.m2m.internal.qvt.oml.tools.coverage.ui.TransformationCoverageModel;
import org.eclipse.m2m.qvt.oml.tools.coverage.Activator;
import org.eclipse.m2m.qvt.oml.tools.coverage.ui.CoveragePlugin;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;

public class CoverageView
extends ViewPart {
    public static final String VIEW_ID = "org.eclipse.m2m.qvt.oml.tools.coverage.ui.coverageView";
    protected static final int COLUMN_ELEMENT = 0;
    private TreeViewer viewer;
    private CoverageModel coverageModel;
    private Composite myParent;

    public void createPartControl(Composite parent) {
        this.myParent = parent;
        this.loadViewer();
    }

    private void loadViewer() {
        this.viewer = new TreeViewer(this.myParent, 770);
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.getTree().setLinesVisible(true);
        TreeViewerColumn column0 = new TreeViewerColumn(this.viewer, 16384);
        column0.getColumn().setText("Module");
        column0.getColumn().setWidth(200);
        column0.setLabelProvider((CellLabelProvider)new PathLabelProvider());
        TreeViewerColumn column00 = new TreeViewerColumn(this.viewer, 16384);
        column00.getColumn().setText("Total function coverage");
        column00.getColumn().setWidth(150);
        column00.setLabelProvider((CellLabelProvider)new TotalLabelProvider());
        TreeViewerColumn column1 = new TreeViewerColumn(this.viewer, 16384);
        column1.getColumn().setText("Mapping Coverage");
        column1.getColumn().setWidth(130);
        column1.setLabelProvider((CellLabelProvider)new MappingLabelProvider());
        TreeViewerColumn column2 = new TreeViewerColumn(this.viewer, 16384);
        column2.getColumn().setText("Helper Coverage");
        column2.getColumn().setWidth(130);
        column2.setLabelProvider((CellLabelProvider)new HelperLabelProvider());
        TreeViewerColumn column3 = new TreeViewerColumn(this.viewer, 16384);
        column3.getColumn().setText("Constructor Coverage");
        column3.getColumn().setWidth(130);
        column3.setLabelProvider((CellLabelProvider)new ConstructorLabelProvider());
        TreeViewerColumn column4 = new TreeViewerColumn(this.viewer, 16384);
        column4.getColumn().setText("Estimated Expression Coverage");
        column4.getColumn().setWidth(200);
        column4.setLabelProvider((CellLabelProvider)new ExpressionLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.addDoubleClickListener((IDoubleClickListener)new TransformationClickListener());
    }

    public void clear() {
        this.removeMarkers();
    }

    private void removeMarkers() {
        if (this.coverageModel == null) {
            return;
        }
        ProjectCoverageModel[] projectCoverageModelArray = this.coverageModel.getProjectModels();
        int n = projectCoverageModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectCoverageModel pcm = projectCoverageModelArray[n2];
            TransformationCoverageModel[] transformationCoverageModelArray = pcm.getTransformationModels();
            int n3 = transformationCoverageModelArray.length;
            int n4 = 0;
            while (n4 < n3) {
                TransformationCoverageModel tcm = transformationCoverageModelArray[n4];
                IFile file = tcm.getFile();
                CoverageAnnotator annotator = new CoverageAnnotator();
                annotator.removeAnnotations(file);
                ++n4;
            }
            ++n2;
        }
    }

    public void setLoading(boolean loading) {
        if (loading) {
            this.viewer.getTree().setLinesVisible(false);
        } else {
            this.viewer.getTree().setLinesVisible(true);
        }
    }

    public void update(CoverageModel model) {
        if (this.viewer == null) {
            this.loadViewer();
        }
        this.removeMarkers();
        this.coverageModel = model;
        this.viewer.setInput((Object)this.coverageModel);
        this.viewer.expandAll();
    }

    private String formatCoverage(int untouched, int touched) {
        int total = untouched + touched;
        double percent = this.computePercent(total, touched);
        return String.valueOf((int)(percent * 100.0)) + "% (" + touched + " of " + total + ")";
    }

    private double computePercent(int total, int touched) {
        double percent = total == 0 ? 1.0 : (double)touched / (double)total;
        return percent;
    }

    public void setFocus() {
    }

    public void dispose() {
        this.clear();
        this.myParent = null;
    }

    abstract class ColoredLabelProvider
    extends ColumnLabelProvider {
        ColoredLabelProvider() {
        }

        public abstract int getUntouchedNodesCount(ProjectCoverageModel var1);

        public abstract int getTouchedNodesCount(ProjectCoverageModel var1);

        public abstract int getUntouchedNodesCount(TransformationCoverageModel var1);

        public abstract int getTouchedNodesCount(TransformationCoverageModel var1);

        public String getText(Object element) {
            if (element instanceof ProjectCoverageModel) {
                return CoverageView.this.formatCoverage(this.getUntouchedNodesCount((ProjectCoverageModel)element), this.getTouchedNodesCount((ProjectCoverageModel)element));
            }
            if (element instanceof TransformationCoverageModel) {
                return CoverageView.this.formatCoverage(this.getUntouchedNodesCount((TransformationCoverageModel)element), this.getTouchedNodesCount((TransformationCoverageModel)element));
            }
            return "";
        }

        public Color getBackground(Object element) {
            int touched = 0;
            int untouched = 0;
            if (element instanceof TransformationCoverageModel) {
                touched = this.getTouchedNodesCount((TransformationCoverageModel)element);
                untouched = this.getUntouchedNodesCount((TransformationCoverageModel)element);
            } else if (element instanceof ProjectCoverageModel) {
                touched = this.getTouchedNodesCount((ProjectCoverageModel)element);
                untouched = this.getUntouchedNodesCount((ProjectCoverageModel)element);
            }
            double percent = CoverageView.this.computePercent(touched + untouched, touched);
            if (percent * 100.0 >= (double)CoveragePlugin.getDefault().getPreferenceStore().getInt("org.eclipse.m2m.qvt.oml.tools.coverage.threshold.high")) {
                return new Color((Device)Display.getCurrent(), 154, 205, 50);
            }
            if (percent * 100.0 < (double)CoveragePlugin.getDefault().getPreferenceStore().getInt("org.eclipse.m2m.qvt.oml.tools.coverage.threshold.low")) {
                return new Color((Device)Display.getCurrent(), 250, 128, 114);
            }
            return super.getBackground(element);
        }

        public Font getFont(Object element) {
            if (element instanceof ProjectCoverageModel) {
                Font afont = new Font((Device)Display.getCurrent(), "Arial", 8, 1);
                return afont;
            }
            return super.getFont(element);
        }
    }

    class ConstructorLabelProvider
    extends ColoredLabelProvider {
        ConstructorLabelProvider() {
        }

        @Override
        public int getTouchedNodesCount(TransformationCoverageModel model) {
            return model.getTouchedConstructorNodes().size();
        }

        @Override
        public int getUntouchedNodesCount(TransformationCoverageModel model) {
            return model.getUntouchedConstructorNodes().size();
        }

        @Override
        public int getTouchedNodesCount(ProjectCoverageModel model) {
            return model.getTouchedConstructorNodes().size();
        }

        @Override
        public int getUntouchedNodesCount(ProjectCoverageModel model) {
            return model.getUntouchedConstructorNodes().size();
        }
    }

    class ExpressionLabelProvider
    extends ColoredLabelProvider {
        ExpressionLabelProvider() {
        }

        @Override
        public int getTouchedNodesCount(TransformationCoverageModel model) {
            return model.getTouchedExpressionNodes().size();
        }

        @Override
        public int getUntouchedNodesCount(TransformationCoverageModel model) {
            return model.getUntouchedExpressionNodes().size();
        }

        @Override
        public int getTouchedNodesCount(ProjectCoverageModel model) {
            return model.getTouchedExpressionNodes().size();
        }

        @Override
        public int getUntouchedNodesCount(ProjectCoverageModel model) {
            return model.getUntouchedExpressionNodes().size();
        }
    }

    class HelperLabelProvider
    extends ColoredLabelProvider {
        HelperLabelProvider() {
        }

        @Override
        public int getTouchedNodesCount(TransformationCoverageModel model) {
            return model.getTouchedHelperNodes().size();
        }

        @Override
        public int getUntouchedNodesCount(TransformationCoverageModel model) {
            return model.getUntouchedHelperNodes().size();
        }

        @Override
        public int getTouchedNodesCount(ProjectCoverageModel model) {
            return model.getTouchedHelperNodes().size();
        }

        @Override
        public int getUntouchedNodesCount(ProjectCoverageModel model) {
            return model.getUntouchedHelperNodes().size();
        }
    }

    class MappingLabelProvider
    extends ColoredLabelProvider {
        MappingLabelProvider() {
        }

        @Override
        public int getTouchedNodesCount(TransformationCoverageModel model) {
            return model.getTouchedMappingNodes().size();
        }

        @Override
        public int getUntouchedNodesCount(TransformationCoverageModel model) {
            return model.getUntouchedMappingNodes().size();
        }

        @Override
        public int getTouchedNodesCount(ProjectCoverageModel model) {
            return model.getTouchedMappingNodes().size();
        }

        @Override
        public int getUntouchedNodesCount(ProjectCoverageModel model) {
            return model.getUntouchedMappingNodes().size();
        }
    }

    class PathLabelProvider
    extends ColumnLabelProvider {
        PathLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ProjectCoverageModel) {
                return ((ProjectCoverageModel)element).getProject().getName();
            }
            if (element instanceof TransformationCoverageModel) {
                return ((TransformationCoverageModel)element).getModule().getName();
            }
            return "";
        }
    }

    class TotalLabelProvider
    extends ColoredLabelProvider {
        TotalLabelProvider() {
        }

        @Override
        public int getTouchedNodesCount(TransformationCoverageModel model) {
            return model.getTouchedMappingNodes().size() + model.getTouchedHelperNodes().size() + model.getTouchedConstructorNodes().size();
        }

        @Override
        public int getUntouchedNodesCount(TransformationCoverageModel model) {
            return model.getUntouchedMappingNodes().size() + model.getUntouchedHelperNodes().size() + model.getUntouchedConstructorNodes().size();
        }

        @Override
        public int getTouchedNodesCount(ProjectCoverageModel model) {
            return model.getTouchedMappingNodes().size() + model.getTouchedHelperNodes().size() + model.getTouchedConstructorNodes().size();
        }

        @Override
        public int getUntouchedNodesCount(ProjectCoverageModel model) {
            return model.getUntouchedMappingNodes().size() + model.getUntouchedHelperNodes().size() + model.getUntouchedConstructorNodes().size();
        }
    }

    class TransformationClickListener
    implements IDoubleClickListener {
        TransformationClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            IStructuredSelection thisSelection = (IStructuredSelection)event.getSelection();
            Object selectedElement = thisSelection.getFirstElement();
            if (selectedElement instanceof TransformationCoverageModel) {
                TransformationCoverageModel transformationModel = (TransformationCoverageModel)selectedElement;
                IFile file = transformationModel.getFile();
                CoverageAnnotator annotator = new CoverageAnnotator();
                annotator.annotateTouched(file, transformationModel.getTouchedRanges());
                annotator.annotateUntouched(file, transformationModel.getUntouchedRanges());
                try {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException e) {
                    Activator.error((String)"Failed to activate coveraged file", (Throwable)e);
                }
            }
        }
    }

    class ViewContentProvider
    implements ITreeContentProvider {
        ViewContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return CoverageView.this.coverageModel.getProjectModels();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ProjectCoverageModel) {
                return ((ProjectCoverageModel)parentElement).getTransformationModels();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof ProjectCoverageModel;
        }
    }
}

