/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.env.IVirtualOperationTable;
import org.eclipse.m2m.internal.qvt.oml.ast.env.VirtualTable;
import org.eclipse.m2m.internal.qvt.oml.ast.env.VirtualTableAdapter;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.ConstructorOperationAdapter;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.IntermediateClassFactory;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstanceFactory;
import org.eclipse.m2m.internal.qvt.oml.expressions.Constructor;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.InstantiationExp;

public class ExecutableXMIHelper {
    private static final String SOURCE_URI_BASE = "http://www.eclipse.org/m2m/1.0.0/QVT";
    private static final String VIRTUAL_TABLE_SOURCE = "http://www.eclipse.org/m2m/1.0.0/QVT/VTable";
    private static final String CONSTRUCTOR_SOURCE = "http://www.eclipse.org/m2m/1.0.0/QVT/constructor";
    private static final String STATIC_SOURCE = "http://www.eclipse.org/m2m/1.0.0/QVT/static";

    public static void fixResourceOnLoad(Resource resource) {
        TreeIterator it = resource.getAllContents();
        while (it.hasNext()) {
            EObject nextObj = (EObject)it.next();
            if (nextObj instanceof Module) {
                Module module = (Module)nextObj;
                module.setEFactoryInstance((EFactory)new ModuleInstanceFactory());
                continue;
            }
            if (nextObj instanceof EOperation) {
                ExecutableXMIHelper.loadVTOperFromAnnotation((EOperation)nextObj);
                continue;
            }
            if (nextObj instanceof InstantiationExp) {
                ExecutableXMIHelper.loadConstructorReferenceFromAnnotation((InstantiationExp)nextObj);
                continue;
            }
            if (nextObj instanceof EPackage) {
                EPackage ePackage = (EPackage)nextObj;
                if (!IntermediateClassFactory.isIntermediatePackage(ePackage)) continue;
                new IntermediateClassFactory(ePackage);
                continue;
            }
            if (!(nextObj instanceof EStructuralFeature)) continue;
            ExecutableXMIHelper.loadStaticFeatureFromAnnotation((EStructuralFeature)nextObj);
        }
    }

    public static void fixResourceOnSave(Resource next) {
        TreeIterator it = next.getAllContents();
        while (it.hasNext()) {
            EObject nextObj = (EObject)it.next();
            if (nextObj instanceof EOperation) {
                ExecutableXMIHelper.saveVTOperTable2Annotation((EOperation)nextObj);
                continue;
            }
            if (nextObj instanceof InstantiationExp) {
                ExecutableXMIHelper.saveConstructorReference((InstantiationExp)nextObj);
                continue;
            }
            if (!(nextObj instanceof EStructuralFeature)) continue;
            ExecutableXMIHelper.saveStaticFeature((EStructuralFeature)nextObj);
        }
    }

    private static void loadConstructorReferenceFromAnnotation(InstantiationExp instantiation) {
        EObject referencedObj;
        EAnnotation annotation = instantiation.getEAnnotation(CONSTRUCTOR_SOURCE);
        if (annotation != null && !annotation.getReferences().isEmpty() && (referencedObj = (EObject)annotation.getReferences().get(0)) instanceof Constructor) {
            instantiation.eAdapters().add((Object)new ConstructorOperationAdapter((Constructor)referencedObj));
        }
    }

    private static void loadVTOperFromAnnotation(EOperation operation) {
        EAnnotation annotation = operation.getEAnnotation(VIRTUAL_TABLE_SOURCE);
        if (annotation != null) {
            VirtualTable vt = VirtualTableAdapter.getAdapter(operation, true).getVirtualTable();
            for (EObject next : annotation.getReferences()) {
                if (!(next instanceof EOperation)) continue;
                vt.addOperation((EOperation)next);
            }
        }
    }

    private static void saveVTOperTable2Annotation(EOperation operation) {
        IVirtualOperationTable virtualTable = IVirtualOperationTable.Access.INSTANCE.getVirtualTable(operation);
        if (virtualTable instanceof VirtualTable) {
            VirtualTable vt = (VirtualTable)virtualTable;
            Collection<EOperation> operations = vt.getOperations();
            EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
            annotation.setSource(VIRTUAL_TABLE_SOURCE);
            for (EOperation next : operations) {
                annotation.getReferences().add((Object)next);
            }
            operation.getEAnnotations().add((Object)annotation);
        }
    }

    private static void saveConstructorReference(InstantiationExp instantiation) {
        ConstructorOperationAdapter constructorAdapter;
        Constructor referredConstructor;
        Adapter adapter = EcoreUtil.getAdapter((List)instantiation.eAdapters(), ConstructorOperationAdapter.class);
        if (adapter != null && (referredConstructor = (constructorAdapter = (ConstructorOperationAdapter)adapter).getReferredConstructor()) != null) {
            EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
            annotation.setSource(CONSTRUCTOR_SOURCE);
            annotation.getReferences().add((Object)referredConstructor);
            instantiation.getEAnnotations().add((Object)annotation);
        }
    }

    private static void saveStaticFeature(EStructuralFeature feature) {
        if (IntermediateClassFactory.isFeatureStatic(feature)) {
            EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
            annotation.setSource(STATIC_SOURCE);
            feature.getEAnnotations().add((Object)annotation);
        }
    }

    private static void loadStaticFeatureFromAnnotation(EStructuralFeature feature) {
        EAnnotation annotation = feature.getEAnnotation(STATIC_SOURCE);
        if (annotation != null) {
            IntermediateClassFactory.markFeatureAsStatic(feature);
        }
    }
}

