/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.compiler.URIUnitResolver;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolver;

public interface UnitResolverFactory {
    public boolean isAccepted(Object var1);

    public UnitResolver getResolver(URI var1);

    public UnitProxy findUnit(URI var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BasicRegistry
    implements Registry {
        private List<UnitResolverFactory> fFactories;

        BasicRegistry() {
            this(Collections.singletonList(new UnitResolverFactory(){

                public UnitProxy findUnit(URI unitURI) {
                    return URIUnitResolver.getUnit(unitURI);
                }

                public UnitResolver getResolver(URI uri) {
                    return new URIUnitResolver(Collections.singletonList(uri.trimSegments(1)));
                }

                public boolean isAccepted(Object source) {
                    return source instanceof URI;
                }
            }));
        }

        BasicRegistry(List<UnitResolverFactory> factories) {
            assert (factories != null);
            this.fFactories = factories;
        }

        @Override
        public UnitResolverFactory getFactory(Object source) {
            for (UnitResolverFactory nextFactory : this.fFactories) {
                if (!nextFactory.isAccepted(source)) continue;
                return nextFactory;
            }
            return null;
        }

        @Override
        public UnitProxy getUnit(URI uri) {
            UnitResolverFactory factory = this.getFactory(uri);
            if (factory != null) {
                return factory.findUnit(uri);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EclipseRegistry
    extends BasicRegistry {
        public EclipseRegistry() {
            super(EclipseRegistry.readFactories());
        }

        private static List<UnitResolverFactory> readFactories() {
            IExtensionRegistry pluginRegistry;
            IExtensionPoint extensionPoint;
            ArrayList<UnitResolverFactory> factoryEntries = new ArrayList<UnitResolverFactory>();
            if (EMFPlugin.IS_ECLIPSE_RUNNING && (extensionPoint = (pluginRegistry = Platform.getExtensionRegistry()).getExtensionPoint("org.eclipse.m2m.qvt.oml.unitResolverFactory")) != null) {
                IExtension[] allExtensions;
                IExtension[] iExtensionArray = allExtensions = extensionPoint.getExtensions();
                int n = allExtensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension nextExtension = iExtensionArray[n2];
                    IConfigurationElement[] elements = nextExtension.getConfigurationElements();
                    Object factoryObj = null;
                    try {
                        factoryObj = elements[0].createExecutableExtension("class");
                        if (factoryObj instanceof UnitResolverFactory) {
                            factoryEntries.add((UnitResolverFactory)factoryObj);
                        }
                    }
                    catch (CoreException e) {
                        QvtPlugin.getDefault().log(e.getStatus());
                    }
                    ++n2;
                }
            }
            return factoryEntries;
        }
    }

    public static interface Registry {
        public static final String POINT_ID = "org.eclipse.m2m.qvt.oml.unitResolverFactory";
        public static final String CLASS_ATTR = "class";
        public static final Registry INSTANCE = EMFPlugin.IS_ECLIPSE_RUNNING ? new EclipseRegistry() : new BasicRegistry();

        public UnitResolverFactory getFactory(Object var1);

        public UnitProxy getUnit(URI var1);
    }
}

