/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.text.IDocument;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompilerUtils;
import org.eclipse.m2m.internal.qvt.oml.compiler.QVTOCompiler;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitContents;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolver;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolverFactory;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.Activator;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.Messages;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtDocumentProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.URIUtils;
import org.eclipse.m2m.internal.qvt.oml.project.builder.QVTOBuilderConfig;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class QvtCompilerFacade {
    private static QvtCompilerFacade ourInstance;

    private QvtCompilerFacade() {
    }

    public CompiledUnit compile(ITextEditor editor, IDocument document, QvtCompilerOptions options, IProgressMonitor monitor) {
        if (!this.checkEditor(editor)) {
            return null;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(Messages.QvtCompilerFacade_compilingDoc, 4);
        CompiledUnit result = null;
        try {
            monitor.subTask(Messages.QvtCompilerFacade_acquiringDoc);
            IFile file = ((FileEditorInput)editor.getEditorInput()).getFile();
            QvtDocumentProvider documentProvider = (QvtDocumentProvider)editor.getDocumentProvider();
            monitor.worked(1);
            String contents = document.get();
            try {
                UnitProxy unit = UnitResolverFactory.Registry.INSTANCE.getUnit(URIUtils.getResourceURI((IResource)file));
                UnitResolver unitResolver = unit.getResolver();
                InMemoryUnitProxy inMemoryUnit = new InMemoryUnitProxy(unit.getNamespace(), unit.getName(), unit.getURI(), contents, unitResolver);
                QVTOCompiler compiler = CompilerUtils.createCompiler();
                result = compiler.compile((UnitProxy)inMemoryUnit, options, CompilerUtils.createMonitor((Monitor)BasicMonitor.toMonitor((IProgressMonitor)monitor), (int)3));
                if (result != null) {
                    documentProvider.setMappingModule(result);
                }
            }
            catch (MdaException e) {
                documentProvider.setMappingModule(result);
                Activator.log(e);
            }
            if (options.isReportErrors()) {
                options.isShowAnnotations();
            }
        }
        finally {
            monitor.done();
        }
        return result;
    }

    public static QvtCompilerFacade getInstance() {
        if (ourInstance == null) {
            ourInstance = new QvtCompilerFacade();
        }
        return ourInstance;
    }

    private boolean checkEditor(ITextEditor editor) {
        return editor != null && editor.getEditorInput() instanceof FileEditorInput && editor.getDocumentProvider() != null;
    }

    static boolean isEditingInQvtSourceContainer(ITextEditor editor) {
        IEditorInput editorInput = editor.getEditorInput();
        if (!(editorInput instanceof IFileEditorInput)) {
            return false;
        }
        IFile file = ((FileEditorInput)editorInput).getFile();
        if (file != null && file.exists()) {
            try {
                IContainer srcContainer = QVTOBuilderConfig.getConfig((IProject)file.getProject()).getSourceContainer();
                if (srcContainer.exists()) {
                    IPath editedPath = file.getFullPath();
                    IPath srcPath = srcContainer.getFullPath();
                    return srcPath.isPrefixOf(editedPath);
                }
            }
            catch (CoreException e) {
                QvtPlugin.getDefault().log((Object)e.getStatus());
            }
        }
        return false;
    }

    static class InMemoryUnitProxy
    extends UnitProxy {
        private final String fContents;
        private final UnitResolver fMyResolver;

        public InMemoryUnitProxy(String namespace, String unitName, URI uri, String fContents, UnitResolver fMyResolver) {
            super(namespace, unitName, uri);
            this.fContents = fContents;
            this.fMyResolver = fMyResolver;
        }

        public UnitContents getContents() throws IOException {
            return new UnitContents.CSTContents(){

                public Reader getContents() throws IOException {
                    return new StringReader(InMemoryUnitProxy.this.fContents);
                }
            };
        }

        public int getContentType() {
            return 0;
        }

        public UnitResolver getResolver() {
            return this.fMyResolver;
        }
    }
}

