/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui;

import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.xtext.ui.editor.validation.XtextAnnotation;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.Issue;

public class MarkerUtil {
    public String getCode(Annotation annotation) {
        if (annotation instanceof MarkerAnnotation) {
            MarkerAnnotation ma = (MarkerAnnotation)annotation;
            return this.getCode(ma.getMarker());
        }
        if (annotation instanceof XtextAnnotation) {
            XtextAnnotation xa = (XtextAnnotation)annotation;
            return xa.getIssueCode();
        }
        return null;
    }

    public String getCode(IMarker marker) {
        return marker.getAttribute("CODE_KEY", null);
    }

    public String[] getIssueData(Annotation annotation) {
        if (annotation instanceof MarkerAnnotation) {
            MarkerAnnotation ma = (MarkerAnnotation)annotation;
            return this.getIssueData(ma.getMarker());
        }
        if (annotation instanceof XtextAnnotation) {
            XtextAnnotation xa = (XtextAnnotation)annotation;
            return xa.getIssueData();
        }
        return null;
    }

    public String[] getIssueData(IMarker marker) {
        return Strings.unpack((String)marker.getAttribute("DATA_KEY", null));
    }

    public URI getUriToProblem(IMarker marker) {
        String uri = marker.getAttribute("URI_KEY", null);
        return uri != null ? URI.createURI((String)uri) : null;
    }

    public URI getUriToProblem(Annotation annotation) {
        if (annotation instanceof MarkerAnnotation) {
            MarkerAnnotation ma = (MarkerAnnotation)annotation;
            return this.getUriToProblem(ma.getMarker());
        }
        if (annotation instanceof XtextAnnotation) {
            XtextAnnotation xa = (XtextAnnotation)annotation;
            return xa.getUriToProblem();
        }
        return null;
    }

    public Issue.Severity getSeverity(IMarker marker) {
        switch (marker.getAttribute("severity", 0)) {
            case 2: {
                return Issue.Severity.ERROR;
            }
            case 1: {
                return Issue.Severity.WARNING;
            }
        }
        return Issue.Severity.INFO;
    }

    public boolean refersToSameIssue(IMarker marker, Annotation annotation) {
        URI markerURI = this.getUriToProblem(marker);
        String markerIssue = this.getCode(marker);
        if (markerURI == null || markerIssue == null) {
            return false;
        }
        return markerURI.equals((Object)this.getUriToProblem(annotation)) && markerIssue.equals(this.getCode(annotation));
    }
}

