/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.folding;

import com.google.common.base.Predicate;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextSyntaxDiagnostic;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.folding.IFoldingRegion;
import org.eclipse.xtext.ui.editor.folding.IFoldingRegionProvider;
import org.eclipse.xtext.ui.editor.folding.IFoldingStructureProvider;
import org.eclipse.xtext.ui.editor.folding.StyledProjectionAnnotation;
import org.eclipse.xtext.ui.editor.model.IXtextModelListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFoldingStructureProvider
implements IFoldingStructureProvider,
IXtextModelListener {
    @Inject
    private IFoldingRegionProvider foldingRegionProvider;
    private XtextEditor editor;
    private ProjectionViewer viewer;
    private ProjectionChangeListener projectionListener;

    @Override
    public void install(XtextEditor editor, ProjectionViewer viewer) {
        Assert.isNotNull((Object)((Object)editor));
        Assert.isNotNull((Object)viewer);
        this.uninstall();
        this.editor = editor;
        this.viewer = viewer;
        this.projectionListener = new ProjectionChangeListener(viewer);
    }

    @Override
    public void initialize() {
        this.calculateProjectionAnnotationModel(false);
    }

    @Override
    public void uninstall() {
        if (this.isInstalled()) {
            this.handleProjectionDisabled();
            this.projectionListener.dispose();
            this.projectionListener = null;
            this.editor = null;
        }
    }

    protected final boolean isInstalled() {
        return this.editor != null;
    }

    @Override
    public void modelChanged(XtextResource resource) {
        if (resource == null) {
            return;
        }
        boolean existingSyntaxErrors = Iterables.any((Iterable)resource.getErrors(), (Predicate)new Predicate<Resource.Diagnostic>(){

            public boolean apply(Resource.Diagnostic diagnostic) {
                return diagnostic instanceof XtextSyntaxDiagnostic;
            }
        });
        if (!existingSyntaxErrors) {
            this.calculateProjectionAnnotationModel(false);
        }
    }

    protected void handleProjectionEnabled() {
        this.handleProjectionDisabled();
        if (this.isInstalled()) {
            this.initialize();
            this.editor.getDocument().addModelListener(this);
        }
    }

    protected void handleProjectionDisabled() {
        if (this.editor.getDocument() != null) {
            this.editor.getDocument().removeModelListener(this);
        }
    }

    protected void calculateProjectionAnnotationModel(boolean allowCollapse) {
        ProjectionAnnotationModel projectionAnnotationModel = this.viewer.getProjectionAnnotationModel();
        if (projectionAnnotationModel != null) {
            List<IFoldingRegion> foldingRegions = this.foldingRegionProvider.getFoldingRegions(this.editor.getDocument());
            HashBiMap<Position, IFoldingRegion> positionsMap = this.toPositionIndexedMap(foldingRegions);
            Annotation[] newRegions = this.mergeFoldingRegions(positionsMap, projectionAnnotationModel);
            this.updateFoldingRegions(allowCollapse, projectionAnnotationModel, positionsMap, newRegions);
        }
    }

    protected HashBiMap<Position, IFoldingRegion> toPositionIndexedMap(List<IFoldingRegion> foldingRegions) {
        HashBiMap positionsMap = Maps.newHashBiMap();
        for (IFoldingRegion foldingRegion : foldingRegions) {
            positionsMap.put((Object)foldingRegion.getPosition(), (Object)foldingRegion);
        }
        return positionsMap;
    }

    protected Annotation[] mergeFoldingRegions(HashBiMap<Position, IFoldingRegion> positionsMap, ProjectionAnnotationModel projectionAnnotationModel) {
        ArrayList<Annotation> deletions = new ArrayList<Annotation>();
        Iterator iterator = projectionAnnotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            Position position;
            Annotation annotation = (Annotation)iterator.next();
            if (!(annotation instanceof ProjectionAnnotation) || positionsMap.remove((Object)(position = projectionAnnotationModel.getPosition(annotation))) != null) continue;
            deletions.add(annotation);
        }
        return deletions.toArray(new Annotation[deletions.size()]);
    }

    protected void updateFoldingRegions(boolean allowCollapse, ProjectionAnnotationModel model, HashBiMap<Position, IFoldingRegion> positionsMap, Annotation[] deletions) {
        HashMap<ProjectionAnnotation, Position> additionsMap = new HashMap<ProjectionAnnotation, Position>();
        for (IFoldingRegion foldingRegion : positionsMap.values()) {
            this.addProjectionAnnotation(allowCollapse, foldingRegion, additionsMap);
        }
        if (deletions.length != 0 || additionsMap.size() != 0) {
            model.modifyAnnotations(deletions, additionsMap, new Annotation[0]);
        }
    }

    protected void addProjectionAnnotation(boolean allowCollapse, IFoldingRegion foldingRegion, Map<ProjectionAnnotation, Position> additionsMap) {
        ProjectionAnnotation projectionAnnotation = this.createProjectionAnnotation(allowCollapse, foldingRegion);
        additionsMap.put(projectionAnnotation, foldingRegion.getPosition());
    }

    protected ProjectionAnnotation createProjectionAnnotation(boolean allowCollapse, IFoldingRegion foldingRegion) {
        return new StyledProjectionAnnotation(allowCollapse, foldingRegion.getAlias());
    }

    public class ProjectionChangeListener
    implements IProjectionListener {
        private ProjectionViewer projectionViewer;

        public ProjectionChangeListener(ProjectionViewer viewer) {
            Assert.isLegal((viewer != null ? 1 : 0) != 0);
            this.projectionViewer = viewer;
            this.projectionViewer.addProjectionListener((IProjectionListener)this);
        }

        public void dispose() {
            if (this.projectionViewer != null) {
                this.projectionViewer.removeProjectionListener((IProjectionListener)this);
                this.projectionViewer = null;
            }
        }

        public void projectionEnabled() {
            DefaultFoldingStructureProvider.this.handleProjectionEnabled();
        }

        public void projectionDisabled() {
            DefaultFoldingStructureProvider.this.handleProjectionDisabled();
        }
    }
}

