/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.clustering;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurrentDescriptions
extends AdapterImpl
implements IResourceDescriptions {
    private final IResourceDescriptions oldState;
    private final Map<URI, IResourceDescription> updatedDescriptions = Maps.newHashMap();

    public CurrentDescriptions(ResourceSet resourceSet, IResourceDescriptions oldState, Set<URI> initiallyDeleted) {
        this.oldState = oldState;
        for (URI uri : initiallyDeleted) {
            this.updatedDescriptions.put(uri, null);
        }
        resourceSet.eAdapters().add((Object)this);
    }

    public void register(IResourceDescription.Delta delta) {
        if (this.updatedDescriptions.containsKey(delta.getUri())) {
            if (this.updatedDescriptions.get(delta.getUri()) != delta.getNew()) {
                throw new IllegalStateException("Cannot register description twice: " + delta.getUri());
            }
            return;
        }
        this.updatedDescriptions.put(delta.getUri(), delta.getNew());
    }

    public Iterable<IResourceDescription> getAllResourceDescriptions() {
        return Iterables.filter((Iterable)Iterables.concat(this.updatedDescriptions.values(), (Iterable)Iterables.filter((Iterable)this.oldState.getAllResourceDescriptions(), (Predicate)new Predicate<IResourceDescription>(){

            public boolean apply(IResourceDescription input) {
                return !CurrentDescriptions.this.updatedDescriptions.containsKey(input.getURI());
            }
        })), (Predicate)Predicates.notNull());
    }

    public IResourceDescription getResourceDescription(URI uri) {
        if (this.updatedDescriptions.containsKey(uri)) {
            return this.updatedDescriptions.get(uri);
        }
        return this.oldState.getResourceDescription(uri);
    }

    public boolean isAdapterForType(Object type) {
        return CurrentDescriptions.class.equals(type);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResourceSetAware
    implements IResourceDescriptions.IContextAware {
        private IResourceDescriptions delegate;

        public void setContext(Notifier ctx) {
            ResourceSet resourceSet = EcoreUtil2.getResourceSet((Notifier)ctx);
            this.delegate = (IResourceDescriptions)EcoreUtil.getAdapter((List)resourceSet.eAdapters(), CurrentDescriptions.class);
        }

        public Iterable<IResourceDescription> getAllResourceDescriptions() {
            return this.delegate.getAllResourceDescriptions();
        }

        public IResourceDescription getResourceDescription(URI uri) {
            return this.delegate.getResourceDescription(uri);
        }
    }
}

